/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmOptionsImpl;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManager;
import org.jetbrains.kotlin.gradle.internal.AnnotationProcessingManagerKt;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginEnvironment;
import org.jetbrains.kotlin.gradle.tasks.CacheableTasksKt;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;
import org.jetbrains.kotlin.gradle.tasks.KotlinTasksProvider;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001aV\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0000\u00a8\u0006\u0014"}, d2={"createKotlinAfterJavaTask", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinCompile;", "Lorg/gradle/api/Project;", "javaTask", "Lorg/gradle/api/tasks/compile/AbstractCompile;", "kotlinTask", "kotlinOptions", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmOptionsImpl;", "tasksProvider", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinTasksProvider;", "initKapt", "Lorg/gradle/api/tasks/compile/JavaCompile;", "kaptManager", "Lorg/jetbrains/kotlin/gradle/internal/AnnotationProcessingManager;", "variantName", "", "subpluginEnvironment", "Lorg/jetbrains/kotlin/gradle/plugin/SubpluginEnvironment;", "androidProjectHandler", "Lorg/jetbrains/kotlin/gradle/plugin/AbstractAndroidProjectHandler;", "kotlin-gradle-plugin"})
public final class AnnotationProcessingManagerKt {
    @Nullable
    public static final KotlinCompile initKapt(@NotNull Project $receiver, @NotNull KotlinCompile kotlinTask, @NotNull JavaCompile javaTask, @NotNull AnnotationProcessingManager kaptManager, @NotNull String variantName, @Nullable KotlinJvmOptionsImpl kotlinOptions, @NotNull SubpluginEnvironment subpluginEnvironment, @NotNull KotlinTasksProvider tasksProvider, @Nullable AbstractAndroidProjectHandler<?> androidProjectHandler) {
        KotlinCompile kotlinAfterJavaTask;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)kotlinTask, (String)"kotlinTask");
        Intrinsics.checkParameterIsNotNull((Object)javaTask, (String)"javaTask");
        Intrinsics.checkParameterIsNotNull((Object)kaptManager, (String)"kaptManager");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        Intrinsics.checkParameterIsNotNull((Object)subpluginEnvironment, (String)"subpluginEnvironment");
        Intrinsics.checkParameterIsNotNull((Object)tasksProvider, (String)"tasksProvider");
        KaptExtension kaptExtension = (KaptExtension)$receiver.getExtensions().getByType(KaptExtension.class);
        Function1<String, Unit> warnUnsupportedKapt1Option$ = new Function1<String, Unit>(kotlinTask){
            final /* synthetic */ KotlinCompile $kotlinTask;

            public final void invoke(@NotNull String optionName) {
                Intrinsics.checkParameterIsNotNull((Object)optionName, (String)"optionName");
                Logger logger = this.$kotlinTask.getLogger();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"kotlinTask.logger");
                GradleUtilsKt.kotlinWarn(logger, '\'' + optionName + "' option is not supported by this kapt implementation. " + "Please add the \"apply plugin: 'kotlin-kapt\" line to your build script to enable it.");
            }
            {
                this.$kotlinTask = kotlinCompile;
                super(1);
            }
        };
        CharSequence charSequence = kaptExtension.getProcessors();
        if (charSequence.length() > 0) {
            warnUnsupportedKapt1Option$.invoke("processors");
        }
        if (kaptExtension.getCorrectErrorTypes()) {
            warnUnsupportedKapt1Option$.invoke("correctErrorTypes");
        }
        if (kaptExtension.getGenerateStubs()) {
            File file;
            kotlinAfterJavaTask = AnnotationProcessingManagerKt.createKotlinAfterJavaTask($receiver, (AbstractCompile)javaTask, kotlinTask, kotlinOptions, tasksProvider);
            Logger logger = kotlinTask.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"kotlinTask.logger");
            GradleUtilsKt.kotlinDebug(logger, "kapt: Using class file stubs");
            File $receiver2 = file = new File($receiver.getBuildDir(), "tmp/kapt/" + variantName + "/classFileStubs");
            $receiver2.mkdirs();
            File stubsDir = file;
            kotlinAfterJavaTask.setDestinationDir(kotlinTask.getDestinationDir());
            kotlinTask.setDestinationDir(stubsDir);
            kotlinTask.getKaptOptions().setGenerateStubs(true);
            kotlinAfterJavaTask.source(kaptManager.getGeneratedKotlinSourceDir());
            kotlinAfterJavaTask.source(kaptManager.getAptOutputDir());
            subpluginEnvironment.addSubpluginOptions($receiver, kotlinAfterJavaTask, (AbstractCompile)javaTask, null, androidProjectHandler, null);
            if (CacheableTasksKt.isBuildCacheSupported()) {
                kotlinAfterJavaTask.getOutputs().doNotCacheIf("Caching is not supported with deprecated Kapt1", (Spec)initKapt.2.INSTANCE);
            }
        } else {
            kotlinAfterJavaTask = null;
            Logger logger = kotlinTask.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"kotlinTask.logger");
            GradleUtilsKt.kotlinDebug(logger, "kapt: Class file stubs are not used");
        }
        GradleUtilsKt.appendClasspathDynamically((AbstractCompile)javaTask, kaptManager.getWrappersDirectory());
        javaTask.source(new Object[]{kaptManager.getHackAnnotationDir()});
        kotlinTask.getKaptOptions().setSupportInheritedAnnotations(kaptExtension.getInheritedAnnotations());
        kotlinTask.doFirst((Action)new Action<Task>(kaptManager){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;

            public final void execute(Task it) {
                this.$kaptManager.generateJavaHackFile();
            }
            {
                this.$kaptManager = annotationProcessingManager;
            }
        });
        javaTask.doFirst((Action)new Action<Task>(kaptManager, kotlinAfterJavaTask){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;
            final /* synthetic */ KotlinCompile $kotlinAfterJavaTask;

            public final void execute(Task it) {
                block0: {
                    this.$kaptManager.setupKapt();
                    this.$kaptManager.generateJavaHackFile();
                    KotlinCompile kotlinCompile = this.$kotlinAfterJavaTask;
                    if (kotlinCompile == null) break block0;
                    kotlinCompile.source(this.$kaptManager.getGeneratedKotlinSourceDir());
                }
            }
            {
                this.$kaptManager = annotationProcessingManager;
                this.$kotlinAfterJavaTask = kotlinCompile;
            }
        });
        javaTask.doLast((Action)new Action<Task>(kaptManager){
            final /* synthetic */ AnnotationProcessingManager $kaptManager;

            public final void execute(Task it) {
                this.$kaptManager.afterJavaCompile();
            }
            {
                this.$kaptManager = annotationProcessingManager;
            }
        });
        kotlinTask.getKaptOptions().setAnnotationsFile(kaptManager.getAnnotationFile());
        if (CacheableTasksKt.isBuildCacheSupported()) {
            kotlinTask.getOutputs().doNotCacheIf("Caching is not supported with deprecated Kapt1", (Spec)initKapt.6.INSTANCE);
        }
        return kotlinAfterJavaTask;
    }

    private static final KotlinCompile createKotlinAfterJavaTask(@NotNull Project $receiver, AbstractCompile javaTask, KotlinCompile kotlinTask, KotlinJvmOptionsImpl kotlinOptions, KotlinTasksProvider tasksProvider) {
        KotlinCompile kotlinCompile;
        KotlinCompile $receiver2 = kotlinCompile = tasksProvider.createKotlinJVMTask($receiver, kotlinTask.getName() + KotlinPluginKt.getKOTLIN_AFTER_JAVA_TASK_SUFFIX(), kotlinTask.getSourceSetName$kotlin_gradle_plugin());
        GradleUtilsKt.mapClasspath($receiver2, (Function0<? extends FileCollection>)((Function0)new Function0<FileCollection>(kotlinTask){
            final /* synthetic */ KotlinCompile $kotlinTask$inlined;
            {
                this.$kotlinTask$inlined = kotlinCompile;
                super(0);
            }

            public final FileCollection invoke() {
                FileCollection fileCollection = this.$kotlinTask$inlined.getClasspath();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"kotlinTask.classpath");
                return fileCollection;
            }
        }));
        KotlinCompile kotlinAfterJavaTask = $receiver2;
        kotlinAfterJavaTask.dependsOn(new Object[]{javaTask});
        GradleUtilsKt.finalizedByIfNotFailed((Task)javaTask, kotlinAfterJavaTask);
        kotlinAfterJavaTask.setParentKotlinOptionsImpl$kotlin_gradle_plugin(kotlinOptions);
        return kotlinAfterJavaTask;
    }
}

