/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.kapt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.maven.K2JVMCompileMojo;
import org.jetbrains.kotlin.maven.Util;
import org.jetbrains.kotlin.maven.kapt.AnnotationProcessingManager;
import org.jetbrains.kotlin.maven.kapt.KaptOption;

@Mojo(name="kapt", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class KaptJVMCompilerMojo
extends K2JVMCompileMojo {
    @Parameter
    private String[] annotationProcessors;
    @Parameter
    private List<DependencyCoordinate> annotationProcessorPaths;
    @Parameter
    private String aptMode = "stubsAndApt";
    @Parameter
    private boolean useLightAnalysis = true;
    @Parameter
    private boolean correctErrorTypes = false;
    @Parameter
    private boolean mapDiagnosticLocations = false;
    @Parameter
    private List<String> annotationProcessorArgs;
    @Parameter
    private List<String> javacOptions;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    private AnnotationProcessingManager cachedAnnotationProcessingManager;

    private AnnotationProcessingManager getAnnotationProcessingManager() {
        if (this.cachedAnnotationProcessingManager != null) {
            return this.cachedAnnotationProcessingManager;
        }
        this.cachedAnnotationProcessingManager = new AnnotationProcessingManager(this.artifactHandlerManager, this.session, this.project, this.system, this.resolutionErrorHandler);
        return this.cachedAnnotationProcessingManager;
    }

    @NotNull
    private List<KaptOption> getKaptOptions(@NotNull K2JVMCompilerArguments arguments, @NotNull AnnotationProcessingManager.ResolvedArtifacts resolvedArtifacts) {
        ArrayList<KaptOption> options = new ArrayList<KaptOption>();
        options.add(new KaptOption("aptMode", this.aptMode));
        options.add(new KaptOption("useLightAnalysis", this.useLightAnalysis));
        options.add(new KaptOption("correctErrorTypes", this.correctErrorTypes));
        options.add(new KaptOption("mapDiagnosticLocations", this.mapDiagnosticLocations));
        options.add(new KaptOption("processors", this.annotationProcessors));
        if (arguments.getVerbose()) {
            options.add(new KaptOption("verbose", true));
        }
        for (String entry : resolvedArtifacts.annotationProcessingClasspath) {
            options.add(new KaptOption("apclasspath", entry));
        }
        String sourceSetName = this.getSourceSetName();
        File sourcesDirectory = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, sourceSetName);
        File kotlinSourcesDirectory = AnnotationProcessingManager.getGeneratedKotlinSourcesDirectory(this.project, sourceSetName);
        File classesDirectory = AnnotationProcessingManager.getGeneratedClassesDirectory(this.project, sourceSetName);
        File stubsDirectory = AnnotationProcessingManager.getStubsDirectory(this.project, sourceSetName);
        this.addKaptSourcesDirectory(sourcesDirectory.getPath());
        this.addKaptSourcesDirectory(kotlinSourcesDirectory.getPath());
        this.mkdirsSafe(classesDirectory);
        this.mkdirsSafe(stubsDirectory);
        this.mkdirsSafe(kotlinSourcesDirectory);
        options.add(new KaptOption("sources", sourcesDirectory.getAbsolutePath()));
        options.add(new KaptOption("classes", classesDirectory.getAbsolutePath()));
        options.add(new KaptOption("stubs", stubsDirectory.getAbsolutePath()));
        options.add(new KaptOption("javacArguments", KaptJVMCompilerMojo.encodeOptionList(KaptJVMCompilerMojo.parseOptionList(this.javacOptions))));
        Map<String, String> allApOptions = KaptJVMCompilerMojo.parseOptionList(this.annotationProcessorArgs);
        allApOptions.put("kapt.kotlin.generated", kotlinSourcesDirectory.getAbsolutePath());
        options.add(new KaptOption("apoptions", KaptJVMCompilerMojo.encodeOptionList(allApOptions)));
        return options;
    }

    @Override
    @NotNull
    protected ExitCode execCompiler(CLICompiler<K2JVMCompilerArguments> compiler, MessageCollector messageCollector, K2JVMCompilerArguments arguments, List<File> sourceRoots) throws MojoExecutionException {
        String sourceSetName = this.getSourceSetName();
        this.recreateDirectorySafe(AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, sourceSetName));
        this.recreateDirectorySafe(AnnotationProcessingManager.getStubsDirectory(this.project, sourceSetName));
        this.recreateDirectorySafe(AnnotationProcessingManager.getGeneratedKotlinSourcesDirectory(this.project, sourceSetName));
        return super.execCompiler(compiler, messageCollector, arguments, sourceRoots);
    }

    @Override
    protected List<String> getSourceFilePaths() {
        File generatedSourcesDirectory = AnnotationProcessingManager.getGeneratedSourcesDirectory(this.project, this.getSourceSetName());
        File generatedKotlinSourcesDirectory = AnnotationProcessingManager.getGeneratedKotlinSourcesDirectory(this.project, this.getSourceSetName());
        return super.getSourceFilePaths().stream().filter(path -> {
            File pathFile = new File((String)path);
            return !pathFile.equals(generatedSourcesDirectory) && !pathFile.equals(generatedKotlinSourcesDirectory);
        }).collect(Collectors.toList());
    }

    @Override
    protected List<String> getClasspath() {
        File compileTargetDirectory = new File(this.output);
        return super.getClasspath().stream().filter(path -> !new File((String)path).equals(compileTargetDirectory)).collect(Collectors.toList());
    }

    protected void addKaptSourcesDirectory(@NotNull String path) {
        this.project.addCompileSourceRoot(path);
    }

    @Override
    protected void configureSpecificCompilerArguments(@NotNull K2JVMCompilerArguments arguments, @NotNull List<File> sourceRoots) throws MojoExecutionException {
        String[] stringArray;
        AnnotationProcessingManager.ResolvedArtifacts resolvedArtifacts;
        super.configureSpecificCompilerArguments(arguments, sourceRoots);
        try {
            resolvedArtifacts = this.getAnnotationProcessingManager().resolveAnnotationProcessors(this.annotationProcessorPaths);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while processing kapt options", e);
        }
        String[] kaptOptions = this.renderKaptOptions(this.getKaptOptions(arguments, resolvedArtifacts));
        arguments.setPluginOptions(Util.joinArrays(arguments.getPluginOptions(), kaptOptions));
        String jdkToolsJarPath = this.getJdkToolsJarPath();
        String[] stringArray2 = arguments.getPluginClasspaths();
        if (jdkToolsJarPath == null) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = resolvedArtifacts.kaptCompilerPluginArtifact;
        } else {
            String[] stringArray4 = new String[2];
            stringArray4[0] = jdkToolsJarPath;
            stringArray = stringArray4;
            stringArray4[1] = resolvedArtifacts.kaptCompilerPluginArtifact;
        }
        arguments.setPluginClasspaths(Util.joinArrays(stringArray2, stringArray));
    }

    @Nullable
    private String getJdkToolsJarPath() {
        int jdkVersion;
        String javaHomePath = System.getProperty("java.home");
        if (javaHomePath == null || javaHomePath.isEmpty()) {
            this.getLog().warn((CharSequence)"Can't determine Java home, 'java.home' property does not exist");
            return null;
        }
        String jdkStringVersion = System.getProperty("java.specification.version");
        if (jdkStringVersion == null) {
            return null;
        }
        try {
            jdkVersion = Integer.parseInt(jdkStringVersion);
        }
        catch (NumberFormatException e) {
            jdkVersion = 0;
        }
        if (jdkVersion >= 9) {
            return null;
        }
        File javaHome = new File(javaHomePath);
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return toolsJar.getAbsolutePath();
        }
        if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
            return toolsJar.getAbsolutePath();
        }
        this.getLog().debug((CharSequence)(toolsJar.getAbsolutePath() + " does not exist"));
        this.getLog().warn((CharSequence)"'tools.jar' was not found, kapt may work unreliably");
        return null;
    }

    @NotNull
    private String[] renderKaptOptions(@NotNull List<KaptOption> options) {
        String[] result = new String[options.size()];
        int i = 0;
        for (KaptOption option : options) {
            result[i++] = option.toString();
        }
        return result;
    }

    @Override
    protected boolean isIncremental() {
        return false;
    }

    private void mkdirsSafe(@NotNull File directory) {
        if (!directory.isDirectory() && !directory.mkdirs()) {
            this.getLog().warn((CharSequence)("Unable to create directory " + directory));
        }
    }

    private void deleteRecursivelySafe(@NotNull File file) {
        File[] children;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursivelySafe(child);
            }
        }
        if (!file.delete()) {
            this.getLog().warn((CharSequence)("Unable to delete file " + file));
        }
    }

    private void recreateDirectorySafe(@NotNull File file) {
        if (file.exists()) {
            this.deleteRecursivelySafe(file);
        }
        this.mkdirsSafe(file);
    }

    private static Map<String, String> parseOptionList(@Nullable List<String> rawOptions) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (rawOptions == null) {
            return map;
        }
        for (String option : rawOptions) {
            if (option.isEmpty()) continue;
            int equalsIndex = option.indexOf("=");
            if (equalsIndex < 0) {
                map.put(option, "");
                continue;
            }
            map.put(option.substring(0, equalsIndex).trim(), option.substring(equalsIndex + 1).trim());
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String encodeOptionList(Map<String, String> options) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeInt(options.size());
            for (Map.Entry<String, String> entry : options.entrySet()) {
                oos.writeUTF(entry.getKey());
                oos.writeUTF(entry.getValue());
            }
            oos.flush();
            String string = Base64.getEncoder().encodeToString(os.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

