/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven.incremental;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import org.apache.maven.plugin.logging.Log;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporter;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.cli.common.ExitCode;

public class MavenICReporter
extends ICReporterBase {
    private static final String IC_LOG_LEVEL_PROPERTY_NAME = "kotlin.compiler.incremental.log.level";
    private final Log log;
    private final LogLevel logLevel;
    @NotNull
    private final Set<File> compiledKotlinFiles = new HashSet<File>();

    public MavenICReporter(@NotNull Log log) {
        super(null);
        LogLevel logLevel = log.isDebugEnabled() ? LogLevel.DEBUG : (log.isInfoEnabled() ? LogLevel.INFO : LogLevel.NONE);
        String userLogLevel = System.getProperty(IC_LOG_LEVEL_PROPERTY_NAME);
        if (userLogLevel != null) {
            for (LogLevel enumEntry : LogLevel.values()) {
                if (!enumEntry.name().equalsIgnoreCase(userLogLevel)) continue;
                logLevel = enumEntry;
                break;
            }
            log.warn((CharSequence)("Unknown incremental compilation log level '" + (Object)((Object)logLevel) + "',possible values: 'none', 'info', 'debug'"));
        }
        this.logLevel = logLevel;
        this.log = log;
    }

    public void report(@NotNull Function0<String> getMessage, @NotNull ICReporter.ReportSeverity severity) {
        switch (this.logLevel) {
            case NONE: {
                break;
            }
            case INFO: {
                if (severity == ICReporter.ReportSeverity.WARNING) {
                    this.log.warn((CharSequence)getMessage.invoke());
                    break;
                }
                if (severity == ICReporter.ReportSeverity.INFO) {
                    this.log.info((CharSequence)getMessage.invoke());
                    break;
                }
                if (severity == ICReporter.ReportSeverity.DEBUG) break;
                throw new IllegalArgumentException(severity.toString() + " is not yet handled");
            }
            case DEBUG: {
                if (severity == ICReporter.ReportSeverity.WARNING) {
                    this.log.warn((CharSequence)getMessage.invoke());
                    break;
                }
                if (severity == ICReporter.ReportSeverity.INFO) {
                    this.log.info((CharSequence)getMessage.invoke());
                    break;
                }
                if (severity == ICReporter.ReportSeverity.DEBUG) {
                    this.log.debug((CharSequence)getMessage.invoke());
                    break;
                }
                throw new IllegalArgumentException(severity.toString() + " is not yet handled");
            }
        }
    }

    @NotNull
    public Set<File> getCompiledKotlinFiles() {
        return this.compiledKotlinFiles;
    }

    public void reportCompileIteration(boolean b, @NotNull Collection<? extends File> sourceFiles, @NotNull ExitCode exitCode) {
        this.compiledKotlinFiles.addAll(sourceFiles);
        ICReporterKt.info((ICReporter)this, () -> "Kotlin compile iteration: " + this.pathsAsString(sourceFiles));
        ICReporterKt.info((ICReporter)this, () -> "Exit code: " + exitCode.toString());
    }

    private static enum LogLevel {
        NONE,
        INFO,
        DEBUG;

    }
}

