/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.maven;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.jvm.JvmScriptingHostConfigurationKt;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.JvmArgumentsKt;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.maven.MavenPluginLogMessageCollector;
import org.jetbrains.kotlin.maven.ScriptExecutionException;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.scripting.compiler.plugin.ConfigurationKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.ScriptingCompilerConfigurationComponentRegistrar;
import org.jetbrains.kotlin.utils.ParametersMapKt;

@Mojo(name="script", requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ExecuteKotlinScriptMojo
extends AbstractMojo {
    @Parameter
    private File scriptFile;
    @Parameter
    private String script;
    @Parameter(defaultValue="${project.build.directory}/kotlin-build-scripts", required=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${plugin}", required=true, readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="kotlin.compiler.scriptTemplates")
    protected List<String> scriptTemplates;
    @Parameter(property="kotlin.compiler.scriptArguments")
    protected List<String> scriptArguments;
    @Parameter(property="kotlin.compiler.scriptClasspath")
    protected List<String> scriptClasspath;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    public static ExecuteKotlinScriptMojo INSTANCE;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.scriptFile != null && this.script == null) {
            this.executeScriptFile(this.scriptFile);
        } else if (this.scriptFile == null && this.script != null) {
            this.executeScriptInline();
        } else {
            throw new MojoExecutionException("Either scriptFile or script parameter must be specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptInline() throws MojoExecutionException {
        try {
            if (!this.buildDirectory.exists()) {
                this.buildDirectory.mkdirs();
            }
            Path scriptFile = Files.createTempFile(this.buildDirectory.toPath(), "kotlin-maven-plugin-inline-script-", ".tmp.kts", new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(scriptFile, StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(this.script);
            }
            try {
                this.executeScriptFile(scriptFile.toFile());
            }
            finally {
                boolean deleted = Files.deleteIfExists(scriptFile);
                if (!deleted) {
                    this.getLog().warn((CharSequence)("Error deleting " + scriptFile.toAbsolutePath()));
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing inline script", (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScriptFile(File scriptFile) throws MojoExecutionException {
        this.initCompiler();
        Disposable rootDisposable = Disposer.newDisposable((String)"Disposable for ExecuteKotlinScriptMojo.executeScriptFile");
        try {
            MavenPluginLogMessageCollector messageCollector = new MavenPluginLogMessageCollector(this.getLog());
            CompilerConfiguration configuration = new CompilerConfiguration();
            configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)messageCollector);
            configuration.put(CommonConfigurationKeys.ALLOW_ANY_SCRIPTS_IN_SOURCE_ROOTS, (Object)true);
            configuration.add(ComponentRegistrar.Companion.getPLUGIN_COMPONENT_REGISTRARS(), (Object)new ScriptingCompilerConfigurationComponentRegistrar());
            JvmArgumentsKt.configureJdkHomeFromSystemProperty((CompilerConfiguration)configuration);
            ArrayList<File> deps = new ArrayList<File>();
            deps.addAll(this.getDependenciesForScript());
            for (File item : deps) {
                if (item.exists()) {
                    configuration.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JvmClasspathRoot(item));
                    this.getLog().debug((CharSequence)("Adding to classpath: " + item.getAbsolutePath()));
                    continue;
                }
                this.getLog().debug((CharSequence)("Skipping non-existing dependency: " + item.getAbsolutePath()));
            }
            configuration.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new KotlinSourceRoot(scriptFile.getAbsolutePath(), false, null));
            configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)"main");
            ConfigurationKt.configureScriptDefinitions(this.scriptTemplates, (CompilerConfiguration)configuration, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (MessageCollector)messageCollector, (ScriptingHostConfiguration)JvmScriptingHostConfigurationKt.getDefaultJvmScriptingHostConfiguration());
            JvmContentRootsKt.configureJdkClasspathRoots((CompilerConfiguration)configuration);
            KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction((Disposable)rootDisposable, (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
            GenerationState state = KotlinToJVMBytecodeCompiler.INSTANCE.analyzeAndGenerate(environment);
            if (state == null) {
                throw new ScriptExecutionException(scriptFile, "compile error");
            }
            GeneratedClassLoader classLoader = new GeneratedClassLoader(state.getFactory(), ((Object)((Object)this)).getClass().getClassLoader(), new URL[0]);
            KtScript script = ((KtFile)environment.getSourceFiles().get(0)).getScript();
            FqName nameForScript = script.getFqName();
            try {
                Class klass = classLoader.loadClass(nameForScript.asString());
                INSTANCE = this;
                if (ParametersMapKt.tryConstructClassFromStringArgs((Class)klass, this.scriptArguments) == null) {
                    throw new ScriptExecutionException(scriptFile, "unable to construct script");
                }
            }
            catch (ClassNotFoundException e) {
                throw new ScriptExecutionException(scriptFile, "internal error", e);
            }
        }
        finally {
            rootDisposable.dispose();
            INSTANCE = null;
        }
    }

    private List<File> getDependenciesForScript() throws MojoExecutionException {
        ArrayList<File> deps = new ArrayList<File>();
        deps.addAll(this.getKotlinRuntimeDependencies());
        deps.add(this.getThisPluginAsDependency());
        deps.addAll(this.getThisPluginDependencies());
        for (String cp : this.scriptClasspath) {
            deps.add(new File(cp));
        }
        return deps;
    }

    private File getDependencyFile(ComponentDependency dep) {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(dep.getType());
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), null, dep.getType(), null, artifactHandler);
        return this.getArtifactFile((Artifact)artifact);
    }

    private File getArtifactFile(Artifact artifact) {
        this.localRepository.find(artifact);
        return artifact.getFile();
    }

    private List<File> getThisPluginDependencies() {
        return this.plugin.getArtifacts().stream().map(this::getArtifactFile).collect(Collectors.toList());
    }

    private File getThisPluginAsDependency() {
        ComponentDependency dep = new ComponentDependency();
        dep.setGroupId(this.plugin.getGroupId());
        dep.setArtifactId(this.plugin.getArtifactId());
        dep.setVersion(this.plugin.getVersion());
        return this.getDependencyFile(dep);
    }

    private List<File> getKotlinRuntimeDependencies() throws MojoExecutionException {
        Artifact stdlibDep = null;
        Artifact runtimeDep = null;
        ArrayList<File> files = new ArrayList<File>(2);
        for (Artifact dep : this.project.getArtifacts()) {
            if (dep.getArtifactId().equals("kotlin-stdlib")) {
                files.add(this.getArtifactFile(dep));
                stdlibDep = dep;
            }
            if (dep.getArtifactId().equals("kotlin-runtime")) {
                files.add(this.getArtifactFile(dep));
                runtimeDep = dep;
            }
            if (stdlibDep == null || runtimeDep == null) continue;
            break;
        }
        if (stdlibDep == null) {
            throw new MojoExecutionException("Unable to find kotlin-stdlib artifacts among project dependencies");
        }
        return files;
    }

    private void initCompiler() {
        new K2JVMCompiler();
    }
}

