/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.FunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.SimpleFunctionDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.util.OperatorNameConventions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionInvokeDescriptor
extends SimpleFunctionDescriptorImpl {
    @NotNull
    public static final Factory Factory = new Factory(null);

    private FunctionInvokeDescriptor(DeclarationDescriptor container, FunctionInvokeDescriptor original, CallableMemberDescriptor.Kind callableKind, boolean isSuspend) {
        super(container, original, Annotations.Companion.getEMPTY(), OperatorNameConventions.INVOKE, callableKind, SourceElement.NO_SOURCE);
        this.setOperator(true);
        this.setSuspend(isSuspend);
        this.setHasStableParameterNames(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected FunctionDescriptor doSubstitute(@NotNull FunctionDescriptorImpl.CopyConfiguration configuration) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        FunctionInvokeDescriptor substituted;
        block6: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            FunctionInvokeDescriptor functionInvokeDescriptor = (FunctionInvokeDescriptor)super.doSubstitute(configuration);
            if (functionInvokeDescriptor == null) {
                return null;
            }
            substituted = functionInvokeDescriptor;
            List<ValueParameterDescriptor> list = substituted.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"substituted.valueParameters");
            Iterable $this$none$iv = list;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv2;
                    boolean bl2 = false;
                    KotlinType kotlinType = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
                    if (!(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType) != null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        if (bl) {
            return substituted;
        }
        List<ValueParameterDescriptor> list = substituted.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"substituted.valueParameters");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            collection.add(FunctionTypesKt.extractParameterNameFromFunctionTypeArgument(kotlinType));
        }
        List parameterNames = (List)destination$iv$iv;
        return substituted.replaceParameterNames(parameterNames);
    }

    @Override
    @NotNull
    protected FunctionDescriptorImpl createSubstitutedCopy(@NotNull DeclarationDescriptor newOwner, @Nullable FunctionDescriptor original, @NotNull CallableMemberDescriptor.Kind kind, @Nullable Name newName, @NotNull Annotations annotations2, @NotNull SourceElement source) {
        Intrinsics.checkNotNullParameter((Object)newOwner, (String)"newOwner");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return new FunctionInvokeDescriptor(newOwner, (FunctionInvokeDescriptor)original, kind, this.isSuspend());
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    @Override
    public boolean isTailrec() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final FunctionDescriptor replaceParameterNames(List<Name> parameterNames) {
        boolean bl;
        List newValueParameters;
        Object object;
        block6: {
            void $this$any$iv;
            Iterable $this$mapTo$iv$iv;
            boolean bl2;
            int indexShift = this.getValueParameters().size() - parameterNames.size();
            boolean bl3 = bl2 = indexShift == 0 || indexShift == 1;
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            List<ValueParameterDescriptor> list = this.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"valueParameters");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Name newName;
                Name parameterName;
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                object = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getName(), (String)"it.name");
                int parameterIndex = it.getIndex();
                int nameIndex = parameterIndex - indexShift;
                if (nameIndex >= 0 && (parameterName = parameterNames.get(nameIndex)) != null) {
                    newName = parameterName;
                }
                object.add(it.copy(this, newName, parameterIndex));
            }
            newValueParameters = (List)destination$iv$iv;
            $this$mapTo$iv$iv = parameterNames;
            object = this.newCopyBuilder(TypeSubstitutor.EMPTY);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Name it = (Name)element$iv;
                    boolean bl5 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        boolean bl6 = bl;
        FunctionDescriptorImpl.CopyConfiguration copyConfiguration = ((FunctionDescriptorImpl.CopyConfiguration)((FunctionDescriptorImpl.CopyConfiguration)object).setHasSynthesizedParameterNames(bl6).setValueParameters(newValueParameters)).setOriginal(this.getOriginal());
        Intrinsics.checkNotNullExpressionValue((Object)copyConfiguration, (String)"newCopyBuilder(TypeSubst\u2026   .setOriginal(original)");
        FunctionDescriptorImpl.CopyConfiguration copyConfiguration2 = copyConfiguration;
        FunctionDescriptor functionDescriptor = super.doSubstitute(copyConfiguration2);
        Intrinsics.checkNotNull((Object)functionDescriptor);
        return functionDescriptor;
    }

    public /* synthetic */ FunctionInvokeDescriptor(DeclarationDescriptor container, FunctionInvokeDescriptor original, CallableMemberDescriptor.Kind callableKind, boolean isSuspend, DefaultConstructorMarker $constructor_marker) {
        this(container, original, callableKind, isSuspend);
    }

    public static final class Factory {
        private Factory() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FunctionInvokeDescriptor create(@NotNull FunctionClassDescriptor functionClass, boolean isSuspend) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable $this$takeWhile$iv;
            Intrinsics.checkNotNullParameter((Object)functionClass, (String)"functionClass");
            List<TypeParameterDescriptor> typeParameters2 = functionClass.getDeclaredTypeParameters();
            FunctionInvokeDescriptor result2 = new FunctionInvokeDescriptor(functionClass, null, CallableMemberDescriptor.Kind.DECLARATION, isSuspend, null);
            Iterable iterable = typeParameters2;
            List list = CollectionsKt.emptyList();
            List list2 = CollectionsKt.emptyList();
            ReceiverParameterDescriptor receiverParameterDescriptor = functionClass.getThisAsReceiverParameter();
            ReceiverParameterDescriptor receiverParameterDescriptor2 = null;
            FunctionInvokeDescriptor functionInvokeDescriptor = result2;
            boolean $i$f$takeWhile = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)item$iv;
                boolean bl = false;
                if (!(it.getVariance() == Variance.IN_VARIANCE)) break;
                list$iv.add(item$iv);
            }
            Collection<ValueParameterDescriptor> collection = list$iv;
            $this$takeWhile$iv = CollectionsKt.withIndex((Iterable)collection);
            boolean $i$f$map = false;
            list$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Factory.createValueParameter(result2, it.getIndex(), (TypeParameterDescriptor)it.getValue()));
            }
            collection = (List)destination$iv$iv;
            functionInvokeDescriptor.initialize(receiverParameterDescriptor2, receiverParameterDescriptor, list2, list, (List)collection, (KotlinType)((TypeParameterDescriptor)CollectionsKt.last(typeParameters2)).getDefaultType(), Modality.ABSTRACT, DescriptorVisibilities.PUBLIC);
            result2.setHasSynthesizedParameterNames(true);
            return result2;
        }

        private final ValueParameterDescriptor createValueParameter(FunctionInvokeDescriptor containingDeclaration, int index, TypeParameterDescriptor typeParameter) {
            String string;
            String typeParameterName;
            String string2 = typeParameter.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeParameter.name.asString()");
            String string3 = typeParameterName = string2;
            if (Intrinsics.areEqual((Object)string3, (Object)"T")) {
                string = "instance";
            } else if (Intrinsics.areEqual((Object)string3, (Object)"E")) {
                string = "receiver";
            } else {
                String string4 = typeParameterName.toLowerCase(Locale.ROOT);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            }
            String name = string;
            CallableDescriptor callableDescriptor = containingDeclaration;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Name name2 = Name.identifier(name);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(name)");
            SimpleType simpleType2 = typeParameter.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"typeParameter.defaultType");
            KotlinType kotlinType = simpleType2;
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            return new ValueParameterDescriptorImpl(callableDescriptor, null, index, annotations2, name2, kotlinType, false, false, false, null, sourceElement);
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

