/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.host;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ExternalSourceCode;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.ScriptSourceNamedFragment;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.host.FileScriptSource;
import kotlin.script.experimental.host.StringScriptSource;
import kotlin.script.experimental.util.PropertiesCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=50, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\u000b\u001a\u0016\u0010\n\u001a\u00020\u0007*\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\r"}, d2={"textSafe", "", "Lkotlin/script/experimental/api/ExternalSourceCode;", "getTextSafe", "(Lkotlin/script/experimental/api/ExternalSourceCode;)Ljava/lang/String;", "getMergedScriptText", "script", "Lkotlin/script/experimental/api/SourceCode;", "configuration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "toScriptSource", "Ljava/io/File;", "name", "kotlin-scripting-common"})
public final class ScriptHostUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getMergedScriptText(@NotNull SourceCode script, @Nullable ScriptCompilationConfiguration configuration) {
        Object object;
        List<ScriptSourceNamedFragment> sourceFragments;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        String originalScriptText = script.getText();
        Object object2 = configuration;
        List<ScriptSourceNamedFragment> list = sourceFragments = object2 == null ? null : ((PropertiesCollection)object2).get(ScriptCompilationKt.getSourceFragments(ScriptCompilationConfiguration.Companion));
        if (sourceFragments == null || sourceFragments.isEmpty()) {
            object = originalScriptText;
        } else {
            StringBuilder sb = new StringBuilder(originalScriptText.length());
            ScriptSourceNamedFragment prevFragment = null;
            for (ScriptSourceNamedFragment fragment : sourceFragments) {
                int curPos;
                Object object3;
                int n;
                Integer fragmentStartPos = fragment.getRange().getStart().getAbsolutePos();
                Integer fragmentEndPos = fragment.getRange().getEnd().getAbsolutePos();
                if (fragmentStartPos == null || fragmentEndPos == null) {
                    throw new RuntimeException("Script fragments require absolute positions (received: " + fragment + ')');
                }
                if (prevFragment == null) {
                    n = 0;
                } else {
                    object3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)object3);
                    n = curPos = ((Integer)object3).intValue();
                }
                if (prevFragment != null) {
                    object3 = prevFragment.getRange().getEnd().getAbsolutePos();
                    Intrinsics.checkNotNull((Object)object3);
                    if ((Integer)object3 > fragmentStartPos) {
                        throw new RuntimeException("Unsorted or overlapping fragments: previous: " + prevFragment + ", current: " + fragment);
                    }
                }
                if (curPos < fragmentStartPos) {
                    Collection<Character> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object3 = originalScriptText.subSequence(curPos, fragmentStartPos);
                    StringBuilder stringBuilder = sb;
                    boolean $i$f$map = false;
                    void var14_14 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList($this$map$iv.length());
                    boolean $i$f$mapTo = false;
                    void var17_17 = $this$mapTo$iv$iv;
                    for (int i = 0; i < var17_17.length(); ++i) {
                        int it;
                        char item$iv$iv;
                        char c = item$iv$iv = var17_17.charAt(i);
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Character c2 = Character.valueOf((char)(it == 13 || it == 10 ? it : 32));
                        collection.add(c2);
                    }
                    collection = (List)destination$iv$iv;
                    stringBuilder.append(collection);
                }
                sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos));
                prevFragment = fragment;
            }
            object2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"{\n        val sb = StringBuilder(originalScriptText.length)\n        var prevFragment: ScriptSourceNamedFragment? = null\n        for (fragment in sourceFragments) {\n            val fragmentStartPos = fragment.range.start.absolutePos\n            val fragmentEndPos = fragment.range.end.absolutePos\n            if (fragmentStartPos == null || fragmentEndPos == null)\n                throw RuntimeException(\"Script fragments require absolute positions (received: $fragment)\")\n            val curPos = if (prevFragment == null) 0 else prevFragment.range.end.absolutePos!!\n            if (prevFragment != null && prevFragment.range.end.absolutePos!! > fragmentStartPos) throw RuntimeException(\"Unsorted or overlapping fragments: previous: $prevFragment, current: $fragment\")\n            if (curPos < fragmentStartPos) {\n                sb.append(\n                    originalScriptText.subSequence(\n                        curPos,\n                        fragmentStartPos\n                    ).map { if (it == '\\r' || it == '\\n') it else ' ' }) // preserving lines layout\n            }\n            sb.append(originalScriptText.subSequence(fragmentStartPos, fragmentEndPos))\n            prevFragment = fragment\n        }\n        sb.toString()\n    }");
            object = object2;
        }
        return object;
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull File $this$toScriptSource) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new FileScriptSource($this$toScriptSource, null, 2, null);
    }

    @NotNull
    public static final SourceCode toScriptSource(@NotNull String $this$toScriptSource, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)$this$toScriptSource, (String)"<this>");
        return new StringScriptSource($this$toScriptSource, name);
    }

    public static /* synthetic */ SourceCode toScriptSource$default(String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return ScriptHostUtilKt.toScriptSource(string, string2);
    }

    private static final String getTextSafe(ExternalSourceCode $this$textSafe) {
        String string;
        try {
            string = $this$textSafe.getText();
        }
        catch (Throwable e) {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ String access$getTextSafe(ExternalSourceCode $receiver) {
        return ScriptHostUtilKt.getTextSafe($receiver);
    }
}

