/*
 * Decompiled with CFR 0.152.
 */
package kotlin.text;

import java.util.Arrays;
import kotlin.ExperimentalStdlibApi;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.SinceKotlin;
import kotlin.ULong;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\nH\u0002\u001a(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002\u001a@\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0000\u001a@\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0000\u001a \u0010\u001b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a5\u0010\u001c\u001a\u00020\r*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0007H\u0082\b\u001a$\u0010#\u001a\u00020$*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010&\u001a\u00020\rH\u0002\u001a\u001c\u0010'\u001a\u00020\r*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u001a<\u0010(\u001a\u00020$*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020\rH\u0002\u001a\u0015\u0010+\u001a\u00020\r*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0082\b\u001a,\u0010,\u001a\u00020\r*\u00020-2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\rH\u0002\u001a<\u0010,\u001a\u00020\r*\u00020-2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\rH\u0002\u001a*\u00104\u001a\u000205*\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0003\u001a\u0016\u00104\u001a\u000205*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0007\u001a*\u00108\u001a\u00020-*\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0003\u001a\u0016\u00108\u001a\u00020-*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0007\u001a&\u00109\u001a\u0004\u0018\u00010-*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0003\u001a&\u0010<\u001a\u0004\u0018\u00010-*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0003\u001a&\u0010=\u001a\u0004\u0018\u00010-*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0003\u001a$\u0010>\u001a\u00020-*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0003\u001a*\u0010?\u001a\u00020\r*\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0003\u001a\u0016\u0010?\u001a\u00020\r*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0007\u001a,\u0010@\u001a\u00020\r*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020\rH\u0003\u001a*\u0010A\u001a\u00020\n*\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0003\u001a\u0016\u0010A\u001a\u00020\n*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0007\u001a,\u0010B\u001a\u00020\n*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u00106\u001a\u0002072\u0006\u0010&\u001a\u00020\rH\u0003\u001a*\u0010C\u001a\u00020D*\u00020\u00072\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0003\u001a\u0016\u0010C\u001a\u00020D*\u00020\u00072\b\b\u0002\u00106\u001a\u000207H\u0007\u001a\u0015\u0010E\u001a\u00020\n*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0082\b\u001a\u0014\u0010F\u001a\u000205*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a\u001c\u0010G\u001a\u00020\r*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u001a\u001c\u0010H\u001a\u00020\n*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u001a\u0014\u0010I\u001a\u00020J*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a,\u0010K\u001a\u00020$*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010L\u001a\u00020!H\u0002\u001a,\u0010M\u001a\u00020$*\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002\u001a,\u0010N\u001a\u00020$*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002\u001a\u001c\u0010O\u001a\u00020\r*\u00020\u00072\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\rH\u0002\u001a\u0016\u0010P\u001a\u00020\u0007*\u0002052\b\b\u0002\u00106\u001a\u000207H\u0007\u001a*\u0010P\u001a\u00020\u0007*\u00020-2\b\b\u0002\u0010%\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0007\u001a\u0016\u0010P\u001a\u00020\u0007*\u00020-2\b\b\u0002\u00106\u001a\u000207H\u0007\u001a\u0016\u0010P\u001a\u00020\u0007*\u00020\r2\b\b\u0002\u00106\u001a\u000207H\u0007\u001a\u0016\u0010P\u001a\u00020\u0007*\u00020\n2\b\b\u0002\u00106\u001a\u000207H\u0007\u001a\u0016\u0010P\u001a\u00020\u0007*\u00020D2\b\b\u0002\u00106\u001a\u000207H\u0007\u001a$\u0010Q\u001a\u00020\u0007*\u00020\n2\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020\rH\u0003\u001a,\u0010V\u001a\u00020\u0007*\u00020-2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020\u0001H\u0003\u001a,\u0010W\u001a\u00020\u0007*\u00020-2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020\u0001H\u0003\u001a,\u0010X\u001a\u00020\u0007*\u00020-2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020\u0001H\u0003\u001a,\u0010Y\u001a\u00020\u0007*\u00020-2\u0006\u0010%\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020\u0001H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"BYTE_TO_LOWER_CASE_HEX_DIGITS", "", "BYTE_TO_UPPER_CASE_HEX_DIGITS", "HEX_DIGITS_TO_DECIMAL", "HEX_DIGITS_TO_LONG_DECIMAL", "", "LOWER_CASE_HEX_DIGITS", "", "UPPER_CASE_HEX_DIGITS", "charsPerSet", "", "charsPerElement", "elementsPerSet", "", "elementSeparatorLength", "checkFormatLength", "formatLength", "formattedStringLength", "numberOfBytes", "byteSeparatorLength", "bytePrefixLength", "byteSuffixLength", "bytesPerLine", "bytesPerGroup", "groupSeparatorLength", "parsedByteArrayMaxSize", "stringLength", "wholeElementsPerSet", "checkContainsAt", "index", "endIndex", "part", "ignoreCase", "", "partName", "checkMaxDigits", "", "startIndex", "maxDigits", "checkNewLineAt", "checkPrefixSuffixMaxDigits", "prefix", "suffix", "decimalFromHexDigitAt", "formatByteAt", "", "byteToDigits", "destination", "", "destinationOffset", "bytePrefix", "byteSuffix", "hexToByte", "", "format", "Lkotlin/text/HexFormat;", "hexToByteArray", "hexToByteArrayNoLineAndGroupSeparator", "bytesFormat", "Lkotlin/text/HexFormat$BytesHexFormat;", "hexToByteArrayNoLineAndGroupSeparatorSlowPath", "hexToByteArrayShortByteSeparatorNoPrefixAndSuffix", "hexToByteArraySlowPath", "hexToInt", "hexToIntImpl", "hexToLong", "hexToLongImpl", "hexToShort", "", "longDecimalFromHexDigitAt", "parseByteAt", "parseInt", "parseLong", "throwInvalidDigitAt", "", "throwInvalidNumberOfDigits", "requireMaxLength", "throwInvalidPrefixSuffix", "throwNotContainedAt", "toCharArrayIfNotEmpty", "toHexString", "toHexStringImpl", "numberFormat", "Lkotlin/text/HexFormat$NumberHexFormat;", "digits", "bits", "toHexStringNoLineAndGroupSeparator", "toHexStringNoLineAndGroupSeparatorSlowPath", "toHexStringShortByteSeparatorNoPrefixAndSuffix", "toHexStringSlowPath", "kotlin-stdlib"})
@SourceDebugExtension(value={"SMAP\nHexExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,1050:1\n998#1,7:1052\n998#1,7:1059\n998#1,7:1066\n998#1,7:1073\n998#1,7:1080\n998#1,7:1087\n998#1,7:1094\n998#1,7:1101\n1009#1,5:1108\n1009#1,5:1113\n998#1,7:1118\n998#1,7:1125\n1009#1,5:1132\n1018#1,5:1137\n1#2:1051\n1181#3,3:1142\n1181#3,3:1145\n1181#3,3:1148\n1181#3,3:1151\n*S KotlinDebug\n*F\n+ 1 HexExtensions.kt\nkotlin/text/HexExtensionsKt\n*L\n418#1:1052,7\n451#1:1059,7\n455#1:1066,7\n458#1:1073,7\n499#1:1080,7\n502#1:1087,7\n507#1:1094,7\n512#1:1101,7\n519#1:1108,5\n520#1:1113,5\n967#1:1118,7\n969#1:1125,7\n983#1:1132,5\n991#1:1137,5\n42#1:1142,3\n43#1:1145,3\n54#1:1148,3\n55#1:1151,3\n*E\n"})
public final class HexExtensionsKt {
    @NotNull
    private static final String LOWER_CASE_HEX_DIGITS = "0123456789abcdef";
    @NotNull
    private static final String UPPER_CASE_HEX_DIGITS = "0123456789ABCDEF";
    @NotNull
    private static final int[] BYTE_TO_LOWER_CASE_HEX_DIGITS;
    @NotNull
    private static final int[] BYTE_TO_UPPER_CASE_HEX_DIGITS;
    @NotNull
    private static final int[] HEX_DIGITS_TO_DECIMAL;
    @NotNull
    private static final long[] HEX_DIGITS_TO_LONG_DECIMAL;

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$toHexString, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.toHexString($this$toHexString, 0, $this$toHexString.length, format);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(@NotNull byte[] $this$toHexString, int startIndex, int endIndex, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$toHexString, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$toHexString.length);
        if (startIndex == endIndex) {
            return "";
        }
        int[] byteToDigits = format.getUpperCase() ? BYTE_TO_UPPER_CASE_HEX_DIGITS : BYTE_TO_LOWER_CASE_HEX_DIGITS;
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        if (bytesFormat.getNoLineAndGroupSeparator$kotlin_stdlib()) {
            return HexExtensionsKt.toHexStringNoLineAndGroupSeparator($this$toHexString, startIndex, endIndex, bytesFormat, byteToDigits);
        }
        return HexExtensionsKt.toHexStringSlowPath($this$toHexString, startIndex, endIndex, bytesFormat, byteToDigits);
    }

    public static /* synthetic */ String toHexString$default(byte[] byArray, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = byArray.length;
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(byArray, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringNoLineAndGroupSeparator(byte[] $this$toHexStringNoLineAndGroupSeparator, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat, int[] byteToDigits) {
        if (bytesFormat.getShortByteSeparatorNoPrefixAndSuffix$kotlin_stdlib()) {
            return HexExtensionsKt.toHexStringShortByteSeparatorNoPrefixAndSuffix($this$toHexStringNoLineAndGroupSeparator, startIndex, endIndex, bytesFormat, byteToDigits);
        }
        return HexExtensionsKt.toHexStringNoLineAndGroupSeparatorSlowPath($this$toHexStringNoLineAndGroupSeparator, startIndex, endIndex, bytesFormat, byteToDigits);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringShortByteSeparatorNoPrefixAndSuffix(byte[] $this$toHexStringShortByteSeparatorNoPrefixAndSuffix, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat, int[] byteToDigits) {
        boolean bl;
        int byteSeparatorLength = bytesFormat.getByteSeparator().length();
        boolean bl2 = bl = byteSeparatorLength <= 1;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int numberOfBytes = endIndex - startIndex;
        int charIndex = 0;
        if (byteSeparatorLength == 0) {
            char[] charArray = new char[HexExtensionsKt.checkFormatLength(2L * (long)numberOfBytes)];
            for (int byteIndex = startIndex; byteIndex < endIndex; ++byteIndex) {
                charIndex = HexExtensionsKt.formatByteAt($this$toHexStringShortByteSeparatorNoPrefixAndSuffix, byteIndex, byteToDigits, charArray, charIndex);
            }
            return StringsKt.concatToString(charArray);
        }
        char[] charArray = new char[HexExtensionsKt.checkFormatLength(3L * (long)numberOfBytes - 1L)];
        char byteSeparatorChar = bytesFormat.getByteSeparator().charAt(0);
        charIndex = HexExtensionsKt.formatByteAt($this$toHexStringShortByteSeparatorNoPrefixAndSuffix, startIndex, byteToDigits, charArray, charIndex);
        for (int byteIndex = startIndex + 1; byteIndex < endIndex; ++byteIndex) {
            charArray[charIndex++] = byteSeparatorChar;
            charIndex = HexExtensionsKt.formatByteAt($this$toHexStringShortByteSeparatorNoPrefixAndSuffix, byteIndex, byteToDigits, charArray, charIndex);
        }
        return StringsKt.concatToString(charArray);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringNoLineAndGroupSeparatorSlowPath(byte[] $this$toHexStringNoLineAndGroupSeparatorSlowPath, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat, int[] byteToDigits) {
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        int formatLength = HexExtensionsKt.formattedStringLength(endIndex - startIndex, byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        char[] charArray = new char[formatLength];
        int charIndex = 0;
        charIndex = HexExtensionsKt.formatByteAt($this$toHexStringNoLineAndGroupSeparatorSlowPath, startIndex, bytePrefix, byteSuffix, byteToDigits, charArray, charIndex);
        for (int byteIndex = startIndex + 1; byteIndex < endIndex; ++byteIndex) {
            charIndex = HexExtensionsKt.toCharArrayIfNotEmpty(byteSeparator, charArray, charIndex);
            charIndex = HexExtensionsKt.formatByteAt($this$toHexStringNoLineAndGroupSeparatorSlowPath, byteIndex, bytePrefix, byteSuffix, byteToDigits, charArray, charIndex);
        }
        return StringsKt.concatToString(charArray);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringSlowPath(byte[] $this$toHexStringSlowPath, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat, int[] byteToDigits) {
        boolean bl;
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        int formatLength = HexExtensionsKt.formattedStringLength(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        char[] charArray = new char[formatLength];
        int charIndex = 0;
        int indexInLine = 0;
        int indexInGroup = 0;
        for (int byteIndex = startIndex; byteIndex < endIndex; ++byteIndex) {
            if (indexInLine == bytesPerLine) {
                charArray[charIndex++] = 10;
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                charIndex = HexExtensionsKt.toCharArrayIfNotEmpty(groupSeparator, charArray, charIndex);
                indexInGroup = 0;
            }
            if (indexInGroup != 0) {
                charIndex = HexExtensionsKt.toCharArrayIfNotEmpty(byteSeparator, charArray, charIndex);
            }
            charIndex = HexExtensionsKt.formatByteAt($this$toHexStringSlowPath, byteIndex, bytePrefix, byteSuffix, byteToDigits, charArray, charIndex);
            ++indexInGroup;
            ++indexInLine;
        }
        boolean bl2 = bl = charIndex == formatLength;
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return StringsKt.concatToString(charArray);
    }

    private static final int formatByteAt(byte[] $this$formatByteAt, int index, String bytePrefix, String byteSuffix, int[] byteToDigits, char[] destination, int destinationOffset) {
        int offset = HexExtensionsKt.toCharArrayIfNotEmpty(bytePrefix, destination, destinationOffset);
        offset = HexExtensionsKt.formatByteAt($this$formatByteAt, index, byteToDigits, destination, offset);
        return HexExtensionsKt.toCharArrayIfNotEmpty(byteSuffix, destination, offset);
    }

    private static final int formatByteAt(byte[] $this$formatByteAt, int index, int[] byteToDigits, char[] destination, int destinationOffset) {
        int n = $this$formatByteAt[index] & 0xFF;
        int byteDigits = byteToDigits[n];
        destination[destinationOffset] = (char)(byteDigits >> 8);
        destination[destinationOffset + 1] = (char)(byteDigits & 0xFF);
        return destinationOffset + 2;
    }

    private static final int formattedStringLength(int numberOfBytes, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        boolean bl;
        boolean bl2 = bl = numberOfBytes > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long charsPerByte = 2L + (long)bytePrefixLength + (long)byteSuffixLength + (long)byteSeparatorLength;
        long formatLength = (long)numberOfBytes * charsPerByte - (long)byteSeparatorLength;
        return HexExtensionsKt.checkFormatLength(formatLength);
    }

    public static final int formattedStringLength(int numberOfBytes, int bytesPerLine, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        int n;
        boolean bl;
        boolean bl2 = bl = numberOfBytes > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int lineSeparators = (numberOfBytes - 1) / bytesPerLine;
        boolean bl3 = false;
        int groupSeparatorsPerLine = (bytesPerLine - 1) / bytesPerGroup;
        int it = n = numberOfBytes % bytesPerLine;
        boolean bl4 = false;
        int bytesInLastLine = it == 0 ? bytesPerLine : it;
        int groupSeparatorsInLastLine = (bytesInLastLine - 1) / bytesPerGroup;
        int groupSeparators = lineSeparators * groupSeparatorsPerLine + groupSeparatorsInLastLine;
        int byteSeparators = numberOfBytes - 1 - lineSeparators - groupSeparators;
        long formatLength = (long)lineSeparators + (long)groupSeparators * (long)groupSeparatorLength + (long)byteSeparators * (long)byteSeparatorLength + (long)numberOfBytes * ((long)bytePrefixLength + 2L + (long)byteSuffixLength);
        return HexExtensionsKt.checkFormatLength(formatLength);
    }

    private static final int checkFormatLength(long formatLength) {
        if (!RangesKt.intRangeContains((ClosedRange<Integer>)new IntRange(0, Integer.MAX_VALUE), formatLength)) {
            throw new IllegalArgumentException("The resulting string length is too big: " + ULong.toString-impl(ULong.constructor-impl(formatLength)));
        }
        return (int)formatLength;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final byte[] hexToByteArray(@NotNull String $this$hexToByteArray, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToByteArray, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToByteArray($this$hexToByteArray, 0, $this$hexToByteArray.length(), format);
    }

    public static /* synthetic */ byte[] hexToByteArray$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte[] hexToByteArray(String $this$hexToByteArray, int startIndex, int endIndex, HexFormat format) {
        byte[] byArray;
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToByteArray.length());
        if (startIndex == endIndex) {
            return new byte[0];
        }
        HexFormat.BytesHexFormat bytesFormat = format.getBytes();
        if (bytesFormat.getNoLineAndGroupSeparator$kotlin_stdlib() && (byArray = HexExtensionsKt.hexToByteArrayNoLineAndGroupSeparator($this$hexToByteArray, startIndex, endIndex, bytesFormat)) != null) {
            byte[] byArray2;
            byte[] it = byArray2 = byArray;
            boolean bl = false;
            return it;
        }
        return HexExtensionsKt.hexToByteArraySlowPath($this$hexToByteArray, startIndex, endIndex, bytesFormat);
    }

    static /* synthetic */ byte[] hexToByteArray$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByteArray(string, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte[] hexToByteArrayNoLineAndGroupSeparator(String $this$hexToByteArrayNoLineAndGroupSeparator, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat) {
        if (bytesFormat.getShortByteSeparatorNoPrefixAndSuffix$kotlin_stdlib()) {
            return HexExtensionsKt.hexToByteArrayShortByteSeparatorNoPrefixAndSuffix($this$hexToByteArrayNoLineAndGroupSeparator, startIndex, endIndex, bytesFormat);
        }
        return HexExtensionsKt.hexToByteArrayNoLineAndGroupSeparatorSlowPath($this$hexToByteArrayNoLineAndGroupSeparator, startIndex, endIndex, bytesFormat);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final byte[] hexToByteArrayShortByteSeparatorNoPrefixAndSuffix(String $this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat) {
        boolean bl;
        int byteSeparatorLength = bytesFormat.getByteSeparator().length();
        boolean bl2 = bl = byteSeparatorLength <= 1;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int numberOfChars = endIndex - startIndex;
        int charIndex = 0;
        if (byteSeparatorLength == 0) {
            if ((numberOfChars & 1) != 0) {
                return null;
            }
            int numberOfBytes = numberOfChars >> 1;
            byte[] byteArray = new byte[numberOfBytes];
            for (int byteIndex = 0; byteIndex < numberOfBytes; ++byteIndex) {
                byteArray[byteIndex] = HexExtensionsKt.parseByteAt($this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix, charIndex);
                charIndex += 2;
            }
            return byteArray;
        }
        if (numberOfChars % 3 != 2) {
            return null;
        }
        int numberOfBytes = numberOfChars / 3 + 1;
        byte[] byteArray = new byte[numberOfBytes];
        char byteSeparatorChar = bytesFormat.getByteSeparator().charAt(0);
        byteArray[0] = HexExtensionsKt.parseByteAt($this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix, charIndex);
        charIndex += 2;
        for (int byteIndex = 1; byteIndex < numberOfBytes; ++byteIndex) {
            if ($this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix.charAt(charIndex) != byteSeparatorChar) {
                void part$iv;
                String string = $this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix;
                String string2 = bytesFormat.getByteSeparator();
                boolean bl3 = bytesFormat.getIgnoreCase$kotlin_stdlib();
                String partName$iv = "byte separator";
                boolean $i$f$checkContainsAt = false;
                if (!(((CharSequence)part$iv).length() == 0)) {
                    int n = part$iv.length();
                    for (int i$iv = 0; i$iv < n; ++i$iv) {
                        void ignoreCase$iv;
                        void $this$checkContainsAt$iv;
                        if (CharsKt.equals(part$iv.charAt(i$iv), $this$checkContainsAt$iv.charAt(charIndex + i$iv), (boolean)ignoreCase$iv)) continue;
                        HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, charIndex, endIndex, (String)part$iv, partName$iv);
                    }
                    int cfr_ignored_0 = charIndex + part$iv.length();
                }
            }
            byteArray[byteIndex] = HexExtensionsKt.parseByteAt($this$hexToByteArrayShortByteSeparatorNoPrefixAndSuffix, charIndex + 1);
            charIndex += 3;
        }
        return byteArray;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final byte[] hexToByteArrayNoLineAndGroupSeparatorSlowPath(String $this$hexToByteArrayNoLineAndGroupSeparatorSlowPath, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat) {
        int n;
        int n2;
        long charsPerByte;
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        long numberOfChars = endIndex - startIndex;
        String byteSeparator = bytesFormat.getByteSeparator();
        int byteSeparatorLength = byteSeparator.length();
        int numberOfBytes = (int)((numberOfChars + (long)byteSeparatorLength) / (charsPerByte = 2L + (long)bytePrefix.length() + (long)byteSuffix.length() + (long)byteSeparatorLength));
        if ((long)numberOfBytes * charsPerByte - (long)byteSeparatorLength != numberOfChars) {
            return null;
        }
        boolean ignoreCase = bytesFormat.getIgnoreCase$kotlin_stdlib();
        byte[] byteArray = new byte[numberOfBytes];
        int charIndex = startIndex;
        String string = $this$hexToByteArrayNoLineAndGroupSeparatorSlowPath;
        String partName$iv = "byte prefix";
        int $i$f$checkContainsAt = 0;
        if (((CharSequence)bytePrefix).length() == 0) {
            n2 = charIndex;
        } else {
            n = bytePrefix.length();
            for (int i$iv = 0; i$iv < n; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(bytePrefix.charAt(i$iv), $this$checkContainsAt$iv.charAt(charIndex + i$iv), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, charIndex, endIndex, bytePrefix, partName$iv);
            }
            n2 = charIndex + bytePrefix.length();
        }
        charIndex = n2;
        String between = byteSuffix + byteSeparator + bytePrefix;
        $i$f$checkContainsAt = numberOfBytes - 1;
        for (int byteIndex = 0; byteIndex < $i$f$checkContainsAt; ++byteIndex) {
            void v1;
            void index$iv;
            byteArray[byteIndex] = HexExtensionsKt.parseByteAt($this$hexToByteArrayNoLineAndGroupSeparatorSlowPath, charIndex);
            String i$iv = $this$hexToByteArrayNoLineAndGroupSeparatorSlowPath;
            n = charIndex + 2;
            String partName$iv2 = "byte suffix + byte separator + byte prefix";
            boolean $i$f$checkContainsAt2 = false;
            if (((CharSequence)between).length() == 0) {
                v1 = index$iv;
            } else {
                int n3 = between.length();
                for (int i$iv2 = 0; i$iv2 < n3; ++i$iv2) {
                    void $this$checkContainsAt$iv;
                    if (CharsKt.equals(between.charAt(i$iv2), $this$checkContainsAt$iv.charAt((int)(index$iv + i$iv2)), ignoreCase)) continue;
                    HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, (int)index$iv, endIndex, between, partName$iv2);
                }
                v1 = index$iv + between.length();
            }
            charIndex = v1;
        }
        byteArray[numberOfBytes - 1] = HexExtensionsKt.parseByteAt($this$hexToByteArrayNoLineAndGroupSeparatorSlowPath, charIndex);
        String byteIndex = $this$hexToByteArrayNoLineAndGroupSeparatorSlowPath;
        $i$f$checkContainsAt = charIndex + 2;
        String partName$iv3 = "byte suffix";
        boolean $i$f$checkContainsAt3 = false;
        if (!(((CharSequence)byteSuffix).length() == 0)) {
            void index$iv;
            int n4 = byteSuffix.length();
            for (int i$iv = 0; i$iv < n4; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(byteSuffix.charAt(i$iv), $this$checkContainsAt$iv.charAt((int)(index$iv + i$iv)), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, (int)index$iv, endIndex, byteSuffix, partName$iv3);
            }
            void cfr_ignored_0 = index$iv + byteSuffix.length();
        }
        return byteArray;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalStdlibApi
    private static final byte[] hexToByteArraySlowPath(String $this$hexToByteArraySlowPath, int startIndex, int endIndex, HexFormat.BytesHexFormat bytesFormat) {
        byte[] byArray;
        int bytesPerLine = bytesFormat.getBytesPerLine();
        int bytesPerGroup = bytesFormat.getBytesPerGroup();
        String bytePrefix = bytesFormat.getBytePrefix();
        String byteSuffix = bytesFormat.getByteSuffix();
        String byteSeparator = bytesFormat.getByteSeparator();
        String groupSeparator = bytesFormat.getGroupSeparator();
        boolean ignoreCase = bytesFormat.getIgnoreCase$kotlin_stdlib();
        int parseMaxSize = HexExtensionsKt.parsedByteArrayMaxSize(endIndex - startIndex, bytesPerLine, bytesPerGroup, groupSeparator.length(), byteSeparator.length(), bytePrefix.length(), byteSuffix.length());
        byte[] byteArray = new byte[parseMaxSize];
        int charIndex = startIndex;
        int byteIndex = 0;
        int indexInLine = 0;
        int indexInGroup = 0;
        while (charIndex < endIndex) {
            void v3;
            void index$iv;
            int n;
            String $this$checkContainsAt$iv;
            int i$iv;
            int n2;
            boolean $i$f$checkContainsAt;
            String partName$iv;
            if (indexInLine == bytesPerLine) {
                charIndex = HexExtensionsKt.checkNewLineAt($this$hexToByteArraySlowPath, charIndex, endIndex);
                indexInLine = 0;
                indexInGroup = 0;
            } else if (indexInGroup == bytesPerGroup) {
                int n3;
                String string = $this$hexToByteArraySlowPath;
                partName$iv = "group separator";
                $i$f$checkContainsAt = false;
                if (((CharSequence)groupSeparator).length() == 0) {
                    n3 = charIndex;
                } else {
                    n2 = groupSeparator.length();
                    for (i$iv = 0; i$iv < n2; ++i$iv) {
                        if (CharsKt.equals(groupSeparator.charAt(i$iv), $this$checkContainsAt$iv.charAt(charIndex + i$iv), ignoreCase)) continue;
                        HexExtensionsKt.throwNotContainedAt($this$checkContainsAt$iv, charIndex, endIndex, groupSeparator, partName$iv);
                    }
                    n3 = charIndex + groupSeparator.length();
                }
                charIndex = n3;
                indexInGroup = 0;
            } else if (indexInGroup != 0) {
                int n4;
                $this$checkContainsAt$iv = $this$hexToByteArraySlowPath;
                String partName$iv2 = "byte separator";
                boolean $i$f$checkContainsAt2 = false;
                if (((CharSequence)byteSeparator).length() == 0) {
                    n4 = charIndex;
                } else {
                    n2 = byteSeparator.length();
                    for (i$iv = 0; i$iv < n2; ++i$iv) {
                        if (CharsKt.equals(byteSeparator.charAt(i$iv), $this$checkContainsAt$iv.charAt(charIndex + i$iv), ignoreCase)) continue;
                        HexExtensionsKt.throwNotContainedAt($this$checkContainsAt$iv, charIndex, endIndex, byteSeparator, partName$iv2);
                    }
                    n4 = charIndex + byteSeparator.length();
                }
                charIndex = n4;
            }
            ++indexInLine;
            ++indexInGroup;
            $this$checkContainsAt$iv = $this$hexToByteArraySlowPath;
            partName$iv = "byte prefix";
            $i$f$checkContainsAt = false;
            if (((CharSequence)bytePrefix).length() == 0) {
                n = charIndex;
            } else {
                n2 = bytePrefix.length();
                for (i$iv = 0; i$iv < n2; ++i$iv) {
                    if (CharsKt.equals(bytePrefix.charAt(i$iv), $this$checkContainsAt$iv.charAt(charIndex + i$iv), ignoreCase)) continue;
                    HexExtensionsKt.throwNotContainedAt($this$checkContainsAt$iv, charIndex, endIndex, bytePrefix, partName$iv);
                }
                n = charIndex = charIndex + bytePrefix.length();
            }
            if (endIndex - 2 < charIndex) {
                HexExtensionsKt.throwInvalidNumberOfDigits($this$hexToByteArraySlowPath, charIndex, endIndex, 2, true);
            }
            byteArray[byteIndex++] = HexExtensionsKt.parseByteAt($this$hexToByteArraySlowPath, charIndex);
            $this$checkContainsAt$iv = $this$hexToByteArraySlowPath;
            int partName$iv2 = charIndex + 2;
            String partName$iv3 = "byte suffix";
            boolean $i$f$checkContainsAt3 = false;
            if (((CharSequence)byteSuffix).length() == 0) {
                v3 = index$iv;
            } else {
                int n5 = byteSuffix.length();
                for (int i$iv2 = 0; i$iv2 < n5; ++i$iv2) {
                    if (CharsKt.equals(byteSuffix.charAt(i$iv2), $this$checkContainsAt$iv.charAt((int)(index$iv + i$iv2)), ignoreCase)) continue;
                    HexExtensionsKt.throwNotContainedAt($this$checkContainsAt$iv, (int)index$iv, endIndex, byteSuffix, partName$iv3);
                }
                v3 = index$iv + byteSuffix.length();
            }
            charIndex = v3;
        }
        if (byteIndex == byteArray.length) {
            byArray = byteArray;
        } else {
            byte[] byArray2 = Arrays.copyOf(byteArray, byteIndex);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue(byArray2, "copyOf(...)");
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final byte parseByteAt(String $this$parseByteAt, int index) {
        void $this$decimalFromHexDigitAt$iv;
        String $this$decimalFromHexDigitAt$iv2 = $this$parseByteAt;
        boolean $i$f$decimalFromHexDigitAt22 = false;
        char code$iv = $this$decimalFromHexDigitAt$iv2.charAt(index);
        if (code$iv >>> 8 != 0 || HEX_DIGITS_TO_DECIMAL[code$iv] < 0) {
            HexExtensionsKt.throwInvalidDigitAt($this$decimalFromHexDigitAt$iv2, index);
            throw new KotlinNothingValueException();
        }
        int high = HEX_DIGITS_TO_DECIMAL[code$iv];
        String $i$f$decimalFromHexDigitAt22 = $this$parseByteAt;
        int index$iv = index + 1;
        boolean $i$f$decimalFromHexDigitAt = false;
        char code$iv2 = $this$decimalFromHexDigitAt$iv.charAt(index$iv);
        if (code$iv2 >>> 8 != 0 || HEX_DIGITS_TO_DECIMAL[code$iv2] < 0) {
            HexExtensionsKt.throwInvalidDigitAt((String)$this$decimalFromHexDigitAt$iv, index$iv);
            throw new KotlinNothingValueException();
        }
        int low = HEX_DIGITS_TO_DECIMAL[code$iv2];
        return (byte)(high << 4 | low);
    }

    public static final int parsedByteArrayMaxSize(int stringLength, int bytesPerLine, int bytesPerGroup, int groupSeparatorLength, int byteSeparatorLength, int bytePrefixLength, int byteSuffixLength) {
        long l;
        boolean bl;
        boolean bl2 = bl = stringLength > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long charsPerByte = (long)bytePrefixLength + 2L + (long)byteSuffixLength;
        long charsPerGroup = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerGroup, byteSeparatorLength);
        if (bytesPerLine <= bytesPerGroup) {
            l = HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLine, byteSeparatorLength);
        } else {
            int groupsPerLine = bytesPerLine / bytesPerGroup;
            long result = HexExtensionsKt.charsPerSet(charsPerGroup, groupsPerLine, groupSeparatorLength);
            int bytesPerLastGroupInLine = bytesPerLine % bytesPerGroup;
            if (bytesPerLastGroupInLine != 0) {
                result += (long)groupSeparatorLength;
                result += HexExtensionsKt.charsPerSet(charsPerByte, bytesPerLastGroupInLine, byteSeparatorLength);
            }
            l = result;
        }
        long charsPerLine = l;
        long numberOfChars = stringLength;
        long wholeLines = HexExtensionsKt.wholeElementsPerSet(numberOfChars, charsPerLine, 1);
        long wholeGroupsInLastLine = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeLines * (charsPerLine + 1L), charsPerGroup, groupSeparatorLength);
        long wholeBytesInLastGroup = HexExtensionsKt.wholeElementsPerSet(numberOfChars -= wholeGroupsInLastLine * (charsPerGroup + (long)groupSeparatorLength), charsPerByte, byteSeparatorLength);
        int spare = (numberOfChars -= wholeBytesInLastGroup * (charsPerByte + (long)byteSeparatorLength)) > 0L ? 1 : 0;
        return (int)(wholeLines * (long)bytesPerLine + wholeGroupsInLastLine * (long)bytesPerGroup + wholeBytesInLastGroup + (long)spare);
    }

    private static final long charsPerSet(long charsPerElement, int elementsPerSet, int elementSeparatorLength) {
        boolean bl;
        boolean bl2 = bl = elementsPerSet > 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return charsPerElement * (long)elementsPerSet + (long)elementSeparatorLength * ((long)elementsPerSet - 1L);
    }

    private static final long wholeElementsPerSet(long charsPerSet, long charsPerElement, int elementSeparatorLength) {
        return charsPerSet <= 0L || charsPerElement <= 0L ? 0L : (charsPerSet + (long)elementSeparatorLength) / (charsPerElement + (long)elementSeparatorLength);
    }

    private static final int checkNewLineAt(String $this$checkNewLineAt, int index, int endIndex) {
        int n;
        if ($this$checkNewLineAt.charAt(index) == '\r') {
            n = index + 1 < endIndex && $this$checkNewLineAt.charAt(index + 1) == '\n' ? index + 2 : index + 1;
        } else if ($this$checkNewLineAt.charAt(index) == '\n') {
            n = index + 1;
        } else {
            throw new NumberFormatException("Expected a new line at index " + index + ", but was " + $this$checkNewLineAt.charAt(index));
        }
        return n;
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(byte $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            char[] charArray = new char[2];
            byte value = $this$toHexString;
            charArray[0] = digits.charAt(value >> 4 & 0xF);
            charArray[1] = digits.charAt(value & 0xF);
            return numberFormat.getRemoveLeadingZeros() ? StringsKt.concatToString$default(charArray, RangesKt.coerceAtMost(Integer.numberOfLeadingZeros($this$toHexString & 0xFF) - 24 >> 2, 1), 0, 2, null) : StringsKt.concatToString(charArray);
        }
        return HexExtensionsKt.toHexStringImpl($this$toHexString, numberFormat, digits, 8);
    }

    public static /* synthetic */ String toHexString$default(byte by, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(by, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final byte hexToByte(@NotNull String $this$hexToByte, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToByte, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToByte($this$hexToByte, 0, $this$hexToByte.length(), format);
    }

    public static /* synthetic */ byte hexToByte$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final byte hexToByte(String $this$hexToByte, int startIndex, int endIndex, HexFormat format) {
        return (byte)HexExtensionsKt.hexToIntImpl($this$hexToByte, startIndex, endIndex, format, 2);
    }

    static /* synthetic */ byte hexToByte$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToByte(string, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(short $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            char[] charArray = new char[4];
            short value = $this$toHexString;
            charArray[0] = digits.charAt(value >> 12 & 0xF);
            charArray[1] = digits.charAt(value >> 8 & 0xF);
            charArray[2] = digits.charAt(value >> 4 & 0xF);
            charArray[3] = digits.charAt(value & 0xF);
            return numberFormat.getRemoveLeadingZeros() ? StringsKt.concatToString$default(charArray, RangesKt.coerceAtMost(Integer.numberOfLeadingZeros($this$toHexString & 0xFFFF) - 16 >> 2, 3), 0, 2, null) : StringsKt.concatToString(charArray);
        }
        return HexExtensionsKt.toHexStringImpl($this$toHexString, numberFormat, digits, 16);
    }

    public static /* synthetic */ String toHexString$default(short s, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(s, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final short hexToShort(@NotNull String $this$hexToShort, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToShort, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToShort($this$hexToShort, 0, $this$hexToShort.length(), format);
    }

    public static /* synthetic */ short hexToShort$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final short hexToShort(String $this$hexToShort, int startIndex, int endIndex, HexFormat format) {
        return (short)HexExtensionsKt.hexToIntImpl($this$hexToShort, startIndex, endIndex, format, 4);
    }

    static /* synthetic */ short hexToShort$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToShort(string, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(int $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            char[] charArray = new char[8];
            int value = $this$toHexString;
            charArray[0] = digits.charAt(value >> 28 & 0xF);
            charArray[1] = digits.charAt(value >> 24 & 0xF);
            charArray[2] = digits.charAt(value >> 20 & 0xF);
            charArray[3] = digits.charAt(value >> 16 & 0xF);
            charArray[4] = digits.charAt(value >> 12 & 0xF);
            charArray[5] = digits.charAt(value >> 8 & 0xF);
            charArray[6] = digits.charAt(value >> 4 & 0xF);
            charArray[7] = digits.charAt(value & 0xF);
            return numberFormat.getRemoveLeadingZeros() ? StringsKt.concatToString$default(charArray, RangesKt.coerceAtMost(Integer.numberOfLeadingZeros($this$toHexString) >> 2, 7), 0, 2, null) : StringsKt.concatToString(charArray);
        }
        return HexExtensionsKt.toHexStringImpl($this$toHexString, numberFormat, digits, 32);
    }

    public static /* synthetic */ String toHexString$default(int n, HexFormat hexFormat, int n2, Object object) {
        if ((n2 & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(n, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final int hexToInt(@NotNull String $this$hexToInt, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToInt, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToInt($this$hexToInt, 0, $this$hexToInt.length(), format);
    }

    public static /* synthetic */ int hexToInt$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final int hexToInt(String $this$hexToInt, int startIndex, int endIndex, HexFormat format) {
        return HexExtensionsKt.hexToIntImpl($this$hexToInt, startIndex, endIndex, format, 8);
    }

    static /* synthetic */ int hexToInt$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToInt(string, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    @NotNull
    public static final String toHexString(long $this$toHexString, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter(format, "format");
        String digits = format.getUpperCase() ? UPPER_CASE_HEX_DIGITS : LOWER_CASE_HEX_DIGITS;
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            char[] charArray = new char[16];
            long value = $this$toHexString;
            charArray[0] = digits.charAt((int)(value >> 60 & 0xFL));
            charArray[1] = digits.charAt((int)(value >> 56 & 0xFL));
            charArray[2] = digits.charAt((int)(value >> 52 & 0xFL));
            charArray[3] = digits.charAt((int)(value >> 48 & 0xFL));
            charArray[4] = digits.charAt((int)(value >> 44 & 0xFL));
            charArray[5] = digits.charAt((int)(value >> 40 & 0xFL));
            charArray[6] = digits.charAt((int)(value >> 36 & 0xFL));
            charArray[7] = digits.charAt((int)(value >> 32 & 0xFL));
            charArray[8] = digits.charAt((int)(value >> 28 & 0xFL));
            charArray[9] = digits.charAt((int)(value >> 24 & 0xFL));
            charArray[10] = digits.charAt((int)(value >> 20 & 0xFL));
            charArray[11] = digits.charAt((int)(value >> 16 & 0xFL));
            charArray[12] = digits.charAt((int)(value >> 12 & 0xFL));
            charArray[13] = digits.charAt((int)(value >> 8 & 0xFL));
            charArray[14] = digits.charAt((int)(value >> 4 & 0xFL));
            charArray[15] = digits.charAt((int)(value & 0xFL));
            return numberFormat.getRemoveLeadingZeros() ? StringsKt.concatToString$default(charArray, RangesKt.coerceAtMost(Long.numberOfLeadingZeros($this$toHexString) >> 2, 15), 0, 2, null) : StringsKt.concatToString(charArray);
        }
        return HexExtensionsKt.toHexStringImpl($this$toHexString, numberFormat, digits, 64);
    }

    public static /* synthetic */ String toHexString$default(long l, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.toHexString(l, hexFormat);
    }

    @ExperimentalStdlibApi
    @SinceKotlin(version="1.9")
    public static final long hexToLong(@NotNull String $this$hexToLong, @NotNull HexFormat format) {
        Intrinsics.checkNotNullParameter($this$hexToLong, "<this>");
        Intrinsics.checkNotNullParameter(format, "format");
        return HexExtensionsKt.hexToLong($this$hexToLong, 0, $this$hexToLong.length(), format);
    }

    public static /* synthetic */ long hexToLong$default(String string, HexFormat hexFormat, int n, Object object) {
        if ((n & 1) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final long hexToLong(String $this$hexToLong, int startIndex, int endIndex, HexFormat format) {
        return HexExtensionsKt.hexToLongImpl($this$hexToLong, startIndex, endIndex, format, 16);
    }

    static /* synthetic */ long hexToLong$default(String string, int n, int n2, HexFormat hexFormat, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = string.length();
        }
        if ((n3 & 4) != 0) {
            hexFormat = HexFormat.Companion.getDefault();
        }
        return HexExtensionsKt.hexToLong(string, n, n2, hexFormat);
    }

    @ExperimentalStdlibApi
    private static final String toHexStringImpl(long $this$toHexStringImpl, HexFormat.NumberHexFormat numberFormat, String digits, int bits) {
        boolean bl;
        boolean bl2 = bl = (bits & 3) == 0;
        if (!bl) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long value = $this$toHexStringImpl;
        int numberOfHexDigits = bits >> 2;
        String prefix = numberFormat.getPrefix();
        String suffix = numberFormat.getSuffix();
        boolean removeZeros = false;
        removeZeros = numberFormat.getRemoveLeadingZeros();
        long formatLength = (long)prefix.length() + (long)numberOfHexDigits + (long)suffix.length();
        char[] charArray = new char[HexExtensionsKt.checkFormatLength(formatLength)];
        int charIndex = 0;
        charIndex = HexExtensionsKt.toCharArrayIfNotEmpty(prefix, charArray, 0);
        int shift = 0;
        shift = bits;
        for (int i = 0; i < numberOfHexDigits; ++i) {
            int it = i;
            boolean bl3 = false;
            int decimal = (int)(value >> (shift -= 4) & 0xFL);
            boolean bl4 = removeZeros = removeZeros && decimal == 0 && shift > 0;
            if (removeZeros) continue;
            int n = charIndex;
            charIndex = n + 1;
            charArray[n] = digits.charAt(decimal);
        }
        return (charIndex = HexExtensionsKt.toCharArrayIfNotEmpty(suffix, charArray, charIndex)) == charArray.length ? StringsKt.concatToString(charArray) : StringsKt.concatToString$default(charArray, 0, charIndex, 1, null);
    }

    private static final int toCharArrayIfNotEmpty(String $this$toCharArrayIfNotEmpty, char[] destination, int destinationOffset) {
        switch ($this$toCharArrayIfNotEmpty.length()) {
            case 0: {
                break;
            }
            case 1: {
                destination[destinationOffset] = $this$toCharArrayIfNotEmpty.charAt(0);
                break;
            }
            default: {
                String string = $this$toCharArrayIfNotEmpty;
                int n = 0;
                int n2 = string.length();
                Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
                string.getChars(n, n2, destination, destinationOffset);
            }
        }
        return destinationOffset + $this$toCharArrayIfNotEmpty.length();
    }

    @ExperimentalStdlibApi
    private static final int hexToIntImpl(String $this$hexToIntImpl, int startIndex, int endIndex, HexFormat format, int maxDigits) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToIntImpl.length());
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            HexExtensionsKt.checkMaxDigits($this$hexToIntImpl, startIndex, endIndex, maxDigits);
            return HexExtensionsKt.parseInt($this$hexToIntImpl, startIndex, endIndex);
        }
        String prefix = numberFormat.getPrefix();
        String suffix = numberFormat.getSuffix();
        HexExtensionsKt.checkPrefixSuffixMaxDigits($this$hexToIntImpl, startIndex, endIndex, prefix, suffix, numberFormat.getIgnoreCase$kotlin_stdlib(), maxDigits);
        return HexExtensionsKt.parseInt($this$hexToIntImpl, startIndex + prefix.length(), endIndex - suffix.length());
    }

    @ExperimentalStdlibApi
    private static final long hexToLongImpl(String $this$hexToLongImpl, int startIndex, int endIndex, HexFormat format, int maxDigits) {
        AbstractList.Companion.checkBoundsIndexes$kotlin_stdlib(startIndex, endIndex, $this$hexToLongImpl.length());
        HexFormat.NumberHexFormat numberFormat = format.getNumber();
        if (numberFormat.isDigitsOnly$kotlin_stdlib()) {
            HexExtensionsKt.checkMaxDigits($this$hexToLongImpl, startIndex, endIndex, maxDigits);
            return HexExtensionsKt.parseLong($this$hexToLongImpl, startIndex, endIndex);
        }
        String prefix = numberFormat.getPrefix();
        String suffix = numberFormat.getSuffix();
        HexExtensionsKt.checkPrefixSuffixMaxDigits($this$hexToLongImpl, startIndex, endIndex, prefix, suffix, numberFormat.getIgnoreCase$kotlin_stdlib(), maxDigits);
        return HexExtensionsKt.parseLong($this$hexToLongImpl, startIndex + prefix.length(), endIndex - suffix.length());
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkPrefixSuffixMaxDigits(String $this$checkPrefixSuffixMaxDigits, int startIndex, int endIndex, String prefix, String suffix, boolean ignoreCase, int maxDigits) {
        int n;
        if (endIndex - startIndex - prefix.length() <= suffix.length()) {
            HexExtensionsKt.throwInvalidPrefixSuffix($this$checkPrefixSuffixMaxDigits, startIndex, endIndex, prefix, suffix);
        }
        String string = $this$checkPrefixSuffixMaxDigits;
        String partName$iv = "prefix";
        boolean $i$f$checkContainsAt = false;
        if (((CharSequence)prefix).length() == 0) {
            n = startIndex;
        } else {
            int n2 = prefix.length();
            for (int i$iv = 0; i$iv < n2; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(prefix.charAt(i$iv), $this$checkContainsAt$iv.charAt(startIndex + i$iv), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, startIndex, endIndex, prefix, partName$iv);
            }
            n = startIndex + prefix.length();
        }
        int digitsStartIndex = n;
        int digitsEndIndex = endIndex - suffix.length();
        partName$iv = $this$checkPrefixSuffixMaxDigits;
        String partName$iv2 = "suffix";
        boolean $i$f$checkContainsAt2 = false;
        if (!(((CharSequence)suffix).length() == 0)) {
            int n3 = suffix.length();
            for (int i$iv = 0; i$iv < n3; ++i$iv) {
                void $this$checkContainsAt$iv;
                if (CharsKt.equals(suffix.charAt(i$iv), $this$checkContainsAt$iv.charAt(digitsEndIndex + i$iv), ignoreCase)) continue;
                HexExtensionsKt.throwNotContainedAt((String)$this$checkContainsAt$iv, digitsEndIndex, endIndex, suffix, partName$iv2);
            }
            int cfr_ignored_0 = digitsEndIndex + suffix.length();
        }
        HexExtensionsKt.checkMaxDigits($this$checkPrefixSuffixMaxDigits, digitsStartIndex, digitsEndIndex, maxDigits);
    }

    private static final void checkMaxDigits(String $this$checkMaxDigits, int startIndex, int endIndex, int maxDigits) {
        if (startIndex >= endIndex || endIndex - startIndex > maxDigits) {
            HexExtensionsKt.throwInvalidNumberOfDigits($this$checkMaxDigits, startIndex, endIndex, maxDigits, false);
        }
    }

    private static final int parseInt(String $this$parseInt, int startIndex, int endIndex) {
        int result = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            String $this$decimalFromHexDigitAt$iv = $this$parseInt;
            boolean $i$f$decimalFromHexDigitAt = false;
            char code$iv = $this$decimalFromHexDigitAt$iv.charAt(i);
            if (code$iv >>> 8 != 0 || HEX_DIGITS_TO_DECIMAL[code$iv] < 0) {
                HexExtensionsKt.throwInvalidDigitAt($this$decimalFromHexDigitAt$iv, i);
                throw new KotlinNothingValueException();
            }
            result = result << 4 | HEX_DIGITS_TO_DECIMAL[code$iv];
        }
        return result;
    }

    private static final long parseLong(String $this$parseLong, int startIndex, int endIndex) {
        long result = 0L;
        for (int i = startIndex; i < endIndex; ++i) {
            String $this$longDecimalFromHexDigitAt$iv = $this$parseLong;
            boolean $i$f$longDecimalFromHexDigitAt = false;
            char code$iv = $this$longDecimalFromHexDigitAt$iv.charAt(i);
            if (code$iv >>> 8 != 0 || HEX_DIGITS_TO_LONG_DECIMAL[code$iv] < 0L) {
                HexExtensionsKt.throwInvalidDigitAt($this$longDecimalFromHexDigitAt$iv, i);
                throw new KotlinNothingValueException();
            }
            result = result << 4 | HEX_DIGITS_TO_LONG_DECIMAL[code$iv];
        }
        return result;
    }

    private static final int checkContainsAt(String $this$checkContainsAt, int index, int endIndex, String part, boolean ignoreCase, String partName) {
        boolean $i$f$checkContainsAt = false;
        if (((CharSequence)part).length() == 0) {
            return index;
        }
        int n = part.length();
        for (int i = 0; i < n; ++i) {
            if (CharsKt.equals(part.charAt(i), $this$checkContainsAt.charAt(index + i), ignoreCase)) continue;
            HexExtensionsKt.throwNotContainedAt($this$checkContainsAt, index, endIndex, part, partName);
        }
        return index + part.length();
    }

    private static final int decimalFromHexDigitAt(String $this$decimalFromHexDigitAt, int index) {
        boolean $i$f$decimalFromHexDigitAt = false;
        char code = $this$decimalFromHexDigitAt.charAt(index);
        if (code >>> 8 == 0 && HEX_DIGITS_TO_DECIMAL[code] >= 0) {
            return HEX_DIGITS_TO_DECIMAL[code];
        }
        HexExtensionsKt.throwInvalidDigitAt($this$decimalFromHexDigitAt, index);
        throw new KotlinNothingValueException();
    }

    private static final long longDecimalFromHexDigitAt(String $this$longDecimalFromHexDigitAt, int index) {
        boolean $i$f$longDecimalFromHexDigitAt = false;
        char code = $this$longDecimalFromHexDigitAt.charAt(index);
        if (code >>> 8 == 0 && HEX_DIGITS_TO_LONG_DECIMAL[code] >= 0L) {
            return HEX_DIGITS_TO_LONG_DECIMAL[code];
        }
        HexExtensionsKt.throwInvalidDigitAt($this$longDecimalFromHexDigitAt, index);
        throw new KotlinNothingValueException();
    }

    private static final void throwInvalidNumberOfDigits(String $this$throwInvalidNumberOfDigits, int startIndex, int endIndex, int maxDigits, boolean requireMaxLength) {
        String specifier = requireMaxLength ? "exactly" : "at most";
        String string = $this$throwInvalidNumberOfDigits;
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected " + specifier + ' ' + maxDigits + " hexadecimal digits at index " + startIndex + ", but was " + substring + " of length " + (endIndex - startIndex));
    }

    private static final void throwNotContainedAt(String $this$throwNotContainedAt, int index, int endIndex, String part, String partName) {
        String string = $this$throwNotContainedAt;
        int n = RangesKt.coerceAtMost(index + part.length(), endIndex);
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(index, n);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected " + partName + " \"" + part + "\" at index " + index + ", but was " + substring);
    }

    private static final void throwInvalidPrefixSuffix(String $this$throwInvalidPrefixSuffix, int startIndex, int endIndex, String prefix, String suffix) {
        String string = $this$throwInvalidPrefixSuffix;
        Intrinsics.checkNotNull(string, "null cannot be cast to non-null type java.lang.String");
        String string2 = string.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String substring = string2;
        throw new NumberFormatException("Expected a hexadecimal number with prefix \"" + prefix + "\" and suffix \"" + suffix + "\", but was " + substring);
    }

    private static final Void throwInvalidDigitAt(String $this$throwInvalidDigitAt, int index) {
        throw new NumberFormatException("Expected a hexadecimal digit at index " + index + ", but was " + $this$throwInvalidDigitAt.charAt(index));
    }

    static {
        Object[] objectArray;
        char c;
        int index;
        char item$iv;
        int n;
        int[] nArray;
        int n2;
        int n3 = 0;
        int[] nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = LOWER_CASE_HEX_DIGITS.charAt(n2 >> 4) << 8 | LOWER_CASE_HEX_DIGITS.charAt(n2 & 0xF);
        }
        BYTE_TO_LOWER_CASE_HEX_DIGITS = nArray2;
        n3 = 0;
        nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = UPPER_CASE_HEX_DIGITS.charAt(n2 >> 4) << 8 | UPPER_CASE_HEX_DIGITS.charAt(n2 & 0xF);
        }
        BYTE_TO_UPPER_CASE_HEX_DIGITS = nArray2;
        n3 = 0;
        nArray2 = new int[256];
        while (n3 < 256) {
            n2 = n3++;
            nArray2[n2] = -1;
        }
        Object[] $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = nArray = nArray2;
        int n4 = 0;
        CharSequence $this$forEachIndexed$iv = LOWER_CASE_HEX_DIGITS;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n5 = index$iv++;
            char c2 = item$iv;
            index = n5;
            boolean bl = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c] = index;
        }
        $this$forEachIndexed$iv = UPPER_CASE_HEX_DIGITS;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n6 = index$iv++;
            c = item$iv;
            index = n6;
            boolean bl = false;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[c] = index;
        }
        HEX_DIGITS_TO_DECIMAL = nArray;
        int n7 = 0;
        $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242 = new long[256];
        while (n7 < 256) {
            n4 = n7++;
            $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242[n4] = (int)-1L;
        }
        Object[] $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245 = objectArray = $this$HEX_DIGITS_TO_DECIMAL_u24lambda_u242;
        boolean bl = false;
        $this$forEachIndexed$iv = LOWER_CASE_HEX_DIGITS;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n8 = index$iv++;
            c = item$iv;
            index = n8;
            boolean bl2 = false;
            $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245[c] = (int)((long)index);
        }
        $this$forEachIndexed$iv = UPPER_CASE_HEX_DIGITS;
        $i$f$forEachIndexed = false;
        index$iv = 0;
        for (n = 0; n < $this$forEachIndexed$iv.length(); ++n) {
            item$iv = $this$forEachIndexed$iv.charAt(n);
            int n9 = index$iv++;
            c = item$iv;
            index = n9;
            boolean bl3 = false;
            $this$HEX_DIGITS_TO_LONG_DECIMAL_u24lambda_u245[c] = (int)((long)index);
        }
        HEX_DIGITS_TO_LONG_DECIMAL = objectArray;
    }
}

