/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static Provider provider = null;
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};

    public static void createDigest(Ruby runtime2) {
        provider = (Provider)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance();
                }
                catch (Throwable t) {
                    return null;
                }
            }
        });
        RubyModule mDigest = runtime2.defineModule("Digest");
        mDigest.defineAnnotatedMethods(RubyDigest.class);
        RubyModule mDigestInstance = mDigest.defineModuleUnder("Instance");
        mDigestInstance.defineAnnotatedMethods(DigestInstance.class);
        RubyClass cDigestClass = mDigest.defineClassUnder("Class", runtime2.getObject(), DigestClass.DIGEST_CLASS_ALLOCATOR);
        cDigestClass.defineAnnotatedMethods(DigestClass.class);
        cDigestClass.includeModule(mDigestInstance);
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", cDigestClass, DigestBase.DIGEST_BASE_ALLOCATOR);
        cDigestBase.defineAnnotatedMethods(DigestBase.class);
    }

    private static MessageDigest createMessageDigest(Ruby runtime2, String providerName) throws NoSuchAlgorithmException {
        if (provider != null) {
            try {
                return MessageDigest.getInstance(providerName, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(providerName);
    }

    private static ByteList toHex(byte[] val) {
        ByteList byteList = new ByteList(val.length * 2);
        int j = val.length;
        for (int i2 = 0; i2 < j; ++i2) {
            int b = val[i2] & 0xFF;
            byteList.append(digits[b >> 4]);
            byteList.append(digits[b & 0xF]);
        }
        return byteList;
    }

    private static IRubyObject toHexString(Ruby runtime2, byte[] val) {
        return RubyString.newStringNoCopy(runtime2, ByteList.plain(RubyDigest.toHex(val)));
    }

    @JRubyMethod(name={"hexencode"}, required=1, meta=true)
    public static IRubyObject s_hexencode(IRubyObject recv2, IRubyObject arg2) {
        return RubyDigest.toHexString(recv2.getRuntime(), arg2.convertToString().getBytes());
    }

    public static void createDigestMD5(Ruby runtime2) {
        runtime2.getLoadService().require("digest");
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_MD5 = mDigest.defineClassUnder("MD5", cDigestBase, cDigestBase.getAllocator());
        cDigest_MD5.setInternalVariable("metadata", new Metadata("MD5", 64));
    }

    public static void createDigestRMD160(Ruby runtime2) {
        runtime2.getLoadService().require("digest");
        if (provider == null) {
            throw runtime2.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_RMD160 = mDigest.defineClassUnder("RMD160", cDigestBase, cDigestBase.getAllocator());
        cDigest_RMD160.setInternalVariable("metadata", new Metadata("RIPEMD160", 64));
    }

    public static void createDigestSHA1(Ruby runtime2) {
        runtime2.getLoadService().require("digest");
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_SHA1 = mDigest.defineClassUnder("SHA1", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA1.setInternalVariable("metadata", new Metadata("SHA1", 64));
    }

    public static void createDigestSHA2(Ruby runtime2) {
        runtime2.getLoadService().require("digest");
        try {
            RubyDigest.createMessageDigest(runtime2, "SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime2.newLoadError("SHA2 not supported");
        }
        RubyModule mDigest = runtime2.fastGetModule("Digest");
        RubyClass cDigestBase = mDigest.fastGetClass("Base");
        RubyClass cDigest_SHA2_256 = mDigest.defineClassUnder("SHA256", cDigestBase, cDigestBase.getAllocator());
        Metadata sha256Metadata = new Metadata("SHA-256", 64);
        cDigest_SHA2_256.setInternalVariable("metadata", sha256Metadata);
        RubyClass cDigest_SHA2_384 = mDigest.defineClassUnder("SHA384", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_384.setInternalVariable("metadata", new Metadata("SHA-384", 128));
        RubyClass cDigest_SHA2_512 = mDigest.defineClassUnder("SHA512", cDigestBase, cDigestBase.getAllocator());
        cDigest_SHA2_512.setInternalVariable("metadata", new Metadata("SHA-512", 128));
    }

    @JRubyClass(name={"Digest::Base"})
    public static class DigestBase
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_BASE_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new DigestBase(runtime2, klass);
            }
        };
        private MessageDigest algo;
        private int blockLength = 0;

        public DigestBase(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
            if (type2 == runtime2.fastGetModule("Digest").fastGetClass("Base")) {
                throw runtime2.newNotImplementedError("Digest::Base is an abstract class");
            }
            Metadata metadata = this.getMetadata(type2);
            if (metadata == null) {
                throw runtime2.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(metadata);
            }
            catch (NoSuchAlgorithmException e) {
                throw runtime2.newNotImplementedError("the " + type2 + "() function is unimplemented on this machine");
            }
        }

        private Metadata getMetadata(RubyModule type2) {
            for (RubyModule current2 = type2; current2 != null; current2 = current2.getSuperClass()) {
                Metadata metadata = (Metadata)current2.getInternalVariable("metadata");
                if (metadata == null) continue;
                return metadata;
            }
            return null;
        }

        @JRubyMethod(required=1)
        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            ((RubyObject)obj).checkFrozen();
            String name2 = ((DigestBase)obj).algo.getAlgorithm();
            try {
                this.algo = (MessageDigest)((DigestBase)obj).algo.clone();
            }
            catch (CloneNotSupportedException e) {
                throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + name2 + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject obj) {
            ByteList bytes2 = obj.convertToString().getByteList();
            this.algo.update(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
            return this;
        }

        @JRubyMethod
        public IRubyObject finish() {
            RubyString digest2 = RubyString.newStringNoCopy(this.getRuntime(), this.algo.digest());
            this.algo.reset();
            return digest2;
        }

        @JRubyMethod
        public IRubyObject digest_length() {
            return RubyFixnum.newFixnum(this.getRuntime(), this.algo.getDigestLength());
        }

        @JRubyMethod
        public IRubyObject block_length() {
            if (this.blockLength == 0) {
                throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.blockLength);
        }

        @JRubyMethod
        public IRubyObject reset() {
            this.algo.reset();
            return this;
        }

        private void setAlgorithm(Metadata metadata) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(this.getRuntime(), metadata.getName());
            this.blockLength = metadata.getBlockLength();
        }
    }

    @JRubyClass(name={"Digest::Class"})
    public static class DigestClass
    extends RubyObject {
        protected static final ObjectAllocator DIGEST_CLASS_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                return new DigestClass(runtime2, klass);
            }
        };

        public DigestClass(Ruby runtime2, RubyClass type2) {
            super(runtime2, type2);
        }

        @JRubyMethod(name={"digest"}, required=1, rest=true, meta=true)
        public static IRubyObject s_digest(ThreadContext ctx, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime2 = recv2.getRuntime();
            if (args2.length < 1) {
                throw runtime2.newArgumentError("no data given");
            }
            RubyString str = args2[0].convertToString();
            IRubyObject[] newArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 1, newArgs, 0, args2.length - 1);
            IRubyObject obj = ((RubyClass)recv2).newInstance(ctx, newArgs, Block.NULL_BLOCK);
            return obj.callMethod(ctx, "digest", str);
        }

        @JRubyMethod(name={"hexdigest"}, required=1, optional=1, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext ctx, IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
            Ruby runtime2 = recv2.getRuntime();
            byte[] digest2 = recv2.callMethod(ctx, "digest", args2, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyDigest.toHexString(runtime2, digest2);
        }
    }

    @JRubyModule(name={"Digest::Instance"})
    public static class DigestInstance {
        private static IRubyObject throwUnimplError(IRubyObject self, String name2) {
            throw self.getRuntime().newRuntimeError(String.format("%s does not implement %s()", self.getMetaClass().getRealClass().getName(), name2));
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public static IRubyObject update(ThreadContext ctx, IRubyObject self, IRubyObject arg2) {
            return DigestInstance.throwUnimplError(self, "update");
        }

        @JRubyMethod
        public static IRubyObject finish(ThreadContext ctx, IRubyObject self) {
            return DigestInstance.throwUnimplError(self, "finish");
        }

        @JRubyMethod
        public static IRubyObject reset(ThreadContext ctx, IRubyObject self) {
            return DigestInstance.throwUnimplError(self, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest_length(ThreadContext ctx, IRubyObject self) {
            return DigestInstance.digest(ctx, self, null).convertToString().length();
        }

        @JRubyMethod
        public static IRubyObject block_length(ThreadContext ctx, IRubyObject self) {
            return DigestInstance.throwUnimplError(self, "block_length");
        }

        @JRubyMethod(name={"=="}, required=1)
        public static IRubyObject op_equal(ThreadContext ctx, IRubyObject self, IRubyObject oth) {
            RubyString str2;
            RubyString str1;
            RubyModule instance = (RubyModule)self.getRuntime().fastGetModule("Digest").fastGetConstantAt("Instance");
            if (oth.getMetaClass().getRealClass().hasModuleInHierarchy(instance)) {
                str1 = DigestInstance.digest(ctx, self, null).convertToString();
                str2 = DigestInstance.digest(ctx, oth, null).convertToString();
            } else {
                str1 = DigestInstance.to_s(ctx, self).convertToString();
                str2 = oth.convertToString();
            }
            boolean ret = str1.length().eql(str2.length()) && str1.eql(str2);
            return ret ? self.getRuntime().getTrue() : self.getRuntime().getFalse();
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext ctx, IRubyObject self) {
            return RubyString.newStringNoCopy(self.getRuntime(), ByteList.plain("#<" + self.getMetaClass().getRealClass().getName() + ": " + DigestInstance.hexdigest(ctx, self, null) + ">"));
        }

        @JRubyMethod(name={"new"})
        public static IRubyObject newObject(ThreadContext ctx, IRubyObject self) {
            return self.rbClone().callMethod(ctx, "reset");
        }

        @JRubyMethod(optional=1)
        public static IRubyObject digest(ThreadContext ctx, IRubyObject self, IRubyObject[] args2) {
            IRubyObject value2 = null;
            if (args2 != null && args2.length > 0) {
                self.callMethod(ctx, "reset");
                self.callMethod(ctx, "update", args2[0]);
                value2 = self.callMethod(ctx, "finish");
                self.callMethod(ctx, "reset");
            } else {
                IRubyObject clone = self.rbClone();
                value2 = clone.callMethod(ctx, "finish");
                clone.callMethod(ctx, "reset");
            }
            return value2;
        }

        @JRubyMethod(name={"digest!"})
        public static IRubyObject digest_bang(ThreadContext ctx, IRubyObject self) {
            IRubyObject value2 = self.callMethod(ctx, "finish");
            self.callMethod(ctx, "reset");
            return value2;
        }

        @JRubyMethod(optional=1)
        public static IRubyObject hexdigest(ThreadContext ctx, IRubyObject self, IRubyObject[] args2) {
            return RubyDigest.toHexString(ctx.getRuntime(), DigestInstance.digest(ctx, self, args2).convertToString().getBytes());
        }

        @JRubyMethod(name={"hexdigest!"})
        public static IRubyObject hexdigest_bang(ThreadContext ctx, IRubyObject self) {
            return RubyDigest.toHexString(ctx.getRuntime(), DigestInstance.digest_bang(ctx, self).convertToString().getBytes());
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext ctx, IRubyObject self) {
            return self.callMethod(ctx, "hexdigest");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext ctx, IRubyObject self) {
            return self.callMethod(ctx, "digest_length");
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }

    private static class Metadata {
        private final String name;
        private final int blockLength;

        Metadata(String name2, int blockLength) {
            this.name = name2;
            this.blockLength = blockLength;
        }

        String getName() {
            return this.name;
        }

        int getBlockLength() {
            return this.blockLength;
        }
    }
}

