/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.exceptions.RaiseException;
import org.jruby.util.ByteList;

public final class Util {
    private Util() {
    }

    public static byte[] dumpHeader(String origName, String comment2, int level2, byte osCode, long modifiedTime) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte flags = 0;
        byte extraflags = 0;
        if (origName != null) {
            flags = (byte)(flags | 8);
        }
        if (comment2 != null) {
            flags = (byte)(flags | 0x10);
        }
        if (level2 == 1) {
            extraflags = (byte)(extraflags | 4);
        } else if (level2 == 9) {
            extraflags = (byte)(extraflags | 2);
        }
        byte[] header = new byte[]{31, -117, 8, flags, (byte)modifiedTime, (byte)(modifiedTime >> 8), (byte)(modifiedTime >> 16), (byte)(modifiedTime >> 24), extraflags, 11};
        out.write(header);
        if (origName != null) {
            out.write(origName.toString().getBytes());
            out.write(0);
        }
        if (comment2 != null) {
            out.write(comment2.toString().getBytes());
            out.write(0);
        }
        return out.toByteArray();
    }

    public static byte[] dumpTrailer(int originalDataSize, int checksumInt) {
        return new byte[]{(byte)checksumInt, (byte)(checksumInt >> 8), (byte)(checksumInt >> 16), (byte)(checksumInt >> 24), (byte)originalDataSize, (byte)(originalDataSize >> 8), (byte)(originalDataSize >> 16), (byte)(originalDataSize >> 24)};
    }

    public static GzipHeader readHeader(Ruby runtime2, InputStream in) {
        GzipHeader header = new GzipHeader();
        try {
            if ((byte)Util.readUByte(in) != 31) {
                return null;
            }
            if ((byte)Util.readUByte(in) != -117) {
                return null;
            }
            byte b = (byte)Util.readUByte(in);
            if (b != 8) {
                throw Util.newGzipFileError(runtime2, "unsupported compression method " + b);
            }
            int flags = Util.readUByte(in);
            if ((flags & 2) != 0) {
                throw Util.newGzipFileError(runtime2, "multi-part gzip file is not supported");
            }
            if ((flags & 0x20) != 0) {
                throw Util.newGzipFileError(runtime2, "encrypted gzip file is not supported");
            }
            if ((flags & 0xFFFFFFC0) != 0) {
                throw Util.newGzipFileError(runtime2, "unknown flags " + flags);
            }
            header.mtime = new DateTime(Util.readUInt(in) * 1000L);
            int extraflags = Util.readUByte(in);
            header.level = (extraflags & 4) != 0 ? 1 : ((extraflags & 2) != 0 ? 9 : -1);
            header.osCode = (byte)Util.readUByte(in);
            header.length += 10;
            if ((flags & 4) != 0) {
                int size2 = Util.readUShort(in);
                byte[] extra = new byte[2 + size2];
                Util.readBytes(in, extra);
                header.length += 2 + extra.length;
            }
            if ((flags & 8) != 0) {
                header.origName = Util.readNullTerminateString(in);
                header.length += header.origName.getBytes().length + 1;
            }
            if ((flags & 0x10) != 0) {
                header.comment = Util.readNullTerminateString(in);
                header.length += header.comment.getBytes().length + 1;
            }
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = "not in gzip format";
            }
            throw Util.newGzipFileError(runtime2, msg);
        }
        return header;
    }

    public static void checkTrailer(Ruby runtime2, byte[] trailer, long bytesWritten, long checksum) {
        long uint = Util.bytesToUInt(trailer, 0);
        if (uint != checksum) {
            throw Util.newCRCError(runtime2, "invalid compressed data -- crc error");
        }
        uint = Util.bytesToUInt(trailer, 4);
        if (uint != bytesWritten) {
            throw Util.newLengthError(runtime2, "invalid compressed data -- length error");
        }
    }

    public static void resetBuffer(ByteList l) {
        l.setBegin(0);
        l.setRealSize(0);
        l.invalidate();
    }

    public static RaiseException newZlibError(Ruby runtime2, String message2) {
        return Util.newZlibError(runtime2, "Error", message2);
    }

    public static RaiseException newBufError(Ruby runtime2, String message2) {
        return Util.newZlibError(runtime2, "BufError", message2);
    }

    public static RaiseException newDictError(Ruby runtime2, String message2) {
        return Util.newZlibError(runtime2, "NeedDict", message2);
    }

    public static RaiseException newStreamError(Ruby runtime2, String message2) {
        return Util.newZlibError(runtime2, "StreamError", message2);
    }

    public static RaiseException newDataError(Ruby runtime2, String message2) {
        return Util.newZlibError(runtime2, "DataError", message2);
    }

    private static RaiseException newZlibError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass(klass);
        return new RaiseException(RubyException.newException(runtime2, errorClass, message2), true);
    }

    public static RaiseException newGzipFileError(Ruby runtime2, String message2) {
        return Util.newGzipFileError(runtime2, "Error", message2);
    }

    public static RaiseException newCRCError(Ruby runtime2, String message2) {
        return Util.newGzipFileError(runtime2, "CRCError", message2);
    }

    public static RaiseException newNoFooter(Ruby runtime2, String message2) {
        return Util.newGzipFileError(runtime2, "NoFooter", message2);
    }

    public static RaiseException newLengthError(Ruby runtime2, String message2) {
        return Util.newGzipFileError(runtime2, "LengthError", message2);
    }

    private static RaiseException newGzipFileError(Ruby runtime2, String klass, String message2) {
        RubyClass errorClass = runtime2.getModule("Zlib").getClass("GzipFile").getClass(klass);
        RubyException excn = RubyException.newException(runtime2, errorClass, message2);
        if (runtime2.is1_9()) {
            excn.setInstanceVariable("@input", runtime2.getNil());
        }
        return new RaiseException(excn, true);
    }

    private static int readUByte(InputStream in) throws IOException {
        int ret = in.read();
        if (ret == -1) {
            throw new EOFException();
        }
        return ret & 0xFF;
    }

    private static int readUShort(InputStream in) throws IOException {
        return (Util.readUByte(in) | Util.readUByte(in) << 8) & 0xFFFF;
    }

    private static long readUInt(InputStream in) throws IOException {
        return (long)(Util.readUShort(in) | Util.readUShort(in) << 16) & 0xFFFFFFFFL;
    }

    private static void readBytes(InputStream in, byte[] bytes2) throws IOException {
        Util.readBytes(in, bytes2, 0, bytes2.length);
    }

    private static void readBytes(InputStream in, byte[] bytes2, int pos2, int len) throws IOException {
        if (bytes2.length < pos2 + len) {
            throw new IllegalArgumentException();
        }
        while (len > 0) {
            int ret = in.read(bytes2, pos2, len);
            if (ret == -1) {
                throw new EOFException();
            }
            pos2 += ret;
            len -= ret;
        }
    }

    private static String readNullTerminateString(InputStream in) throws IOException {
        int c;
        StringBuilder builder = new StringBuilder();
        while ((c = Util.readUByte(in)) != 0) {
            builder.append((char)c);
        }
        return builder.toString();
    }

    private static long bytesToUInt(byte[] bytes2, int pos2) {
        if (bytes2.length < pos2 + 4) {
            throw new IllegalArgumentException();
        }
        return (long)(bytes2[pos2++] & 0xFF | (bytes2[pos2++] & 0xFF) << 8 | (bytes2[pos2++] & 0xFF) << 16 | (bytes2[pos2++] & 0xFF) << 24) & 0xFFFFFFFFL;
    }

    public static class GzipHeader {
        public DateTime mtime;
        public int level;
        public byte osCode;
        public String origName;
        public String comment;
        public int length;
    }
}

