/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.interpreter;

import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.scope.SharedBindingDynamicScope;

public class NaiveInterpreterContext
implements InterpreterContext {
    private final Ruby runtime;
    private final ThreadContext context;
    protected Object returnValue;
    protected Object self;
    protected IRubyObject[] parameters;
    protected Object[] temporaryVariables;
    protected Object[] renamedVariables;
    protected Object[] localVariables;
    protected Frame frame;
    protected Block block;
    protected DynamicScope currDynScope = null;
    protected boolean allocatedDynScope = false;
    protected RubyException currException = null;
    private Label methodExitLabel = null;
    private IRubyObject[] NO_PARAMS = new IRubyObject[0];

    public NaiveInterpreterContext(ThreadContext context, IRubyObject self, int localVariablesSize, int temporaryVariablesSize, int renamedVariablesSize, IRubyObject[] parameters2, Block block) {
        context.preMethodFrameOnly(self.getMetaClass(), null, self, block);
        this.frame = context.getCurrentFrame();
        this.context = context;
        this.runtime = context.getRuntime();
        this.self = self;
        this.parameters = parameters2;
        this.localVariables = localVariablesSize > 0 ? new Object[localVariablesSize] : null;
        this.temporaryVariables = temporaryVariablesSize > 0 ? new Object[temporaryVariablesSize] : null;
        this.renamedVariables = renamedVariablesSize > 0 ? new Object[renamedVariablesSize] : null;
        this.block = block;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public Block getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        this.block = block;
    }

    public void setDynamicScope(DynamicScope s2) {
        this.currDynScope = s2;
    }

    public void allocateSharedBindingScope(IRMethod method2) {
        this.allocatedDynScope = true;
        this.currDynScope = new SharedBindingDynamicScope(method2.getStaticScope(), method2);
        this.context.pushScope(this.currDynScope);
    }

    public DynamicScope getSharedBindingScope() {
        return this.currDynScope;
    }

    public boolean hasAllocatedDynamicScope() {
        return this.allocatedDynScope;
    }

    public Object getReturnValue() {
        return this.returnValue == null ? this.context.getRuntime().getNil() : this.returnValue;
    }

    public void setReturnValue(Object returnValue) {
        this.returnValue = returnValue;
    }

    public Object getTemporaryVariable(int offset2) {
        return this.temporaryVariables[offset2];
    }

    public Object setTemporaryVariable(int offset2, Object value2) {
        Object oldValue = this.temporaryVariables[offset2];
        this.temporaryVariables[offset2] = value2;
        return oldValue;
    }

    public void updateRenamedVariablesCount(int n) {
        Object[] oldRenamedVars = this.renamedVariables;
        this.renamedVariables = new Object[n];
        for (int i2 = 0; i2 < oldRenamedVars.length; ++i2) {
            this.renamedVariables[i2] = oldRenamedVars[i2];
        }
    }

    public void updateLocalVariablesCount(int n) {
        Object[] oldLocalVars = this.localVariables;
        this.localVariables = new Object[n];
        for (int i2 = 0; i2 < oldLocalVars.length; ++i2) {
            this.localVariables[i2] = oldLocalVars[i2];
        }
    }

    public Object getRenamedVariable(int offset2) {
        return this.renamedVariables[offset2];
    }

    public Object setRenamedVariable(int offset2, Object value2) {
        Object oldValue = this.renamedVariables[offset2];
        this.renamedVariables[offset2] = value2;
        return oldValue;
    }

    public Object getSharedBindingVariable(int bindingSlot) {
        IRubyObject value2 = this.currDynScope.getValue(bindingSlot, 0);
        if (value2 == null) {
            value2 = this.getRuntime().getNil();
        }
        return value2;
    }

    public void setSharedBindingVariable(int bindingSlot, Object value2) {
        this.currDynScope.setValueDepthZero((IRubyObject)value2, bindingSlot);
    }

    public Object getLocalVariable(int offset2) {
        return this.localVariables[offset2];
    }

    public Object setLocalVariable(int offset2, Object value2) {
        Object oldValue = this.localVariables[offset2];
        this.localVariables[offset2] = value2;
        return oldValue;
    }

    public ThreadContext getContext() {
        return this.context;
    }

    public Object getParameter(int offset2) {
        return this.parameters[offset2];
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public Object getSelf() {
        return this.self;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public IRubyObject[] getParametersFrom(int argIndex) {
        int length2 = this.parameters.length - argIndex;
        if (length2 <= 0) {
            return this.NO_PARAMS;
        }
        IRubyObject[] args2 = new IRubyObject[length2];
        System.arraycopy(this.parameters, argIndex, args2, 0, length2);
        return args2;
    }

    public void setMethodExitLabel(Label l) {
        this.methodExitLabel = l;
    }

    public Label getMethodExitLabel() {
        return this.methodExitLabel;
    }

    public void setException(RubyException e) {
        this.currException = e;
    }

    public RubyException getException() {
        return this.currException;
    }
}

