/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVPropertiesHandler;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.xml.sax.Attributes;

public class DAVGetLockHandler
extends BasicDAVHandler {
    private boolean myIsHandlingToken;
    private String myID;
    private String myComment;
    private String myExpiration;

    public static StringBuffer generateGetLockRequest(StringBuffer body) {
        return DAVPropertiesHandler.generatePropertiesRequest(body, new DAVElement[]{DAVElement.LOCK_DISCOVERY});
    }

    public static StringBuffer generateSetLockRequest(StringBuffer body, String comment) {
        body = body == null ? new StringBuffer() : body;
        body.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        body.append("<lockinfo xmlns=\"DAV:\" >");
        body.append("<lockscope><exclusive/></lockscope>");
        body.append("<locktype><write/></locktype><owner>");
        comment = comment == null ? "" : SVNEncodingUtil.xmlEncodeAttr(comment);
        body.append(comment);
        body.append("</owner></lockinfo>");
        return body;
    }

    public DAVGetLockHandler() {
        this.init();
    }

    public String getComment() {
        return this.myComment;
    }

    public String getExpiration() {
        return this.myExpiration;
    }

    public String getID() {
        return this.myID;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) {
        if (element == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = true;
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) {
        if (element == DAVElement.HREF && this.myIsHandlingToken && cdata != null) {
            this.myID = cdata.toString();
        } else if (element == DAVElement.LOCK_TOKEN) {
            this.myIsHandlingToken = false;
        } else if (element == DAVElement.LOCK_OWNER && cdata != null) {
            this.myComment = cdata.toString();
        } else if (element == DAVElement.LOCK_TIMEOUT && cdata != null) {
            this.myExpiration = cdata.toString();
        }
    }
}

