/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.io.UnsupportedEncodingException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.xml.sax.Attributes;

public class DAVReplayHandler
extends DAVEditorHandler {
    protected static final DAVElement EDITOR_REPORT = DAVElement.getElement("svn:", "editor-report");
    protected static final DAVElement OPEN_ROOT = DAVElement.getElement("svn:", "open-root");
    protected static final DAVElement APPLY_TEXT_DELTA = DAVElement.getElement("svn:", "apply-textdelta");
    protected static final DAVElement CLOSE_FILE = DAVElement.getElement("svn:", "close-file");
    protected static final DAVElement CLOSE_DIRECTORY = DAVElement.getElement("svn:", "close-directory");
    protected static final DAVElement CHANGE_FILE_PROPERTY = DAVElement.getElement("svn:", "change-file-prop");
    protected static final DAVElement CHANGE_DIR_PROPERTY = DAVElement.getElement("svn:", "change-dir-prop");
    protected static final String CHECKSUM_ATTR = "checksum";
    protected static final String DEL_ATTR = "del";

    public DAVReplayHandler(ISVNEditor editor, boolean fetchContent) {
        super(editor, fetchContent);
    }

    protected String getCurrentPath() {
        return null;
    }

    protected ISVNDeltaConsumer getDeltaConsumer() {
        return this.myEditor;
    }

    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == TARGET_REVISION) {
            String rev = attrs.getValue("rev");
            if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in target-revision element");
                SVNErrorManager.error(err);
            } else {
                this.myEditor.targetRevision(Long.parseLong(rev));
            }
        } else if (element == OPEN_ROOT) {
            String rev = attrs.getValue("rev");
            if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing revision attr in open-root element");
                SVNErrorManager.error(err);
            } else {
                this.myEditor.openRoot(Long.parseLong(rev));
                this.myPath = "";
                this.myIsDirectory = true;
            }
        } else if (element == DELETE_ENTRY) {
            String path = attrs.getValue("name");
            String rev = attrs.getValue("rev");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in delete-entry element");
                SVNErrorManager.error(err);
            } else if (rev == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing rev attr in delete-entry element");
                SVNErrorManager.error(err);
            } else {
                this.myEditor.deleteEntry(path, Long.parseLong(rev));
            }
        } else if (element == OPEN_DIRECTORY || element == ADD_DIRECTORY) {
            String path = attrs.getValue("name");
            String rev = attrs.getValue("rev");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == OPEN_DIRECTORY ? "open-directory" : "add-directory") + " element");
                SVNErrorManager.error(err);
            } else {
                long revision;
                long l = revision = rev != null ? Long.parseLong(rev) : -1L;
                if (element == OPEN_DIRECTORY) {
                    this.myEditor.openDir(path, revision);
                } else {
                    String copyFromPath = attrs.getValue("copyfrom-path");
                    String cfRevision = attrs.getValue("copyfrom-rev");
                    long copyFromRevision = cfRevision != null ? Long.parseLong(cfRevision) : -1L;
                    this.myEditor.addDir(path, copyFromPath, copyFromRevision);
                }
            }
            this.myPath = path;
            this.myIsDirectory = true;
        } else if (element == OPEN_FILE || element == ADD_FILE) {
            String path = attrs.getValue("name");
            if (path == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == OPEN_FILE ? "open-file" : "add-file") + " element");
                SVNErrorManager.error(err);
            }
            if (element == ADD_FILE) {
                String copyFromPath = attrs.getValue("copyfrom-path");
                String cfRevision = attrs.getValue("copyfrom-rev");
                long copyFromRevision = cfRevision != null ? Long.parseLong(cfRevision) : -1L;
                this.myEditor.addFile(path, copyFromPath, copyFromRevision);
            } else {
                String rev = attrs.getValue("rev");
                long revision = rev != null ? Long.parseLong(rev) : -1L;
                this.myEditor.openFile(path, revision);
            }
            this.myIsDirectory = false;
            this.myPath = path;
        } else if (element == APPLY_TEXT_DELTA) {
            if (this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got apply-textdelta element without preceding add-file or open-file");
                SVNErrorManager.error(err);
            }
            String checksum = attrs.getValue(CHECKSUM_ATTR);
            try {
                this.myEditor.applyTextDelta(this.myPath, checksum);
                this.setDeltaProcessing(true);
            }
            catch (SVNException svne) {}
        } else if (element == CLOSE_FILE) {
            if (this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-file element without preceding add-file or open-file");
                SVNErrorManager.error(err);
            } else {
                String checksum = attrs.getValue(CHECKSUM_ATTR);
                this.myEditor.closeFile(this.myPath, checksum);
                this.myIsDirectory = true;
            }
        } else if (element == CLOSE_DIRECTORY) {
            if (!this.myIsDirectory) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got close-directory element without ever opening a directory");
                SVNErrorManager.error(err);
            } else {
                this.myEditor.closeDir();
            }
        } else if (element == CHANGE_FILE_PROPERTY || element == CHANGE_DIR_PROPERTY) {
            String name = attrs.getValue("name");
            if (name == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Missing name attr in " + (element == CHANGE_FILE_PROPERTY ? "change-file-prop" : "change-dir-prop") + " element");
                SVNErrorManager.error(err);
            } else if (attrs.getValue(DEL_ATTR) != null) {
                if (element == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, null);
                } else {
                    this.myEditor.changeDirProperty(this.myPropertyName, null);
                }
                this.myPropertyName = null;
            } else {
                this.myPropertyName = name;
            }
        }
    }

    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == APPLY_TEXT_DELTA) {
            this.setDeltaProcessing(false);
        } else if (element == CHANGE_FILE_PROPERTY || element == CHANGE_DIR_PROPERTY) {
            if (cdata != null && !"".equals(cdata) && this.myPropertyName == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA, "Got cdata content for a prop delete");
                SVNErrorManager.error(err);
            }
            if (this.myPropertyName != null) {
                String value = cdata.toString();
                byte[] buffer = this.allocateBuffer(cdata.length());
                int length = SVNBase64.base64ToByteArray(new StringBuffer(cdata.toString().trim()), buffer);
                try {
                    value = new String(buffer, 0, length, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    value = new String(buffer, 0, length);
                }
                if (element == CHANGE_FILE_PROPERTY) {
                    this.myEditor.changeFileProperty(this.myPath, this.myPropertyName, value);
                } else {
                    this.myEditor.changeDirProperty(this.myPropertyName, value);
                }
            }
        }
    }

    public static StringBuffer generateReplayRequest(long highRevision, long lowRevision, boolean sendDeltas) {
        StringBuffer request = new StringBuffer();
        request.append("<S:replay-report xmlns:S=\"svn:\">\n");
        request.append("  <S:revision>");
        request.append(highRevision);
        request.append("</S:revision>\n");
        request.append("  <S:low-water-mark>");
        request.append(lowRevision);
        request.append("</S:low-water-mark>\n");
        request.append("  <S:send-deltas>");
        request.append(sendDeltas ? "1" : "0");
        request.append("</S:send-deltas>\n</S:replay-report>");
        return request;
    }
}

