/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.io.fs.CountingStream;
import org.tmatesoft.svn.core.internal.io.fs.FSEntry;
import org.tmatesoft.svn.core.internal.io.fs.FSErrors;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSID;
import org.tmatesoft.svn.core.internal.io.fs.FSParentPath;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChange;
import org.tmatesoft.svn.core.internal.io.fs.FSPathChangeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSRepresentation;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSWriteLock;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.io.ISVNLockHandler;

public class FSCommitter {
    private FSFS myFSFS;
    private FSTransactionRoot myTxnRoot;
    private FSTransactionInfo myTxn;
    private Collection myLockTokens;
    private String myAuthor;

    public FSCommitter(FSFS fsfs, FSTransactionRoot txnRoot, FSTransactionInfo txn, Collection lockTokens, String author) {
        this.myFSFS = fsfs;
        this.myTxnRoot = txnRoot;
        this.myTxn = txn;
        this.myLockTokens = lockTokens != null ? lockTokens : Collections.EMPTY_LIST;
        this.myAuthor = author;
    }

    public void deleteNode(String path) throws SVNException {
        FSParentPath parentPath = this.myTxnRoot.openPath(path, true, true);
        if (parentPath.getParent() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ROOT_DIR, "The root directory cannot be deleted");
            SVNErrorManager.error(err);
        }
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        this.myTxnRoot.deleteEntry(parentPath.getParent().getRevNode(), parentPath.getNameEntry());
        this.myTxnRoot.removeRevNodeFromCache(parentPath.getAbsPath());
        this.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_DELETE, false, false, -1L, null);
    }

    public void changeNodeProperty(String path, String propName, String propValue) throws SVNException {
        if (!SVNProperty.isRegularProperty(propName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.REPOS_BAD_ARGS, "Storage of non-regular property ''{0}'' is disallowed through the repository interface, and could indicate a bug in your client", propName);
            SVNErrorManager.error(err);
        }
        FSParentPath parentPath = this.myTxnRoot.openPath(path, true, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(parentPath, path);
        Map properties = parentPath.getRevNode().getProperties(this.myFSFS);
        if (properties.isEmpty() && propValue == null) {
            return;
        }
        if (propValue == null) {
            properties.remove(propName);
        } else {
            properties.put(propName, propValue);
        }
        this.myTxnRoot.setProplist(parentPath.getRevNode(), properties);
        this.addChange(path, parentPath.getRevNode().getId(), FSPathChangeKind.FS_PATH_CHANGE_MODIFY, false, true, -1L, null);
    }

    public void makeCopy(FSRevisionRoot fromRoot, String fromPath, String toPath, boolean preserveHistory) throws SVNException {
        String txnId = this.myTxnRoot.getTxnID();
        FSRevisionNode fromNode = fromRoot.getRevisionNode(fromPath);
        FSParentPath toParentPath = this.myTxnRoot.openPath(toPath, false, true);
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, toPath, this.myAuthor, this.myLockTokens, true, false);
        }
        if (toParentPath.getRevNode() != null && toParentPath.getRevNode().getId().equals(fromNode.getId())) {
            return;
        }
        FSPathChangeKind changeKind = toParentPath.getRevNode() != null ? FSPathChangeKind.FS_PATH_CHANGE_REPLACE : FSPathChangeKind.FS_PATH_CHANGE_ADD;
        this.makePathMutable(toParentPath.getParent(), toPath);
        String fromCanonPath = fromPath;
        this.copy(toParentPath.getParent().getRevNode(), toParentPath.getNameEntry(), fromNode, preserveHistory, fromRoot.getRevision(), fromCanonPath, txnId);
        if (changeKind == FSPathChangeKind.FS_PATH_CHANGE_REPLACE) {
            this.myTxnRoot.removeRevNodeFromCache(toParentPath.getAbsPath());
        }
        FSRevisionNode newNode = this.myTxnRoot.getRevisionNode(toPath);
        this.addChange(toPath, newNode.getId(), changeKind, false, false, fromRoot.getRevision(), fromCanonPath);
    }

    public void makeFile(String path) throws SVNException {
        SVNPathUtil.checkPathIsValid(path);
        String txnId = this.myTxnRoot.getTxnID();
        FSParentPath parentPath = this.myTxnRoot.openPath(path, false, true);
        if (parentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(this.myTxnRoot, path, this.myFSFS));
        }
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, false, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        FSRevisionNode childNode = this.makeEntry(parentPath.getParent().getRevNode(), parentPath.getParent().getAbsPath(), parentPath.getNameEntry(), false, txnId);
        this.myTxnRoot.putRevNodeToCache(parentPath.getAbsPath(), childNode);
        this.addChange(path, childNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, false, false, -1L, null);
    }

    public void makeDir(String path) throws SVNException {
        SVNPathUtil.checkPathIsValid(path);
        String txnId = this.myTxnRoot.getTxnID();
        FSParentPath parentPath = this.myTxnRoot.openPath(path, false, true);
        if (parentPath.getRevNode() != null) {
            SVNErrorManager.error(FSErrors.errorAlreadyExists(this.myTxnRoot, path, this.myFSFS));
        }
        if ((this.myTxnRoot.getTxnFlags() & 2) != 0) {
            FSCommitter.allowLockedOperation(this.myFSFS, path, this.myAuthor, this.myLockTokens, true, false);
        }
        this.makePathMutable(parentPath.getParent(), path);
        FSRevisionNode subDirNode = this.makeEntry(parentPath.getParent().getRevNode(), parentPath.getParent().getAbsPath(), parentPath.getNameEntry(), true, txnId);
        this.myTxnRoot.putRevNodeToCache(parentPath.getAbsPath(), subDirNode);
        this.addChange(path, subDirNode.getId(), FSPathChangeKind.FS_PATH_CHANGE_ADD, false, false, -1L, null);
    }

    public FSRevisionNode makeEntry(FSRevisionNode parent, String parentPath, String entryName, boolean isDir, String txnId) throws SVNException {
        SVNErrorMessage err;
        if (!SVNPathUtil.isSinglePathComponent(entryName)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_SINGLE_PATH_COMPONENT, "Attempted to create a node with an illegal name ''{0}''", entryName);
            SVNErrorManager.error(err);
        }
        if (parent.getType() != SVNNodeKind.DIR) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_DIRECTORY, "Attempted to create entry in non-directory parent");
            SVNErrorManager.error(err);
        }
        if (!parent.getId().isTxn()) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Attempted to clone child of non-mutable node");
            SVNErrorManager.error(err);
        }
        FSRevisionNode newRevNode = new FSRevisionNode();
        newRevNode.setType(isDir ? SVNNodeKind.DIR : SVNNodeKind.FILE);
        newRevNode.setCreatedPath(SVNPathUtil.concatToAbs(parentPath, entryName));
        newRevNode.setCopyRootPath(parent.getCopyRootPath());
        newRevNode.setCopyRootRevision(parent.getCopyRootRevision());
        newRevNode.setCopyFromRevision(-1L);
        newRevNode.setCopyFromPath(null);
        FSID newNodeId = this.createNode(newRevNode, parent.getId().getCopyID(), txnId);
        FSRevisionNode childNode = this.myFSFS.getRevisionNode(newNodeId);
        this.myTxnRoot.setEntry(parent, entryName, childNode.getId(), newRevNode.getType());
        return childNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChange(String path, FSID id, FSPathChangeKind changeKind, boolean textModified, boolean propsModified, long copyFromRevision, String copyFromPath) throws SVNException {
        OutputStream changesFile = null;
        try {
            changesFile = SVNFileUtil.openFileForWriting(this.myTxnRoot.getTransactionChangesFile(), true);
            FSPathChange pathChange = new FSPathChange(path, id, changeKind, textModified, propsModified, copyFromPath, copyFromRevision);
            this.myTxnRoot.writeChangeEntry(changesFile, pathChange);
        }
        catch (IOException ioe) {
            try {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
                SVNErrorManager.error(err, ioe);
            }
            catch (Throwable throwable) {
                SVNFileUtil.closeFile(changesFile);
                throw throwable;
            }
            SVNFileUtil.closeFile(changesFile);
        }
        SVNFileUtil.closeFile(changesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long commitTxn() throws SVNException {
        FSWriteLock writeLock;
        long newRevision = -1L;
        while (true) {
            long youngishRev = this.myFSFS.getYoungestRevision();
            FSRevisionRoot youngishRoot = this.myFSFS.createRevisionRoot(youngishRev);
            FSRevisionNode youngishRootNode = youngishRoot.getRevisionNode("/");
            this.mergeChanges(null, youngishRootNode);
            this.myTxn.setBaseRevision(youngishRev);
            FSWriteLock fSWriteLock = writeLock = FSWriteLock.getWriteLock(this.myFSFS);
            // MONITORENTER : fSWriteLock
            try {
                writeLock.lock();
                newRevision = this.commit();
                return newRevision;
            }
            catch (SVNException svne) {
                long youngestRev;
                if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.FS_TXN_OUT_OF_DATE) throw svne;
                if (youngishRev != (youngestRev = this.myFSFS.getYoungestRevision())) continue;
                throw svne;
            }
            break;
        }
        finally {
            writeLock.unlock();
            FSWriteLock.realease(writeLock);
        }
    }

    public void makePathMutable(FSParentPath parentPath, String errorPath) throws SVNException {
        String txnId = this.myTxnRoot.getTxnID();
        if (parentPath.getRevNode().getId().isTxn()) {
            return;
        }
        FSRevisionNode clone = null;
        if (parentPath.getParent() != null) {
            this.makePathMutable(parentPath.getParent(), errorPath);
            FSID parentId = null;
            String copyId = null;
            switch (parentPath.getCopyStyle()) {
                case 2: {
                    parentId = parentPath.getParent().getRevNode().getId();
                    copyId = parentId.getCopyID();
                    break;
                }
                case 3: {
                    copyId = this.reserveCopyId(txnId);
                    break;
                }
                case 1: {
                    copyId = null;
                    break;
                }
                default: {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: can not make path ''{0}'' mutable", errorPath);
                    SVNErrorManager.error(err);
                }
            }
            String copyRootPath = parentPath.getRevNode().getCopyRootPath();
            long copyRootRevision = parentPath.getRevNode().getCopyRootRevision();
            FSRevisionRoot copyrootRoot = this.myFSFS.createRevisionRoot(copyRootRevision);
            FSRevisionNode copyRootNode = copyrootRoot.getRevisionNode(copyRootPath);
            FSID childId = parentPath.getRevNode().getId();
            FSID copyRootId = copyRootNode.getId();
            boolean isParentCopyRoot = false;
            if (!childId.getNodeID().equals(copyRootId.getNodeID())) {
                isParentCopyRoot = true;
            }
            String clonePath = parentPath.getParent().getAbsPath();
            clone = this.myTxnRoot.cloneChild(parentPath.getParent().getRevNode(), clonePath, parentPath.getNameEntry(), copyId, isParentCopyRoot);
            this.myTxnRoot.putRevNodeToCache(parentPath.getAbsPath(), clone);
        } else {
            FSTransactionInfo txn = this.myTxnRoot.getTxn();
            if (txn.getRootID().equals(txn.getBaseID())) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: txn ''{0}'' root id ''{1}'' matches base id ''{2}''", new Object[]{txnId, txn.getRootID(), txn.getBaseID()});
                SVNErrorManager.error(err);
            }
            clone = this.myFSFS.getRevisionNode(txn.getRootID());
        }
        parentPath.setRevNode(clone);
    }

    public String reserveCopyId(String txnId) throws SVNException {
        String[] nextIds = this.myTxnRoot.readNextIDs();
        String copyId = FSTransactionRoot.generateNextKey(nextIds[1]);
        this.myFSFS.writeNextIDs(txnId, nextIds[0], copyId);
        return "_" + nextIds[1];
    }

    private void copy(FSRevisionNode toNode, String entryName, FSRevisionNode fromNode, boolean preserveHistory, long fromRevision, String fromPath, String txnId) throws SVNException {
        FSID id = null;
        if (preserveHistory) {
            FSID srcId = fromNode.getId();
            FSRevisionNode toRevNode = FSRevisionNode.dumpRevisionNode(fromNode);
            String copyId = this.reserveCopyId(txnId);
            toRevNode.setPredecessorId(srcId);
            if (toRevNode.getCount() != -1L) {
                toRevNode.setCount(toRevNode.getCount() + 1L);
            }
            toRevNode.setCreatedPath(SVNPathUtil.concatToAbs(toNode.getCreatedPath(), entryName));
            toRevNode.setCopyFromPath(fromPath);
            toRevNode.setCopyFromRevision(fromRevision);
            toRevNode.setCopyRootPath(null);
            id = this.myTxnRoot.createSuccessor(srcId, toRevNode, copyId);
        } else {
            id = fromNode.getId();
        }
        this.myTxnRoot.setEntry(toNode, entryName, id, fromNode.getType());
    }

    private FSID createNode(FSRevisionNode revNode, String copyId, String txnId) throws SVNException {
        String nodeId = this.getNewTxnNodeId();
        FSID id = FSID.createTxnId(nodeId, copyId, txnId);
        revNode.setId(id);
        this.myFSFS.putTxnRevisionNode(id, revNode);
        return id;
    }

    private String getNewTxnNodeId() throws SVNException {
        String[] curIds = this.myTxnRoot.readNextIDs();
        String curNodeId = curIds[0];
        String curCopyId = curIds[1];
        String nextNodeId = FSTransactionRoot.generateNextKey(curNodeId);
        this.myFSFS.writeNextIDs(this.myTxnRoot.getTxnID(), nextNodeId, curCopyId);
        return "_" + curNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long commit() throws SVNException {
        long oldRev = this.myFSFS.getYoungestRevision();
        if (this.myTxn.getBaseRevision() != oldRev) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_TXN_OUT_OF_DATE, "Transaction out of date");
            SVNErrorManager.error(err);
        }
        this.verifyLocks();
        String[] ids = this.myFSFS.getNextRevisionIDs();
        String startNodeId = ids[0];
        String startCopyId = ids[1];
        long newRevision = oldRev + 1L;
        OutputStream protoFileOS = null;
        FSID newRootId = null;
        File revisionPrototypeFile = this.myTxnRoot.getTransactionRevFile();
        long offset = revisionPrototypeFile.length();
        try {
            protoFileOS = SVNFileUtil.openFileForWriting(revisionPrototypeFile, true);
            FSID rootId = FSID.createTxnId("0", "0", this.myTxn.getTxnId());
            CountingStream revWriter = new CountingStream(protoFileOS, offset);
            newRootId = this.myTxnRoot.writeFinalRevision(newRootId, revWriter, newRevision, rootId, startNodeId, startCopyId);
            long changedPathOffset = this.myTxnRoot.writeFinalChangedPathInfo(revWriter);
            String offsetsLine = "\n" + newRootId.getOffset() + " " + changedPathOffset + "\n";
            protoFileOS.write(offsetsLine.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
        finally {
            SVNFileUtil.closeFile(protoFileOS);
        }
        Map txnProps = this.myFSFS.getTransactionProperties(this.myTxn.getTxnId());
        if (txnProps != null && !txnProps.isEmpty()) {
            if (txnProps.get("svn:check-ood") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-ood", null);
            }
            if (txnProps.get("svn:check-locks") != null) {
                this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:check-locks", null);
            }
        }
        File dstRevFile = this.myFSFS.getNewRevisionFile(newRevision);
        SVNFileUtil.rename(revisionPrototypeFile, dstRevFile);
        String commitTime = SVNTimeUtil.formatDate(new Date(System.currentTimeMillis()));
        this.myFSFS.setTransactionProperty(this.myTxn.getTxnId(), "svn:date", commitTime);
        File txnPropsFile = this.myFSFS.getTransactionPropertiesFile(this.myTxn.getTxnId());
        File dstRevPropsFile = this.myFSFS.getNewRevisionPropertiesFile(newRevision);
        SVNFileUtil.rename(txnPropsFile, dstRevPropsFile);
        try {
            this.myTxnRoot.writeFinalCurrentFile(newRevision, startNodeId, startCopyId);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe);
        }
        FSCommitter.purgeTxn(this.myFSFS, this.myTxn.getTxnId());
        return newRevision;
    }

    private void mergeChanges(FSRevisionNode ancestorNode, FSRevisionNode sourceNode) throws SVNException {
        String txnId = this.myTxn.getTxnId();
        FSRevisionNode txnRootNode = this.myTxnRoot.getRootRevisionNode();
        if (ancestorNode == null) {
            ancestorNode = this.myTxnRoot.getTxnBaseRootNode();
        }
        if (txnRootNode.getId().equals(ancestorNode.getId())) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "FATAL error: no changes in transaction to commit");
            SVNErrorManager.error(err);
        } else {
            this.merge("/", txnRootNode, sourceNode, ancestorNode, txnId);
        }
    }

    private void merge(String targetPath, FSRevisionNode target, FSRevisionNode source, FSRevisionNode ancestor, String txnId) throws SVNException {
        FSID sourceId = source.getId();
        FSID targetId = target.getId();
        FSID ancestorId = ancestor.getId();
        if (ancestorId.equals(targetId)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_GENERAL, "Bad merge; target ''{0}'' has id ''{1}'', same as ancestor", new Object[]{targetPath, targetId});
            SVNErrorManager.error(err);
        }
        if (ancestorId.equals(sourceId) || sourceId.equals(targetId)) {
            return;
        }
        if (source.getType() != SVNNodeKind.DIR || target.getType() != SVNNodeKind.DIR || ancestor.getType() != SVNNodeKind.DIR) {
            SVNErrorManager.error(FSErrors.errorConflict(targetPath));
        }
        if (!FSRepresentation.compareRepresentations(target.getPropsRepresentation(), ancestor.getPropsRepresentation())) {
            SVNErrorManager.error(FSErrors.errorConflict(targetPath));
        }
        Map sourceEntries = source.getDirEntries(this.myFSFS);
        Map targetEntries = target.getDirEntries(this.myFSFS);
        Map ancestorEntries = ancestor.getDirEntries(this.myFSFS);
        HashSet<String> removedEntries = new HashSet<String>();
        for (String ancestorEntryName : ancestorEntries.keySet()) {
            FSEntry ancestorEntry = (FSEntry)ancestorEntries.get(ancestorEntryName);
            FSEntry sourceEntry = removedEntries.contains(ancestorEntryName) ? null : (FSEntry)sourceEntries.get(ancestorEntryName);
            FSEntry targetEntry = (FSEntry)targetEntries.get(ancestorEntryName);
            if (sourceEntry == null || !ancestorEntry.getId().equals(sourceEntry.getId())) {
                if (targetEntry != null && ancestorEntry.getId().equals(targetEntry.getId())) {
                    if (sourceEntry != null) {
                        this.myTxnRoot.setEntry(target, ancestorEntryName, sourceEntry.getId(), sourceEntry.getType());
                    } else {
                        this.myTxnRoot.deleteEntry(target, ancestorEntryName);
                    }
                } else {
                    if (sourceEntry == null || targetEntry == null) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.concatToAbs(targetPath, ancestorEntryName)));
                    }
                    if (sourceEntry.getType() == SVNNodeKind.FILE || targetEntry.getType() == SVNNodeKind.FILE || ancestorEntry.getType() == SVNNodeKind.FILE) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.concatToAbs(targetPath, ancestorEntryName)));
                    }
                    if (!(sourceEntry.getId().getNodeID().equals(ancestorEntry.getId().getNodeID()) && sourceEntry.getId().getCopyID().equals(ancestorEntry.getId().getCopyID()) && targetEntry.getId().getNodeID().equals(ancestorEntry.getId().getNodeID()) && targetEntry.getId().getCopyID().equals(ancestorEntry.getId().getCopyID()))) {
                        SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.concatToAbs(targetPath, ancestorEntryName)));
                    }
                    FSRevisionNode sourceEntryNode = this.myFSFS.getRevisionNode(sourceEntry.getId());
                    FSRevisionNode targetEntryNode = this.myFSFS.getRevisionNode(targetEntry.getId());
                    FSRevisionNode ancestorEntryNode = this.myFSFS.getRevisionNode(ancestorEntry.getId());
                    String childTargetPath = SVNPathUtil.concatToAbs(targetPath, targetEntry.getName());
                    this.merge(childTargetPath, targetEntryNode, sourceEntryNode, ancestorEntryNode, txnId);
                }
            }
            removedEntries.add(ancestorEntryName);
        }
        for (String sourceEntryName : sourceEntries.keySet()) {
            FSEntry sourceEntry = (FSEntry)sourceEntries.get(sourceEntryName);
            FSEntry targetEntry = (FSEntry)targetEntries.get(sourceEntryName);
            if (targetEntry != null) {
                SVNErrorManager.error(FSErrors.errorConflict(SVNPathUtil.concatToAbs(targetPath, targetEntry.getName())));
            }
            this.myTxnRoot.setEntry(target, sourceEntry.getName(), sourceEntry.getId(), sourceEntry.getType());
        }
        long sourceCount = source.getCount();
        this.updateAncestry(sourceId, targetId, targetPath, sourceCount);
    }

    private void updateAncestry(FSID sourceId, FSID targetId, String targetPath, long sourcePredecessorCount) throws SVNException {
        if (!targetId.isTxn()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_MUTABLE, "Unexpected immutable node at ''{0}''", targetPath);
            SVNErrorManager.error(err);
        }
        FSRevisionNode revNode = this.myFSFS.getRevisionNode(targetId);
        revNode.setPredecessorId(sourceId);
        revNode.setCount(sourcePredecessorCount != -1L ? sourcePredecessorCount + 1L : sourcePredecessorCount);
        this.myFSFS.putTxnRevisionNode(targetId, revNode);
    }

    private void verifyLocks() throws SVNException {
        Map changes = this.myTxnRoot.getChangedPaths();
        Object[] changedPaths = changes.keySet().toArray();
        Arrays.sort(changedPaths);
        String lastRecursedPath = null;
        for (int i = 0; i < changedPaths.length; ++i) {
            String changedPath = (String)changedPaths[i];
            boolean recurse = true;
            if (lastRecursedPath != null && SVNPathUtil.pathIsChild(lastRecursedPath, changedPath) != null) continue;
            FSPathChange change = (FSPathChange)changes.get(changedPath);
            if (change.getChangeKind() == FSPathChangeKind.FS_PATH_CHANGE_MODIFY) {
                recurse = false;
            }
            FSCommitter.allowLockedOperation(this.myFSFS, changedPath, this.myAuthor, this.myLockTokens, recurse, true);
            if (!recurse) continue;
            lastRecursedPath = changedPath;
        }
    }

    public static void allowLockedOperation(FSFS fsfs, String path, final String username, final Collection lockTokens, boolean recursive, boolean haveWriteLock) throws SVNException {
        if (recursive) {
            ISVNLockHandler handler = new ISVNLockHandler(){
                private String myUsername;
                private Collection myTokens;
                {
                    this.myUsername = username;
                    this.myTokens = lockTokens;
                }

                public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                    FSCommitter.verifyLock(lock, this.myTokens, this.myUsername);
                }

                public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
                }
            };
            fsfs.walkDigestFiles(fsfs.getDigestFileFromRepositoryPath(path), handler, haveWriteLock);
        } else {
            SVNLock lock = fsfs.getLockHelper(path, haveWriteLock);
            if (lock != null) {
                FSCommitter.verifyLock(lock, lockTokens, username);
            }
        }
    }

    private static void verifyLock(SVNLock lock, Collection lockTokens, String username) throws SVNException {
        SVNErrorMessage err;
        if (username == null || "".equals(username)) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_NO_USER, "Cannot verify lock on path ''{0}''; no username available", lock.getPath());
            SVNErrorManager.error(err);
        } else if (username.compareTo(lock.getOwner()) != 0) {
            err = SVNErrorMessage.create(SVNErrorCode.FS_LOCK_OWNER_MISMATCH, "User {0} does not own lock on path ''{1}'' (currently locked by {2})", new Object[]{username, lock.getPath(), lock.getOwner()});
            SVNErrorManager.error(err);
        }
        for (String token : lockTokens) {
            if (!token.equals(lock.getID())) continue;
            return;
        }
        err = SVNErrorMessage.create(SVNErrorCode.FS_BAD_LOCK_TOKEN, "Cannot verify lock on path ''{0}''; no matching lock-token available", lock.getPath());
        SVNErrorManager.error(err);
    }

    public static void abortTransaction(FSFS fsfs, String txnId) throws SVNException {
        File txnDir = fsfs.getTransactionDir(txnId);
        SVNFileUtil.deleteAll(txnDir, true);
        if (txnDir.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Transaction cleanup failed");
            SVNErrorManager.error(err);
        }
    }

    public static void purgeTxn(FSFS fsfs, String txnId) {
        SVNFileUtil.deleteAll(fsfs.getTransactionDir(txnId), true);
    }
}

