/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import ch.ethz.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;

public abstract class SVNAbstractTunnelConnector
implements ISVNConnector {
    private OutputStream myOutputStream;
    private InputStream myInputStream;
    private Process myProcess;

    public void open(SVNRepositoryImpl repository, String process) throws SVNException {
        try {
            this.myProcess = Runtime.getRuntime().exec(process);
            this.myInputStream = repository.getDebugLog().createLogStream(this.myProcess.getInputStream());
            this.myOutputStream = repository.getDebugLog().createLogStream(this.myProcess.getOutputStream());
            new StreamGobbler(this.myProcess.getErrorStream());
        }
        catch (IOException e) {
            try {
                this.close(repository);
            }
            catch (SVNException inner) {
                // empty catch block
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.EXTERNAL_PROGRAM, "Cannot create tunnel: ''{0}''", e.getMessage());
            SVNErrorManager.error(err, e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.myInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.myOutputStream;
    }

    public boolean isConnected(SVNRepositoryImpl repos) throws SVNException {
        return this.myInputStream != null;
    }

    public void close(SVNRepositoryImpl repository) throws SVNException {
        if (this.myProcess != null) {
            if (this.myInputStream != null) {
                repository.getDebugLog().flushStream(this.myInputStream);
                SVNFileUtil.closeFile(this.myInputStream);
            }
            if (this.myOutputStream != null) {
                repository.getDebugLog().flushStream(this.myOutputStream);
                SVNFileUtil.closeFile(this.myOutputStream);
            }
            this.myProcess.destroy();
            this.myInputStream = null;
            this.myOutputStream = null;
            this.myProcess = null;
        }
    }

    public void free() {
    }

    public boolean occupy() {
        return true;
    }
}

