/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import org.tmatesoft.svn.core.internal.util.SVNBase64;
import org.tmatesoft.svn.core.internal.wc.SVNPasswordCipher;

public class SVNWinCryptPasswordCipher
extends SVNPasswordCipher {
    private static boolean ourIsLibraryLoaded;

    public static boolean isEnabled() {
        return ourIsLibraryLoaded;
    }

    public String decrypt(String encryptedData) {
        if (encryptedData == null) {
            return null;
        }
        byte[] buffer = new byte[encryptedData.length()];
        int decodedBytes = SVNBase64.base64ToByteArray(new StringBuffer(encryptedData), buffer);
        byte[] decodedBuffer = new byte[decodedBytes];
        System.arraycopy(buffer, 0, decodedBuffer, 0, decodedBytes);
        return this.decryptData(decodedBuffer);
    }

    public String encrypt(String rawData) {
        if (rawData == null) {
            return null;
        }
        byte[] encryptedBytes = this.encryptData(rawData);
        if (encryptedBytes != null) {
            return SVNBase64.byteArrayToBase64(encryptedBytes);
        }
        return null;
    }

    private native byte[] encryptData(String var1);

    private native String decryptData(byte[] var1);

    public String getCipherType() {
        return "wincrypt";
    }

    static {
        try {
            System.loadLibrary("jsvncrypt");
            ourIsLibraryLoaded = true;
        }
        catch (Throwable th) {
            ourIsLibraryLoaded = false;
        }
    }
}

