/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;

public class SVNAdminAreaInfo {
    private String myTargetName;
    private SVNAdminArea myTarget;
    private SVNAdminArea myAnchor;
    private SVNWCAccess myAccess;
    private Map myExternals;

    protected SVNAdminAreaInfo(SVNWCAccess access, SVNAdminArea anchor, SVNAdminArea target, String targetName) {
        this.myAccess = access;
        this.myAnchor = anchor;
        this.myTarget = target;
        this.myTargetName = targetName;
    }

    public SVNAdminArea getAnchor() {
        return this.myAnchor;
    }

    public SVNAdminArea getTarget() {
        return this.myTarget;
    }

    public String getTargetName() {
        return this.myTargetName;
    }

    public SVNWCAccess getWCAccess() {
        return this.myAccess;
    }

    public SVNExternalInfo[] addExternals(SVNAdminArea adminArea, String externals) {
        SVNExternalInfo info;
        if (externals == null) {
            return null;
        }
        ArrayList<SVNExternalInfo> result = new ArrayList<SVNExternalInfo>();
        String relPath = adminArea.getRelativePath(this.myAnchor);
        SVNExternalInfo[] parsed = SVNAdminAreaInfo.parseExternals(relPath, externals);
        for (int i = 0; i < parsed.length; ++i) {
            info = this.addExternal(adminArea, parsed[i].getPath(), parsed[i].getOldURL(), parsed[i].getOldRevision());
            result.add(info);
        }
        Iterator exts = this.externals();
        while (exts.hasNext()) {
            info = (SVNExternalInfo)exts.next();
            if (result.contains(info) || !relPath.equals(info.getOwnerPath())) continue;
            info.setNewExternal(null, -1L);
        }
        return result.toArray(new SVNExternalInfo[result.size()]);
    }

    public static SVNExternalInfo[] parseExternals(String rootPath, String externals) {
        ArrayList<SVNExternalInfo> result = new ArrayList<SVNExternalInfo>();
        if (externals == null) {
            return result.toArray(new SVNExternalInfo[result.size()]);
        }
        StringTokenizer lines = new StringTokenizer(externals, "\n\r");
        while (lines.hasMoreTokens()) {
            String revStr;
            String line = lines.nextToken().trim();
            if (line.length() == 0 || line.startsWith("#")) continue;
            String url = null;
            long rev = -1L;
            ArrayList<String> parts = new ArrayList<String>(4);
            StringTokenizer tokens = new StringTokenizer(line, " \t");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken().trim();
                parts.add(token);
            }
            if (parts.size() < 2) continue;
            String path = SVNPathUtil.append(rootPath, (String)parts.get(0));
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (parts.size() == 2) {
                url = (String)parts.get(1);
            } else if (parts.size() == 3 && parts.get(1).toString().startsWith("-r")) {
                revStr = parts.get(1).toString();
                if (!"HEAD".equals(revStr = revStr.substring("-r".length()))) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(2);
            } else if (parts.size() == 4 && "-r".equals(parts.get(1))) {
                revStr = parts.get(2).toString();
                if (!"HEAD".equals(revStr)) {
                    try {
                        rev = Long.parseLong(revStr);
                    }
                    catch (NumberFormatException nfe) {
                        continue;
                    }
                }
                url = (String)parts.get(3);
            }
            if (path == null || url == null) continue;
            if ("".equals(rootPath) && ((String)parts.get(0)).startsWith("/")) {
                path = "/" + path;
            }
            try {
                url = SVNURL.parseURIEncoded(url).toString();
            }
            catch (SVNException e) {
                continue;
            }
            try {
                SVNExternalInfo info = new SVNExternalInfo("", null, path, SVNURL.parseURIEncoded(url), rev);
                result.add(info);
            }
            catch (SVNException e) {}
        }
        return result.toArray(new SVNExternalInfo[result.size()]);
    }

    private SVNExternalInfo addExternal(SVNAdminArea adminArea, String path, SVNURL url, long revision) {
        SVNExternalInfo info;
        if (this.myExternals == null) {
            this.myExternals = new TreeMap();
        }
        if ((info = (SVNExternalInfo)this.myExternals.get(path)) == null) {
            info = new SVNExternalInfo(adminArea.getRelativePath(this.myAnchor), new File(this.getAnchor().getRoot(), path), path, null, -1L);
            this.myExternals.put(path, info);
        }
        info.setNewExternal(url, revision);
        return info;
    }

    public Iterator externals() {
        if (this.myExternals == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.myExternals.values().iterator();
    }
}

