/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Date;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNInfo {
    private File myFile;
    private String myPath;
    private SVNURL myURL;
    private SVNRevision myRevision;
    private SVNNodeKind myKind;
    private SVNURL myRepositoryRootURL;
    private String myRepositoryUUID;
    private SVNRevision myCommittedRevision;
    private Date myCommittedDate;
    private String myAuthor;
    private SVNLock myLock;
    private boolean myIsRemote;
    private String mySchedule;
    private SVNURL myCopyFromURL;
    private SVNRevision myCopyFromRevision;
    private Date myTextTime;
    private Date myPropTime;
    private String myChecksum;
    private File myConflictOldFile;
    private File myConflictNewFile;
    private File myConflictWrkFile;
    private File myPropConflictFile;

    static SVNInfo createInfo(File file, SVNEntry entry) throws SVNException {
        if (entry == null) {
            return null;
        }
        SVNLock lock = null;
        if (entry.getLockToken() != null) {
            lock = new SVNLock(null, entry.getLockToken(), entry.getLockOwner(), entry.getLockComment(), SVNTimeUtil.parseDate(entry.getLockCreationDate()), null);
        }
        return new SVNInfo(file, entry.getSVNURL(), entry.getRepositoryRootURL(), entry.getRevision(), entry.getKind(), entry.getUUID(), entry.getCommittedRevision(), entry.getCommittedDate(), entry.getAuthor(), entry.getSchedule(), entry.getCopyFromSVNURL(), entry.getCopyFromRevision(), entry.getTextTime(), entry.getPropTime(), entry.getChecksum(), entry.getConflictOld(), entry.getConflictNew(), entry.getConflictWorking(), entry.getPropRejectFile(), lock);
    }

    static SVNInfo createInfo(String path, SVNURL reposRootURL, String uuid, SVNURL url, SVNRevision revision, SVNDirEntry dirEntry, SVNLock lock) {
        if (dirEntry == null) {
            return null;
        }
        return new SVNInfo(path, url, revision, dirEntry.getKind(), uuid, reposRootURL, dirEntry.getRevision(), dirEntry.getDate(), dirEntry.getAuthor(), lock);
    }

    protected SVNInfo(File file, SVNURL url, SVNURL rootURL, long revision, SVNNodeKind kind, String uuid, long committedRevision, String committedDate, String author, String schedule, SVNURL copyFromURL, long copyFromRevision, String textTime, String propTime, String checksum, String conflictOld, String conflictNew, String conflictWorking, String propRejectFile, SVNLock lock) {
        this.myFile = file;
        this.myURL = url;
        this.myRevision = SVNRevision.create(revision);
        this.myKind = kind;
        this.myRepositoryUUID = uuid;
        this.myRepositoryRootURL = rootURL;
        this.myCommittedRevision = SVNRevision.create(committedRevision);
        this.myCommittedDate = committedDate != null ? SVNTimeUtil.parseDate(committedDate) : null;
        this.myAuthor = author;
        this.mySchedule = schedule;
        this.myChecksum = checksum;
        this.myTextTime = textTime != null ? SVNTimeUtil.parseDate(textTime) : null;
        this.myPropTime = propTime != null ? SVNTimeUtil.parseDate(propTime) : null;
        this.myCopyFromURL = copyFromURL;
        this.myCopyFromRevision = SVNRevision.create(copyFromRevision);
        this.myLock = lock;
        if (file != null) {
            if (conflictOld != null) {
                this.myConflictOldFile = new File(file.getParentFile(), conflictOld);
            }
            if (conflictNew != null) {
                this.myConflictNewFile = new File(file.getParentFile(), conflictNew);
            }
            if (conflictWorking != null) {
                this.myConflictWrkFile = new File(file.getParentFile(), conflictWorking);
            }
            if (propRejectFile != null) {
                this.myPropConflictFile = new File(file.getParentFile(), propRejectFile);
            }
        }
        this.myIsRemote = false;
    }

    protected SVNInfo(String path, SVNURL url, SVNRevision revision, SVNNodeKind kind, String uuid, SVNURL reposRootURL, long comittedRevision, Date date, String author, SVNLock lock) {
        this.myIsRemote = true;
        this.myURL = url;
        this.myRevision = revision;
        this.myKind = kind;
        this.myRepositoryRootURL = reposRootURL;
        this.myRepositoryUUID = uuid;
        this.myCommittedDate = date;
        this.myCommittedRevision = SVNRevision.create(comittedRevision);
        this.myAuthor = author;
        this.myLock = lock;
        this.myPath = path;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getChecksum() {
        return this.myChecksum;
    }

    public Date getCommittedDate() {
        return this.myCommittedDate;
    }

    public SVNRevision getCommittedRevision() {
        return this.myCommittedRevision;
    }

    public File getConflictNewFile() {
        return this.myConflictNewFile;
    }

    public File getConflictOldFile() {
        return this.myConflictOldFile;
    }

    public File getConflictWrkFile() {
        return this.myConflictWrkFile;
    }

    public SVNRevision getCopyFromRevision() {
        return this.myCopyFromRevision;
    }

    public SVNURL getCopyFromURL() {
        return this.myCopyFromURL;
    }

    public File getFile() {
        return this.myFile;
    }

    public boolean isRemote() {
        return this.myIsRemote;
    }

    public SVNNodeKind getKind() {
        return this.myKind;
    }

    public SVNLock getLock() {
        return this.myLock;
    }

    public String getPath() {
        return this.myPath;
    }

    public File getPropConflictFile() {
        return this.myPropConflictFile;
    }

    public Date getPropTime() {
        return this.myPropTime;
    }

    public SVNURL getRepositoryRootURL() {
        return this.myRepositoryRootURL;
    }

    public String getRepositoryUUID() {
        return this.myRepositoryUUID;
    }

    public SVNRevision getRevision() {
        return this.myRevision;
    }

    public String getSchedule() {
        return this.mySchedule;
    }

    public Date getTextTime() {
        return this.myTextTime;
    }

    public SVNURL getURL() {
        return this.myURL;
    }
}

