/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.maven;

import com.sun.wts.tools.maven.CommitMediator;
import com.sun.wts.tools.maven.SVNConsoleAuthenticationProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.ISVNProxyManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionWagon
extends AbstractWagon {
    private SVNRepository queryRepo;
    private SVNRepository commitRepo;
    private String rootPath;
    private ISVNEditor editor;
    private final Set<String> pathAdded = new HashSet<String>();

    public void openConnection() throws ConnectionException, AuthenticationException {
        try {
            this.doOpenConnection();
        }
        catch (SVNException e) {
            throw new ConnectionException("Unable to connect to " + this.getSubversionURL(), (Throwable)e);
        }
    }

    protected void doOpenConnection() throws SVNException {
        String url = this.getSubversionURL();
        SVNURL repoUrl = SVNURL.parseURIDecoded((String)url);
        this.queryRepo = SVNRepositoryFactory.create((SVNURL)repoUrl);
        this.configureAuthenticationManager(this.queryRepo);
        this.rootPath = repoUrl.getPath().substring(this.queryRepo.getRepositoryRoot(true).getPath().length());
        if (this.rootPath.startsWith("/")) {
            this.rootPath = this.rootPath.substring(1);
        }
        SVNURL repoRoot = this.queryRepo.getRepositoryRoot(true);
        this.queryRepo.setLocation(repoRoot, false);
        this.commitRepo = SVNRepositoryFactory.create((SVNURL)repoRoot);
        this.configureAuthenticationManager(this.commitRepo);
        ISVNEditor editor = this.commitRepo.getCommitEditor("Upload by wagon-svn", (ISVNWorkspaceMediator)new CommitMediator());
        editor.openRoot(-1L);
        this.editor = editor;
    }

    protected String getSubversionURL() {
        Repository r = this.getRepository();
        String url = r.getUrl();
        url = url.substring(4);
        return url;
    }

    private void configureAuthenticationManager(SVNRepository repo) {
        DefaultSVNAuthenticationManager manager = new DefaultSVNAuthenticationManager(SVNWCUtil.getDefaultConfigurationDirectory(), true, null, null, null, null){

            public ISVNProxyManager getProxyManager(SVNURL url) throws SVNException {
                ISVNProxyManager pm = super.getProxyManager(url);
                if (pm != null) {
                    return pm;
                }
                return SubversionWagon.this.getProxyManager(url);
            }
        };
        manager.setAuthenticationProvider(this.createAuthenticationProvider());
        repo.setAuthenticationManager((ISVNAuthenticationManager)manager);
    }

    protected ISVNProxyManager getProxyManager(SVNURL url) {
        return null;
    }

    protected ISVNAuthenticationProvider createAuthenticationProvider() {
        return new SVNConsoleAuthenticationProvider(this.isInteractive(), this.getAuthenticationInfo());
    }

    protected void closeConnection() throws ConnectionException {
        try {
            if (this.editor != null) {
                try {
                    this.editor.closeDir();
                    this.editor.closeEdit();
                }
                catch (EmptyStackException e) {
                    e.printStackTrace();
                }
                this.editor = null;
            }
            if (this.queryRepo != null) {
                this.queryRepo.closeSession();
            }
            this.queryRepo = null;
            if (this.commitRepo != null) {
                this.commitRepo.closeSession();
            }
            this.commitRepo = null;
        }
        catch (SVNException e) {
            throw new ConnectionException("Failed to close svn connection", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource res = new Resource(resourceName);
        try {
            this.fireGetInitiated(res, destination);
            this.fireGetStarted(res, destination);
            HashMap m = new HashMap();
            FileOutputStream fos = new FileOutputStream(destination);
            try {
                this.queryRepo.getFile(this.combine(this.rootPath, resourceName), -1L, m, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            this.postProcessListeners(res, destination, 5);
            this.fireGetCompleted(res, destination);
        }
        catch (SVNException e) {
            throw new ResourceDoesNotExistException("Unable to find " + resourceName + " in " + this.getRepository().getUrl(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Unable to find " + resourceName + " in " + this.getRepository().getUrl(), (Throwable)e);
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            SVNDirEntry e = this.queryRepo.info(this.combine(this.rootPath, resourceName), -1L);
            if (e.getDate().getTime() < timestamp) {
                return false;
            }
            this.get(resourceName, destination);
            return true;
        }
        catch (SVNException e) {
            throw new ResourceDoesNotExistException("Unable to find " + resourceName + " in " + this.getRepository().getUrl(), (Throwable)e);
        }
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        destination = this.combine(this.rootPath, destination);
        Resource res = new Resource(destination);
        this.firePutInitiated(res, source);
        this.firePutStarted(res, source);
        try {
            this.put(source, "/", this.editor, destination);
            this.postProcessListeners(res, source, 6);
            this.firePutCompleted(res, source);
        }
        catch (SVNException e) {
            throw new TransferFailedException("Failed to write to " + destination, (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to write to " + destination, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(File source, String path, ISVNEditor editor, String destination) throws SVNException, IOException {
        this.pathAdded.add(this.normalize(path));
        int idx = destination.indexOf(47);
        if (idx > 0) {
            String head = destination.substring(0, idx);
            String tail = destination.substring(idx + 1);
            String child = this.combine(path, head);
            if (this.exists(child) || this.pathAdded.contains(this.normalize(child))) {
                try {
                    editor.openDir(child, -1L);
                }
                catch (SVNException e) {
                    editor.addDir(child, null, -1L);
                }
            } else {
                editor.addDir(child, null, -1L);
            }
            this.put(source, child, editor, tail);
            editor.closeDir();
        } else {
            String filePath = this.combine(path, destination);
            if (this.exists(filePath) || this.pathAdded.contains(this.normalize(filePath))) {
                editor.openFile(filePath, -1L);
            } else {
                editor.addFile(filePath, null, -1L);
            }
            editor.applyTextDelta(filePath, null);
            SVNDeltaGenerator dg = new SVNDeltaGenerator();
            FileInputStream fin = new FileInputStream(source);
            String checksum = null;
            try {
                checksum = dg.sendDelta(filePath, (InputStream)fin, (ISVNDeltaConsumer)editor, true);
            }
            finally {
                fin.close();
            }
            editor.closeFile(filePath, checksum);
        }
    }

    private boolean exists(String child) throws SVNException {
        try {
            return this.queryRepo.info(child, -1L) != null;
        }
        catch (SVNException e) {
            return false;
        }
    }

    public boolean supportsDirectoryCopy() {
        return true;
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            List files = FileUtils.getFileNames((File)sourceDirectory, (String)"**/**", (String)"", (boolean)false);
            for (String file : files) {
                this.put(new File(sourceDirectory, file), this.combine(destinationDirectory, file));
            }
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to list up files in " + sourceDirectory, (Throwable)e);
        }
    }

    private String combine(String head, String tail) {
        if (head.length() == 0) {
            return tail;
        }
        if (head.endsWith("/")) {
            head = head.substring(0, head.length() - 1);
        }
        if (tail.startsWith("/")) {
            tail = tail.substring(1);
        }
        return head + '/' + tail;
    }

    private String normalize(String str) {
        int idx;
        while ((idx = str.indexOf("//")) >= 0) {
            str = str.substring(0, idx) + str.substring(idx + 1);
        }
        return str;
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }
}

