/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.operation.BaseFindAndModifyOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.session.SessionContext;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class FindAndDeleteOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final MongoNamespace namespace;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private Collation collation;

    @Deprecated
    public FindAndDeleteOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this(namespace, WriteConcern.ACKNOWLEDGED, false, decoder);
    }

    @Deprecated
    public FindAndDeleteOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder) {
        this(namespace, writeConcern, false, decoder);
    }

    public FindAndDeleteOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndDeleteOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndDeleteOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndDeleteOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndDeleteOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindAndDeleteOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    protected String getDatabaseName() {
        return this.namespace.getDatabaseName();
    }

    @Override
    protected CommandOperationHelper.CommandCreator getCommandCreator(final SessionContext sessionContext) {
        return new CommandOperationHelper.CommandCreator(){

            @Override
            public BsonDocument create(ServerDescription serverDescription, ConnectionDescription connectionDescription) {
                OperationHelper.validateCollation(connectionDescription, FindAndDeleteOperation.this.collation);
                BsonDocument commandDocument = new BsonDocument("findandmodify", (BsonValue)new BsonString(FindAndDeleteOperation.this.namespace.getCollectionName()));
                DocumentHelper.putIfNotNull(commandDocument, "query", (BsonValue)FindAndDeleteOperation.this.getFilter());
                DocumentHelper.putIfNotNull(commandDocument, "fields", (BsonValue)FindAndDeleteOperation.this.getProjection());
                DocumentHelper.putIfNotNull(commandDocument, "sort", (BsonValue)FindAndDeleteOperation.this.getSort());
                DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", FindAndDeleteOperation.this.getMaxTime(TimeUnit.MILLISECONDS));
                commandDocument.put("remove", (BsonValue)BsonBoolean.TRUE);
                if (FindAndDeleteOperation.this.writeConcern.isAcknowledged() && !FindAndDeleteOperation.this.writeConcern.isServerDefault() && OperationHelper.serverIsAtLeastVersionThreeDotTwo(connectionDescription)) {
                    commandDocument.put("writeConcern", (BsonValue)FindAndDeleteOperation.this.writeConcern.asDocument());
                }
                if (FindAndDeleteOperation.this.collation != null) {
                    commandDocument.put("collation", (BsonValue)FindAndDeleteOperation.this.collation.asDocument());
                }
                if (OperationHelper.isRetryableWrite(FindAndDeleteOperation.this.retryWrites, FindAndDeleteOperation.this.writeConcern, serverDescription, connectionDescription)) {
                    commandDocument.put("txnNumber", (BsonValue)new BsonInt64(sessionContext.advanceTransactionNumber()));
                }
                return commandDocument;
            }
        };
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new NoOpFieldNameValidator();
    }
}

