/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

abstract class AbstractByteBufBsonDocument
extends BsonDocument {
    private static final long serialVersionUID = 1L;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});

    AbstractByteBufBsonDocument() {
    }

    public void clear() {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonValue put(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonDocument append(String key, BsonValue value) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public void putAll(Map<? extends String, ? extends BsonValue> m) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public BsonValue remove(Object key) {
        throw new UnsupportedOperationException("ByteBufBsonDocument instances are immutable");
    }

    public boolean isEmpty() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                return false;
            }

            @Override
            public Boolean notFound() {
                return true;
            }
        }));
    }

    public int size() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<Integer>(){
            private int size;

            @Override
            @Nullable
            public Integer find(BsonReader bsonReader) {
                ++this.size;
                bsonReader.readName();
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Integer notFound() {
                return this.size;
            }
        }));
    }

    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.toBaseBsonDocument().entrySet();
    }

    public Collection<BsonValue> values() {
        return this.toBaseBsonDocument().values();
    }

    public Set<String> keySet() {
        return this.toBaseBsonDocument().keySet();
    }

    public boolean containsKey(final Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        Boolean containsKey = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return true;
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsKey != null ? containsKey : false;
    }

    public boolean containsValue(final Object value) {
        Boolean containsValue = this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                bsonReader.skipName();
                if (AbstractByteBufBsonDocument.this.deserializeBsonValue(bsonReader).equals(value)) {
                    return true;
                }
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
        return containsValue != null ? containsValue : false;
    }

    @Nullable
    public BsonValue get(final Object key) {
        Assertions.notNull("key", key);
        return this.findInDocument(new Finder<BsonValue>(){

            @Override
            public BsonValue find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return AbstractByteBufBsonDocument.this.deserializeBsonValue(bsonReader);
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            @Nullable
            public BsonValue notFound() {
                return null;
            }
        });
    }

    public String getFirstKey() {
        return Assertions.assertNotNull(this.findInDocument(new Finder<String>(){

            @Override
            public String find(BsonReader bsonReader) {
                return bsonReader.readName();
            }

            @Override
            public String notFound() {
                throw new NoSuchElementException();
            }
        }));
    }

    @Nullable
    abstract <T> T findInDocument(Finder<T> var1);

    abstract BsonDocument toBaseBsonDocument();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.toBaseBsonDocument().equals(o);
    }

    public int hashCode() {
        return this.toBaseBsonDocument().hashCode();
    }

    private BsonValue deserializeBsonValue(BsonReader bsonReader) {
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType((BsonType)bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    Object writeReplace() {
        return this.toBaseBsonDocument();
    }

    static interface Finder<T> {
        @Nullable
        public T find(BsonReader var1);

        @Nullable
        public T notFound();
    }
}

