/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.LoggerSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoSocketClosedException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoSocketWriteException;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerId;
import com.mongodb.connection.ServerType;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.ByteBufferBsonOutput;
import com.mongodb.internal.connection.CommandEventSender;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.CommandMessage;
import com.mongodb.internal.connection.CompressedHeader;
import com.mongodb.internal.connection.CompressedMessage;
import com.mongodb.internal.connection.Compressor;
import com.mongodb.internal.connection.ConnectionGenerationSupplier;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.InternalConnectionInitializationDescription;
import com.mongodb.internal.connection.InternalConnectionInitializer;
import com.mongodb.internal.connection.LoggingCommandEventSender;
import com.mongodb.internal.connection.MessageHeader;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.NoOpCommandEventSender;
import com.mongodb.internal.connection.OpCode;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.connection.ReplyHeader;
import com.mongodb.internal.connection.ReplyMessage;
import com.mongodb.internal.connection.ResponseBuffers;
import com.mongodb.internal.connection.SnappyCompressor;
import com.mongodb.internal.connection.ZlibCompressor;
import com.mongodb.internal.connection.ZstdCompressor;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.logging.StructuredLogMessage;
import com.mongodb.internal.logging.StructuredLogger;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.ByteBuf;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;

@NotThreadSafe
public class InternalStreamConnection
implements InternalConnection {
    private static final Set<String> SECURITY_SENSITIVE_COMMANDS = new HashSet<String>(Arrays.asList("authenticate", "saslStart", "saslContinue", "getnonce", "createUser", "updateUser", "copydbgetnonce", "copydbsaslstart", "copydb"));
    private static final Set<String> SECURITY_SENSITIVE_HELLO_COMMANDS = new HashSet<String>(Arrays.asList("hello", "isMaster", CommandHelper.LEGACY_HELLO_LOWER));
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ClusterConnectionMode clusterConnectionMode;
    private final boolean isMonitoringConnection;
    private final ServerId serverId;
    private final ConnectionGenerationSupplier connectionGenerationSupplier;
    private final StreamFactory streamFactory;
    private final InternalConnectionInitializer connectionInitializer;
    private volatile ConnectionDescription description;
    private volatile ServerDescription initialServerDescription;
    private volatile Stream stream;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicBoolean opened = new AtomicBoolean();
    private final List<MongoCompressor> compressorList;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    @Nullable
    private volatile Compressor sendCompressor;
    private final Map<Byte, Compressor> compressorMap;
    private volatile boolean hasMoreToCome;
    private volatile int responseTo;
    private int generation = -1;
    private static final StructuredLogger COMMAND_PROTOCOL_LOGGER = new StructuredLogger("protocol.command");

    static Set<String> getSecuritySensitiveCommands() {
        return Collections.unmodifiableSet(SECURITY_SENSITIVE_COMMANDS);
    }

    static Set<String> getSecuritySensitiveHelloCommands() {
        return Collections.unmodifiableSet(SECURITY_SENSITIVE_HELLO_COMMANDS);
    }

    public InternalStreamConnection(ClusterConnectionMode clusterConnectionMode, ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier, StreamFactory streamFactory, List<MongoCompressor> compressorList, CommandListener commandListener, InternalConnectionInitializer connectionInitializer) {
        this(clusterConnectionMode, false, serverId, connectionGenerationSupplier, streamFactory, compressorList, LoggerSettings.builder().build(), commandListener, connectionInitializer);
    }

    public InternalStreamConnection(ClusterConnectionMode clusterConnectionMode, boolean isMonitoringConnection, ServerId serverId, ConnectionGenerationSupplier connectionGenerationSupplier, StreamFactory streamFactory, List<MongoCompressor> compressorList, LoggerSettings loggerSettings, CommandListener commandListener, InternalConnectionInitializer connectionInitializer) {
        this.clusterConnectionMode = clusterConnectionMode;
        this.isMonitoringConnection = isMonitoringConnection;
        this.serverId = Assertions.notNull("serverId", serverId);
        this.connectionGenerationSupplier = Assertions.notNull("connectionGeneration", connectionGenerationSupplier);
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.compressorList = Assertions.notNull("compressorList", compressorList);
        this.compressorMap = this.createCompressorMap(compressorList);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.connectionInitializer = Assertions.notNull("connectionInitializer", connectionInitializer);
        this.description = new ConnectionDescription(serverId);
        this.initialServerDescription = ServerDescription.builder().address(serverId.getAddress()).type(ServerType.UNKNOWN).state(ServerConnectionState.CONNECTING).build();
        if (clusterConnectionMode != ClusterConnectionMode.LOAD_BALANCED) {
            this.generation = connectionGenerationSupplier.getGeneration();
        }
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.description;
    }

    @Override
    public ServerDescription getInitialServerDescription() {
        return this.initialServerDescription;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void open() {
        Assertions.isTrue("Open already called", this.stream == null);
        this.stream = this.streamFactory.create(this.serverId.getAddress());
        try {
            this.stream.open();
            InternalConnectionInitializationDescription initializationDescription = this.connectionInitializer.startHandshake(this);
            this.initAfterHandshakeStart(initializationDescription);
            initializationDescription = this.connectionInitializer.finishHandshake(this, initializationDescription);
            this.initAfterHandshakeFinish(initializationDescription);
        }
        catch (Throwable t) {
            this.close();
            if (t instanceof MongoException) {
                throw (MongoException)t;
            }
            throw new MongoException(t.toString(), t);
        }
    }

    @Override
    public void openAsync(final SingleResultCallback<Void> callback) {
        Assertions.isTrue("Open already called", this.stream == null, callback);
        try {
            this.stream = this.streamFactory.create(this.serverId.getAddress());
            this.stream.openAsync(new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(@Nullable Void aVoid) {
                    InternalStreamConnection.this.connectionInitializer.startHandshakeAsync(InternalStreamConnection.this, (initialResult, initialException) -> {
                        if (initialException != null) {
                            InternalStreamConnection.this.close();
                            callback.onResult(null, initialException);
                        } else {
                            Assertions.assertNotNull(initialResult);
                            InternalStreamConnection.this.initAfterHandshakeStart(initialResult);
                            InternalStreamConnection.this.connectionInitializer.finishHandshakeAsync(InternalStreamConnection.this, (InternalConnectionInitializationDescription)initialResult, (completedResult, completedException) -> {
                                if (completedException != null) {
                                    InternalStreamConnection.this.close();
                                    callback.onResult(null, completedException);
                                } else {
                                    Assertions.assertNotNull(completedResult);
                                    InternalStreamConnection.this.initAfterHandshakeFinish(completedResult);
                                    callback.onResult(null, null);
                                }
                            });
                        }
                    });
                }

                @Override
                public void failed(Throwable t) {
                    InternalStreamConnection.this.close();
                    callback.onResult(null, t);
                }
            });
        }
        catch (Throwable t) {
            this.close();
            callback.onResult(null, t);
        }
    }

    private void initAfterHandshakeStart(InternalConnectionInitializationDescription initializationDescription) {
        this.description = initializationDescription.getConnectionDescription();
        this.initialServerDescription = initializationDescription.getServerDescription();
        if (this.clusterConnectionMode == ClusterConnectionMode.LOAD_BALANCED) {
            this.generation = this.connectionGenerationSupplier.getGeneration(Assertions.assertNotNull(this.description.getServiceId()));
        }
    }

    private void initAfterHandshakeFinish(InternalConnectionInitializationDescription initializationDescription) {
        this.description = initializationDescription.getConnectionDescription();
        this.initialServerDescription = initializationDescription.getServerDescription();
        this.opened.set(true);
        this.sendCompressor = this.findSendCompressor(this.description);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Opened connection [%s] to %s", this.getId(), this.serverId.getAddress()));
        }
    }

    private Map<Byte, Compressor> createCompressorMap(List<MongoCompressor> compressorList) {
        HashMap<Byte, Compressor> compressorMap = new HashMap<Byte, Compressor>(this.compressorList.size());
        for (MongoCompressor mongoCompressor : compressorList) {
            Compressor compressor = this.createCompressor(mongoCompressor);
            compressorMap.put(compressor.getId(), compressor);
        }
        return compressorMap;
    }

    @Nullable
    private Compressor findSendCompressor(ConnectionDescription description) {
        if (description.getCompressors().isEmpty()) {
            return null;
        }
        String firstCompressorName = description.getCompressors().get(0);
        for (Compressor compressor : this.compressorMap.values()) {
            if (!compressor.getName().equals(firstCompressorName)) continue;
            return compressor;
        }
        throw new MongoInternalException("Unexpected compressor negotiated: " + firstCompressorName);
    }

    private Compressor createCompressor(MongoCompressor mongoCompressor) {
        if (mongoCompressor.getName().equals("zlib")) {
            return new ZlibCompressor(mongoCompressor);
        }
        if (mongoCompressor.getName().equals("snappy")) {
            return new SnappyCompressor();
        }
        if (mongoCompressor.getName().equals("zstd")) {
            return new ZstdCompressor();
        }
        throw new MongoClientException("Unsupported compressor " + mongoCompressor.getName());
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Closing connection %s", this.getId()));
            }
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    @Override
    public boolean opened() {
        return this.opened.get();
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    @Nullable
    public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, RequestContext requestContext) {
        CommandEventSender commandEventSender;
        try (ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this);){
            message.encode((BsonOutput)bsonOutput, sessionContext);
            commandEventSender = this.createCommandEventSender(message, bsonOutput, requestContext);
            commandEventSender.sendStartedEvent();
            try {
                this.sendCommandMessage(message, bsonOutput, sessionContext);
            }
            catch (Exception e) {
                commandEventSender.sendFailedEvent(e);
                throw e;
            }
        }
        if (message.isResponseExpected()) {
            return this.receiveCommandMessageResponse(decoder, commandEventSender, sessionContext, 0);
        }
        commandEventSender.sendSucceededEventForOneWayCommand();
        return null;
    }

    @Override
    public <T> void send(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext) {
        try (ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this);){
            message.encode((BsonOutput)bsonOutput, sessionContext);
            this.sendCommandMessage(message, bsonOutput, sessionContext);
            if (message.isResponseExpected()) {
                this.hasMoreToCome = true;
            }
        }
    }

    @Override
    public <T> T receive(Decoder<T> decoder, SessionContext sessionContext) {
        Assertions.isTrue("Response is expected", this.hasMoreToCome);
        return this.receiveCommandMessageResponse(decoder, new NoOpCommandEventSender(), sessionContext, 0);
    }

    @Override
    public boolean supportsAdditionalTimeout() {
        return this.stream.supportsAdditionalTimeout();
    }

    @Override
    public <T> T receive(Decoder<T> decoder, SessionContext sessionContext, int additionalTimeout) {
        Assertions.isTrue("Response is expected", this.hasMoreToCome);
        return this.receiveCommandMessageResponse(decoder, new NoOpCommandEventSender(), sessionContext, additionalTimeout);
    }

    @Override
    public boolean hasMoreToCome() {
        return this.hasMoreToCome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommandMessage(CommandMessage message, ByteBufferBsonOutput bsonOutput, SessionContext sessionContext) {
        ByteBufferBsonOutput compressedBsonOutput;
        Compressor localSendCompressor = this.sendCompressor;
        if (localSendCompressor == null || SECURITY_SENSITIVE_COMMANDS.contains(message.getCommandDocument(bsonOutput).getFirstKey())) {
            try {
                this.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            }
            finally {
                bsonOutput.close();
            }
        }
        List<ByteBuf> byteBuffers = bsonOutput.getByteBuffers();
        try {
            CompressedMessage compressedMessage = new CompressedMessage(message.getOpCode(), byteBuffers, localSendCompressor, ProtocolHelper.getMessageSettings(this.description));
            compressedBsonOutput = new ByteBufferBsonOutput(this);
            compressedMessage.encode((BsonOutput)compressedBsonOutput, sessionContext);
        }
        finally {
            this.releaseAllBuffers(byteBuffers);
            bsonOutput.close();
        }
        try {
            this.sendMessage(compressedBsonOutput.getByteBuffers(), message.getId());
        }
        finally {
            compressedBsonOutput.close();
        }
        this.responseTo = message.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T receiveCommandMessageResponse(Decoder<T> decoder, CommandEventSender commandEventSender, SessionContext sessionContext, int additionalTimeout) {
        boolean commandSuccessful = false;
        try (ResponseBuffers responseBuffers = this.receiveMessageWithAdditionalTimeout(additionalTimeout);){
            this.updateSessionContext(sessionContext, responseBuffers);
            if (!ProtocolHelper.isCommandOk(responseBuffers)) {
                throw ProtocolHelper.getCommandFailureException(responseBuffers.getResponseDocument(this.responseTo, new BsonDocumentCodec()), this.description.getServerAddress());
            }
            commandSuccessful = true;
            commandEventSender.sendSucceededEvent(responseBuffers);
            T commandResult = this.getCommandResult(decoder, responseBuffers, this.responseTo);
            this.hasMoreToCome = responseBuffers.getReplyHeader().hasMoreToCome();
            this.responseTo = this.hasMoreToCome ? responseBuffers.getReplyHeader().getRequestId() : 0;
            T t = commandResult;
            return t;
        }
        catch (Exception e) {
            if (commandSuccessful) throw e;
            commandEventSender.sendFailedEvent(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, RequestContext requestContext, SingleResultCallback<T> callback) {
        block7: {
            Assertions.notNull("stream is open", this.stream, callback);
            if (this.isClosed()) {
                callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
                return;
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this);
            ByteBufferBsonOutput compressedBsonOutput = new ByteBufferBsonOutput(this);
            try {
                message.encode((BsonOutput)bsonOutput, sessionContext);
                CommandEventSender commandEventSender = this.createCommandEventSender(message, bsonOutput, requestContext);
                commandEventSender.sendStartedEvent();
                Compressor localSendCompressor = this.sendCompressor;
                if (localSendCompressor == null || SECURITY_SENSITIVE_COMMANDS.contains(message.getCommandDocument(bsonOutput).getFirstKey())) {
                    this.sendCommandMessageAsync(message.getId(), decoder, sessionContext, callback, bsonOutput, commandEventSender, message.isResponseExpected());
                    break block7;
                }
                List<ByteBuf> byteBuffers = bsonOutput.getByteBuffers();
                try {
                    CompressedMessage compressedMessage = new CompressedMessage(message.getOpCode(), byteBuffers, localSendCompressor, ProtocolHelper.getMessageSettings(this.description));
                    compressedMessage.encode((BsonOutput)compressedBsonOutput, sessionContext);
                }
                finally {
                    this.releaseAllBuffers(byteBuffers);
                    bsonOutput.close();
                }
                this.sendCommandMessageAsync(message.getId(), decoder, sessionContext, callback, compressedBsonOutput, commandEventSender, message.isResponseExpected());
            }
            catch (Throwable t) {
                bsonOutput.close();
                compressedBsonOutput.close();
                callback.onResult(null, t);
            }
        }
    }

    private void releaseAllBuffers(List<ByteBuf> byteBuffers) {
        for (ByteBuf cur : byteBuffers) {
            cur.release();
        }
    }

    private <T> void sendCommandMessageAsync(int messageId, Decoder<T> decoder, SessionContext sessionContext, SingleResultCallback<T> callback, ByteBufferBsonOutput bsonOutput, CommandEventSender commandEventSender, boolean responseExpected) {
        this.sendMessageAsync(bsonOutput.getByteBuffers(), messageId, (result, t) -> {
            bsonOutput.close();
            if (t != null) {
                commandEventSender.sendFailedEvent(t);
                callback.onResult(null, t);
            } else if (!responseExpected) {
                commandEventSender.sendSucceededEventForOneWayCommand();
                callback.onResult(null, null);
            } else {
                this.readAsync(16, new MessageHeaderCallback((responseBuffers, t1) -> {
                    if (t1 != null) {
                        commandEventSender.sendFailedEvent(t1);
                        callback.onResult(null, t1);
                        return;
                    }
                    Assertions.assertNotNull(responseBuffers);
                    try {
                        this.updateSessionContext(sessionContext, (ResponseBuffers)responseBuffers);
                        boolean commandOk = ProtocolHelper.isCommandOk((BsonReader)new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())));
                        responseBuffers.reset();
                        if (!commandOk) {
                            MongoException commandFailureException = ProtocolHelper.getCommandFailureException(responseBuffers.getResponseDocument(messageId, new BsonDocumentCodec()), this.description.getServerAddress());
                            commandEventSender.sendFailedEvent(commandFailureException);
                            throw commandFailureException;
                        }
                        commandEventSender.sendSucceededEvent((ResponseBuffers)responseBuffers);
                        Object result1 = this.getCommandResult(decoder, (ResponseBuffers)responseBuffers, messageId);
                        callback.onResult(result1, null);
                    }
                    catch (Throwable localThrowable) {
                        callback.onResult(null, localThrowable);
                    }
                    finally {
                        responseBuffers.close();
                    }
                }));
            }
        });
    }

    private <T> T getCommandResult(Decoder<T> decoder, ResponseBuffers responseBuffers, int messageId) {
        T result = new ReplyMessage<T>(responseBuffers, decoder, messageId).getDocuments().get(0);
        MongoException writeConcernBasedError = ProtocolHelper.createSpecialWriteConcernException(responseBuffers, this.description.getServerAddress());
        if (writeConcernBasedError != null) {
            throw new MongoWriteConcernWithResponseException(writeConcernBasedError, result);
        }
        return result;
    }

    @Override
    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
        Assertions.notNull("stream is open", this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot write to a closed stream", this.getServerAddress());
        }
        try {
            this.stream.write(byteBuffers);
        }
        catch (Exception e) {
            this.close();
            throw this.translateWriteException(e);
        }
    }

    @Override
    public ResponseBuffers receiveMessage(int responseTo) {
        Assertions.notNull("stream is open", this.stream);
        if (this.isClosed()) {
            throw new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress());
        }
        return this.receiveMessageWithAdditionalTimeout(0);
    }

    private ResponseBuffers receiveMessageWithAdditionalTimeout(int additionalTimeout) {
        try {
            return this.receiveResponseBuffers(additionalTimeout);
        }
        catch (Throwable t) {
            this.close();
            throw this.translateReadException(t);
        }
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, SingleResultCallback<Void> callback) {
        Assertions.notNull("stream is open", this.stream, callback);
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        this.writeAsync(byteBuffers, ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER));
    }

    private void writeAsync(List<ByteBuf> byteBuffers, final SingleResultCallback<Void> callback) {
        try {
            this.stream.writeAsync(byteBuffers, new AsyncCompletionHandler<Void>(){

                @Override
                public void completed(@Nullable Void v) {
                    callback.onResult(null, null);
                }

                @Override
                public void failed(Throwable t) {
                    InternalStreamConnection.this.close();
                    callback.onResult(null, InternalStreamConnection.this.translateWriteException(t));
                }
            });
        }
        catch (Throwable t) {
            this.close();
            callback.onResult(null, t);
        }
    }

    @Override
    public void receiveMessageAsync(int responseTo, SingleResultCallback<ResponseBuffers> callback) {
        Assertions.isTrue("stream is open", this.stream != null, callback);
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Can not read from a closed socket", this.getServerAddress()));
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("Start receiving response on %s", this.getId()));
        }
        this.readAsync(16, new MessageHeaderCallback((result, t) -> {
            if (t != null) {
                this.close();
                callback.onResult(null, t);
            } else {
                callback.onResult((ResponseBuffers)result, null);
            }
        }));
    }

    private void readAsync(int numBytes, final SingleResultCallback<ByteBuf> callback) {
        if (this.isClosed()) {
            callback.onResult(null, new MongoSocketClosedException("Cannot read from a closed stream", this.getServerAddress()));
            return;
        }
        try {
            this.stream.readAsync(numBytes, new AsyncCompletionHandler<ByteBuf>(){

                @Override
                public void completed(@Nullable ByteBuf buffer) {
                    callback.onResult(buffer, null);
                }

                @Override
                public void failed(Throwable t) {
                    InternalStreamConnection.this.close();
                    callback.onResult(null, InternalStreamConnection.this.translateReadException(t));
                }
            });
        }
        catch (Exception e) {
            this.close();
            callback.onResult(null, this.translateReadException(e));
        }
    }

    private ConnectionId getId() {
        return this.description.getConnectionId();
    }

    private ServerAddress getServerAddress() {
        return this.description.getServerAddress();
    }

    private void updateSessionContext(SessionContext sessionContext, ResponseBuffers responseBuffers) {
        BsonDocument recoveryToken;
        sessionContext.advanceOperationTime(ProtocolHelper.getOperationTime(responseBuffers));
        sessionContext.advanceClusterTime(ProtocolHelper.getClusterTime(responseBuffers));
        sessionContext.setSnapshotTimestamp(ProtocolHelper.getSnapshotTimestamp(responseBuffers));
        if (sessionContext.hasActiveTransaction() && (recoveryToken = ProtocolHelper.getRecoveryToken(responseBuffers)) != null) {
            sessionContext.setRecoveryToken(recoveryToken);
        }
    }

    private MongoException translateWriteException(Throwable e) {
        if (e instanceof MongoException) {
            return (MongoException)e;
        }
        if (e instanceof IOException) {
            return new MongoSocketWriteException("Exception sending message", this.getServerAddress(), e);
        }
        if (e instanceof InterruptedException) {
            return new MongoInternalException("Thread interrupted exception", e);
        }
        return new MongoInternalException("Unexpected exception", e);
    }

    private MongoException translateReadException(Throwable e) {
        if (e instanceof MongoException) {
            return (MongoException)e;
        }
        if (e instanceof SocketTimeoutException) {
            return new MongoSocketReadTimeoutException("Timeout while receiving message", this.getServerAddress(), e);
        }
        if (e instanceof InterruptedIOException) {
            return new MongoInterruptedException("Interrupted while receiving message", (InterruptedIOException)e);
        }
        if (e instanceof ClosedByInterruptException) {
            return new MongoInterruptedException("Interrupted while receiving message", (ClosedByInterruptException)e);
        }
        if (e instanceof IOException) {
            return new MongoSocketReadException("Exception receiving message", this.getServerAddress(), e);
        }
        if (e instanceof RuntimeException) {
            return new MongoInternalException("Unexpected runtime exception", e);
        }
        if (e instanceof InterruptedException) {
            return new MongoInternalException("Interrupted exception", e);
        }
        return new MongoInternalException("Unexpected exception", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseBuffers receiveResponseBuffers(int additionalTimeout) throws IOException {
        MessageHeader messageHeader;
        ByteBuf messageHeaderBuffer = this.stream.read(16, additionalTimeout);
        try {
            messageHeader = new MessageHeader(messageHeaderBuffer, this.description.getMaxMessageSize());
        }
        finally {
            messageHeaderBuffer.release();
        }
        ByteBuf messageBuffer = this.stream.read(messageHeader.getMessageLength() - 16, additionalTimeout);
        boolean releaseMessageBuffer = true;
        try {
            if (messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
                CompressedHeader compressedHeader = new CompressedHeader(messageBuffer, messageHeader);
                Compressor compressor = this.getCompressor(compressedHeader);
                ByteBuf buffer = this.getBuffer(compressedHeader.getUncompressedSize());
                compressor.uncompress(messageBuffer, buffer);
                buffer.flip();
                ResponseBuffers responseBuffers = new ResponseBuffers(new ReplyHeader(buffer, compressedHeader), buffer);
                return responseBuffers;
            }
            ResponseBuffers responseBuffers = new ResponseBuffers(new ReplyHeader(messageBuffer, messageHeader), messageBuffer);
            releaseMessageBuffer = false;
            ResponseBuffers responseBuffers2 = responseBuffers;
            return responseBuffers2;
        }
        finally {
            if (releaseMessageBuffer) {
                messageBuffer.release();
            }
        }
    }

    private Compressor getCompressor(CompressedHeader compressedHeader) {
        Compressor compressor = this.compressorMap.get(compressedHeader.getCompressorId());
        if (compressor == null) {
            throw new MongoClientException("Unsupported compressor with identifier " + compressedHeader.getCompressorId());
        }
        return compressor;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        Assertions.notNull("open", this.stream);
        return this.stream.getBuffer(size);
    }

    private CommandEventSender createCommandEventSender(CommandMessage message, ByteBufferBsonOutput bsonOutput, RequestContext requestContext) {
        if (!this.isMonitoringConnection && this.opened() && (this.commandListener != null || COMMAND_PROTOCOL_LOGGER.isRequired(StructuredLogMessage.Level.DEBUG, this.getClusterId()))) {
            return new LoggingCommandEventSender(SECURITY_SENSITIVE_COMMANDS, SECURITY_SENSITIVE_HELLO_COMMANDS, this.description, this.commandListener, requestContext, message, bsonOutput, COMMAND_PROTOCOL_LOGGER, this.loggerSettings);
        }
        return new NoOpCommandEventSender();
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private class MessageHeaderCallback
    implements SingleResultCallback<ByteBuf> {
        private final SingleResultCallback<ResponseBuffers> callback;

        MessageHeaderCallback(SingleResultCallback<ResponseBuffers> callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(@Nullable ByteBuf result, @Nullable Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
                return;
            }
            try {
                Assertions.assertNotNull(result);
                MessageHeader messageHeader = new MessageHeader(result, InternalStreamConnection.this.description.getMaxMessageSize());
                InternalStreamConnection.this.readAsync(messageHeader.getMessageLength() - 16, new MessageCallback(messageHeader));
            }
            catch (Throwable localThrowable) {
                this.callback.onResult(null, localThrowable);
            }
            finally {
                if (result != null) {
                    result.release();
                }
            }
        }

        private class MessageCallback
        implements SingleResultCallback<ByteBuf> {
            private final MessageHeader messageHeader;

            MessageCallback(MessageHeader messageHeader) {
                this.messageHeader = messageHeader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResult(@Nullable ByteBuf result, @Nullable Throwable t) {
                if (t != null) {
                    MessageHeaderCallback.this.callback.onResult(null, t);
                    return;
                }
                boolean releaseResult = true;
                Assertions.assertNotNull(result);
                try {
                    ByteBuf responseBuffer;
                    ReplyHeader replyHeader;
                    if (this.messageHeader.getOpCode() == OpCode.OP_COMPRESSED.getValue()) {
                        try {
                            CompressedHeader compressedHeader = new CompressedHeader(result, this.messageHeader);
                            Compressor compressor = InternalStreamConnection.this.getCompressor(compressedHeader);
                            ByteBuf buffer = InternalStreamConnection.this.getBuffer(compressedHeader.getUncompressedSize());
                            compressor.uncompress(result, buffer);
                            buffer.flip();
                            replyHeader = new ReplyHeader(buffer, compressedHeader);
                            responseBuffer = buffer;
                        }
                        finally {
                            releaseResult = false;
                            result.release();
                        }
                    } else {
                        replyHeader = new ReplyHeader(result, this.messageHeader);
                        responseBuffer = result;
                        releaseResult = false;
                    }
                    MessageHeaderCallback.this.callback.onResult(new ResponseBuffers(replyHeader, responseBuffer), null);
                }
                catch (Throwable localThrowable) {
                    MessageHeaderCallback.this.callback.onResult(null, localThrowable);
                }
                finally {
                    if (releaseResult) {
                        result.release();
                    }
                }
            }
        }
    }
}

