/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ScramShaAuthenticator;
import com.mongodb.internal.connection.SpeculativeAuthenticator;
import com.mongodb.lang.Nullable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

class DefaultAuthenticator
extends Authenticator
implements SpeculativeAuthenticator {
    static final int USER_NOT_FOUND_CODE = 11;
    private static final BsonString DEFAULT_MECHANISM_NAME = new BsonString(AuthenticationMechanism.SCRAM_SHA_256.getMechanismName());
    private Authenticator delegate;

    DefaultAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        Assertions.isTrueArgument("unspecified authentication mechanism", credential.getAuthenticationMechanism() == null);
    }

    @Override
    void authenticate(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext) {
        try {
            this.setDelegate(connectionDescription);
            this.delegate.authenticate(connection, connectionDescription, operationContext);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    void authenticateAsync(InternalConnection connection, ConnectionDescription connectionDescription, OperationContext operationContext, SingleResultCallback<Void> callback) {
        this.setDelegate(connectionDescription);
        this.delegate.authenticateAsync(connection, connectionDescription, operationContext, callback);
    }

    @Override
    public BsonDocument createSpeculativeAuthenticateCommand(InternalConnection connection) {
        this.delegate = this.getAuthenticatorForHello();
        return ((SpeculativeAuthenticator)((Object)this.delegate)).createSpeculativeAuthenticateCommand(connection);
    }

    @Override
    @Nullable
    public BsonDocument getSpeculativeAuthenticateResponse() {
        if (this.delegate != null) {
            return ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse();
        }
        return null;
    }

    @Override
    public void setSpeculativeAuthenticateResponse(BsonDocument response) {
        ((SpeculativeAuthenticator)((Object)this.delegate)).setSpeculativeAuthenticateResponse(response);
    }

    Authenticator getAuthenticatorForHello() {
        return new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_256), this.getClusterConnectionMode(), this.getServerApi());
    }

    private void setDelegate(ConnectionDescription connectionDescription) {
        if (this.delegate != null && ((SpeculativeAuthenticator)((Object)this.delegate)).getSpeculativeAuthenticateResponse() != null) {
            return;
        }
        if (connectionDescription.getSaslSupportedMechanisms() != null) {
            BsonArray saslSupportedMechs = connectionDescription.getSaslSupportedMechanisms();
            AuthenticationMechanism mechanism = saslSupportedMechs.contains((Object)DEFAULT_MECHANISM_NAME) ? AuthenticationMechanism.SCRAM_SHA_256 : AuthenticationMechanism.SCRAM_SHA_1;
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(mechanism), this.getClusterConnectionMode(), this.getServerApi());
        } else {
            this.delegate = new ScramShaAuthenticator(this.getMongoCredentialWithCache().withMechanism(AuthenticationMechanism.SCRAM_SHA_1), this.getClusterConnectionMode(), this.getServerApi());
        }
    }

    private MongoException wrapException(Throwable t) {
        if (t instanceof MongoSecurityException) {
            return (MongoSecurityException)t;
        }
        if (t instanceof MongoException && ((MongoException)t).getCode() == 11) {
            return new MongoSecurityException(this.getMongoCredential(), String.format("Exception authenticating %s", this.getMongoCredential()), t);
        }
        return Assertions.assertNotNull(MongoException.fromThrowable(t));
    }
}

