/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.scripting.velocity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.velocity.context.ChainedInternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.directive.Scope;
import org.apache.velocity.runtime.directive.StopCommand;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTStringLiteral;
import org.apache.velocity.runtime.parser.node.Node;
import org.apache.velocity.util.introspection.Info;
import org.mybatis.scripting.velocity.ParameterMappingCollector;

public class RepeatDirective
extends Directive {
    protected static final int MAX_IN_CLAUSE_SIZE = 1000;
    private String var;
    private String open = "";
    private String close = "";
    private String separator = "";
    protected Info uberInfo;

    public String getName() {
        return "repeat";
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        int n = node.jjtGetNumChildren() - 1;
        for (int i = 1; i < n; ++i) {
            Node child = node.jjtGetChild(i);
            if (i == 1) {
                if (child.getType() == 18) {
                    this.var = ((ASTReference)child).getRootString();
                    continue;
                }
                throw new TemplateInitException("Syntax error", this.getTemplateName(), this.getLine(), this.getColumn());
            }
            if (child.getType() == 8) {
                String value = (String)((ASTStringLiteral)child).value(context);
                switch (i) {
                    case 2: {
                        this.separator = value;
                        break;
                    }
                    case 3: {
                        this.open = value;
                        break;
                    }
                    case 4: {
                        this.close = value;
                        break;
                    }
                }
                continue;
            }
            throw new TemplateInitException("Syntax error", this.getTemplateName(), this.getLine(), this.getColumn());
        }
        this.uberInfo = new Info(this.getTemplateName(), this.getLine(), this.getColumn());
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        String content;
        Object listObject = node.jjtGetChild(0).value(context);
        if (listObject == null) {
            return false;
        }
        Iterator i = null;
        try {
            i = this.rsvc.getUberspect().getIterator(listObject, this.uberInfo);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ee) {
            String msg = "Error getting iterator for #repeat at " + this.uberInfo;
            this.rsvc.getLog().error((Object)msg, (Throwable)ee);
            throw new VelocityException(msg, (Throwable)ee);
        }
        if (i == null) {
            throw new VelocityException("Invalid collection");
        }
        int counter = 0;
        boolean maxNbrLoopsExceeded = false;
        Object o = context.get(this.var);
        ParameterMappingCollector collector = (ParameterMappingCollector)context.get("_pmc");
        String savedItemKey = collector.getItemKey();
        collector.setItemKey(this.var);
        RepeatScope foreach = new RepeatScope((Object)this, context.get(this.getName()), this.var);
        context.put(this.getName(), (Object)foreach);
        NullHolderContext nullHolderContext = null;
        StringWriter buffer = new StringWriter();
        while (!maxNbrLoopsExceeded && i.hasNext()) {
            Object value = i.next();
            this.put(context, this.var, value);
            ++foreach.index;
            foreach.hasNext = i.hasNext();
            try {
                if (value == null) {
                    if (nullHolderContext == null) {
                        nullHolderContext = new NullHolderContext(this.var, context);
                    }
                    node.jjtGetChild(node.jjtGetNumChildren() - 1).render((InternalContextAdapter)nullHolderContext, (Writer)buffer);
                } else {
                    node.jjtGetChild(node.jjtGetNumChildren() - 1).render(context, (Writer)buffer);
                }
            }
            catch (StopCommand stop) {
                if (stop.isFor((Object)this)) break;
                this.clean(context, o, collector, savedItemKey);
                buffer.close();
                throw stop;
            }
            boolean bl = maxNbrLoopsExceeded = ++counter >= 1000;
            if (!i.hasNext() || maxNbrLoopsExceeded) continue;
            buffer.append(this.separator);
        }
        if (!"".equals(content = buffer.toString().trim())) {
            writer.append(this.open);
            writer.append(content);
            writer.append(this.close);
        }
        this.clean(context, o, collector, savedItemKey);
        return true;
    }

    protected void clean(InternalContextAdapter context, Object o, ParameterMappingCollector collector, String savedItemKey) {
        if (o != null) {
            context.put(this.var, o);
        } else {
            context.remove((Object)this.var);
        }
        collector.setItemKey(savedItemKey);
        this.postRender(context);
    }

    protected void put(InternalContextAdapter context, String key, Object value) {
        context.put(key, value);
    }

    public int getType() {
        return 1;
    }

    public boolean isScopeProvided() {
        return true;
    }

    protected static class NullHolderContext
    extends ChainedInternalContextAdapter {
        private String loopVariableKey = "";
        private boolean active = true;

        protected NullHolderContext(String key, InternalContextAdapter context) {
            super(context);
            if (key != null) {
                this.loopVariableKey = key;
            }
        }

        public Object get(String key) throws MethodInvocationException {
            return this.active && this.loopVariableKey.equals(key) ? null : super.get(key);
        }

        public Object put(String key, Object value) {
            if (this.loopVariableKey.equals(key) && value == null) {
                this.active = true;
            }
            return super.put(key, value);
        }

        public Object localPut(String key, Object value) {
            return this.put(key, value);
        }

        public Object remove(Object key) {
            if (this.loopVariableKey.equals(key)) {
                this.active = false;
            }
            return super.remove(key);
        }
    }

    public static class RepeatScope
    extends Scope {
        protected int index = -1;
        protected boolean hasNext = false;
        protected final String var;

        public RepeatScope(Object newOwner, Object replaces, String newVar) {
            super(newOwner, replaces);
            this.var = newVar;
        }

        public int getIndex() {
            return this.index;
        }

        public int getCount() {
            return this.index + 1;
        }

        public boolean hasNext() {
            return this.getHasNext();
        }

        public boolean getHasNext() {
            return this.hasNext;
        }

        public boolean isFirst() {
            return this.index < 1;
        }

        public boolean getFirst() {
            return this.isFirst();
        }

        public boolean isLast() {
            return !this.hasNext;
        }

        public boolean getLast() {
            return this.isLast();
        }

        public String getVar() {
            return this.var;
        }
    }
}

