/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.net.pooling.BlockingPooledConnectionQueue;
import org.neo4j.driver.internal.net.pooling.PoolSettings;
import org.neo4j.driver.internal.net.pooling.PooledConnectionReleaseConsumer;
import org.neo4j.driver.internal.net.pooling.PooledConnectionValidator;
import org.neo4j.driver.internal.net.pooling.PooledSocketConnection;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionValidator;
import org.neo4j.driver.internal.spi.Connector;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Supplier;
import org.neo4j.driver.v1.Logging;

public class SocketConnectionPool
implements ConnectionPool {
    private final ConcurrentMap<BoltServerAddress, BlockingPooledConnectionQueue> pools = new ConcurrentHashMap<BoltServerAddress, BlockingPooledConnectionQueue>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final PoolSettings poolSettings;
    private final Connector connector;
    private final ConnectionValidator<PooledConnection> connectionValidator;
    private final Clock clock;
    private final Logging logging;

    public SocketConnectionPool(PoolSettings poolSettings, Connector connector, Clock clock, Logging logging) {
        this.poolSettings = poolSettings;
        this.connector = connector;
        this.connectionValidator = new PooledConnectionValidator(this);
        this.clock = clock;
        this.logging = logging;
    }

    @Override
    public PooledConnection acquire(BoltServerAddress address) {
        this.assertNotClosed();
        BlockingPooledConnectionQueue connectionQueue = this.pool(address);
        PooledConnection connection = this.acquireConnection(address, connectionQueue);
        this.assertNotClosed(address, connectionQueue);
        return connection;
    }

    @Override
    public void purge(BoltServerAddress address) {
        BlockingPooledConnectionQueue connections = (BlockingPooledConnectionQueue)this.pools.remove(address);
        if (connections != null) {
            connections.terminate();
        }
    }

    @Override
    public boolean hasAddress(BoltServerAddress address) {
        return this.pools.containsKey(address);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (BlockingPooledConnectionQueue pool : this.pools.values()) {
                pool.terminate();
            }
            this.pools.clear();
        }
    }

    public int activeConnections(BoltServerAddress address) {
        BlockingPooledConnectionQueue connectionQueue = (BlockingPooledConnectionQueue)this.pools.get(address);
        return connectionQueue == null ? 0 : connectionQueue.activeConnections();
    }

    private BlockingPooledConnectionQueue pool(BoltServerAddress address) {
        BlockingPooledConnectionQueue pool = (BlockingPooledConnectionQueue)this.pools.get(address);
        if (pool == null && this.pools.putIfAbsent(address, pool = new BlockingPooledConnectionQueue(address, this.poolSettings.maxIdleConnectionPoolSize(), this.logging)) != null) {
            return this.pool(address);
        }
        return pool;
    }

    private PooledConnection acquireConnection(BoltServerAddress address, BlockingPooledConnectionQueue connectionQueue) {
        boolean connectionCreated;
        ConnectionSupplier connectionSupplier = new ConnectionSupplier(connectionQueue, address);
        PooledConnection connection = null;
        do {
            if (connection == null) continue;
            connectionQueue.disposeBroken(connection);
        } while (!this.canBeAcquired(connection = connectionQueue.acquire(connectionSupplier), connectionCreated = connectionSupplier.connectionCreated()));
        return connection;
    }

    private boolean canBeAcquired(PooledConnection connection, boolean connectionCreated) {
        if (this.poolSettings.idleTimeBeforeConnectionTestConfigured()) {
            if (connectionCreated) {
                return true;
            }
            if (this.hasBeenIdleForTooLong(connection)) {
                return this.connectionValidator.isConnected(connection);
            }
        }
        return true;
    }

    private boolean hasBeenIdleForTooLong(PooledConnection connection) {
        long idleTime = this.clock.millis() - connection.lastUsedTimestamp();
        return idleTime > this.poolSettings.idleTimeBeforeConnectionTest();
    }

    private void assertNotClosed(BoltServerAddress address, BlockingPooledConnectionQueue connections) {
        if (this.closed.get()) {
            connections.terminate();
            this.pools.remove(address);
            this.assertNotClosed();
        }
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("Pool closed");
        }
    }

    private class ConnectionSupplier
    implements Supplier<PooledConnection> {
        final BlockingPooledConnectionQueue connectionQueue;
        final BoltServerAddress address;
        boolean connectionCreated;

        ConnectionSupplier(BlockingPooledConnectionQueue connectionQueue, BoltServerAddress address) {
            this.connectionQueue = connectionQueue;
            this.address = address;
        }

        @Override
        public PooledConnection get() {
            PooledConnectionReleaseConsumer releaseConsumer = new PooledConnectionReleaseConsumer(this.connectionQueue, SocketConnectionPool.this.connectionValidator);
            Connection connection = SocketConnectionPool.this.connector.connect(this.address);
            PooledSocketConnection pooledConnection = new PooledSocketConnection(connection, releaseConsumer, SocketConnectionPool.this.clock);
            this.connectionCreated = true;
            return pooledConnection;
        }

        boolean connectionCreated() {
            return this.connectionCreated;
        }
    }
}

