/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.internal.value.BytesValue;
import org.neo4j.driver.internal.value.FloatValue;
import org.neo4j.driver.internal.value.IntegerValue;
import org.neo4j.driver.internal.value.ListValue;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.internal.value.NullValue;
import org.neo4j.driver.internal.value.StringValue;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.ClientException;
import org.neo4j.driver.v1.types.Entity;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.neo4j.driver.v1.util.Function;

public abstract class Values {
    public static final Value EmptyMap = Values.value(Collections.emptyMap());
    public static final Value NULL = NullValue.NULL;
    private static final Function<Value, Object> OBJECT = new Function<Value, Object>(){

        @Override
        public Object apply(Value val) {
            return val.asObject();
        }
    };
    private static final Function<Value, Value> VALUE = new Function<Value, Value>(){

        @Override
        public Value apply(Value val) {
            return val;
        }
    };
    private static final Function<Value, Number> NUMBER = new Function<Value, Number>(){

        @Override
        public Number apply(Value val) {
            return val.asNumber();
        }
    };
    private static final Function<Value, String> STRING = new Function<Value, String>(){

        @Override
        public String apply(Value val) {
            return val.asString();
        }
    };
    private static final Function<Value, String> TO_STRING = new Function<Value, String>(){

        @Override
        public String apply(Value val) {
            return val.toString();
        }
    };
    private static final Function<Value, Integer> INTEGER = new Function<Value, Integer>(){

        @Override
        public Integer apply(Value val) {
            return val.asInt();
        }
    };
    private static final Function<Value, Long> LONG = new Function<Value, Long>(){

        @Override
        public Long apply(Value val) {
            return val.asLong();
        }
    };
    private static final Function<Value, Float> FLOAT = new Function<Value, Float>(){

        @Override
        public Float apply(Value val) {
            return Float.valueOf(val.asFloat());
        }
    };
    private static final Function<Value, Double> DOUBLE = new Function<Value, Double>(){

        @Override
        public Double apply(Value val) {
            return val.asDouble();
        }
    };
    private static final Function<Value, Boolean> BOOLEAN = new Function<Value, Boolean>(){

        @Override
        public Boolean apply(Value val) {
            return val.asBoolean();
        }
    };
    private static final Function<Value, Map<String, Object>> MAP = new Function<Value, Map<String, Object>>(){

        @Override
        public Map<String, Object> apply(Value val) {
            return val.asMap();
        }
    };
    private static final Function<Value, Long> ENTITY_ID = new Function<Value, Long>(){

        @Override
        public Long apply(Value val) {
            return val.asEntity().id();
        }
    };
    private static final Function<Value, Entity> ENTITY = new Function<Value, Entity>(){

        @Override
        public Entity apply(Value val) {
            return val.asEntity();
        }
    };
    private static final Function<Value, Node> NODE = new Function<Value, Node>(){

        @Override
        public Node apply(Value val) {
            return val.asNode();
        }
    };
    private static final Function<Value, Relationship> RELATIONSHIP = new Function<Value, Relationship>(){

        @Override
        public Relationship apply(Value val) {
            return val.asRelationship();
        }
    };
    private static final Function<Value, Path> PATH = new Function<Value, Path>(){

        @Override
        public Path apply(Value val) {
            return val.asPath();
        }
    };

    private Values() {
        throw new UnsupportedOperationException();
    }

    public static Value value(Object value) {
        if (value == null) {
            return NullValue.NULL;
        }
        if (value instanceof AsValue) {
            return ((AsValue)value).asValue();
        }
        if (value instanceof Boolean) {
            return Values.value((boolean)((Boolean)value));
        }
        if (value instanceof String) {
            return Values.value((String)value);
        }
        if (value instanceof Character) {
            return Values.value(((Character)value).charValue());
        }
        if (value instanceof Long) {
            return Values.value((long)((Long)value));
        }
        if (value instanceof Short) {
            return Values.value((int)((Short)value).shortValue());
        }
        if (value instanceof Byte) {
            return Values.value((int)((Byte)value).byteValue());
        }
        if (value instanceof Integer) {
            return Values.value((int)((Integer)value));
        }
        if (value instanceof Double) {
            return Values.value((double)((Double)value));
        }
        if (value instanceof Float) {
            return Values.value((double)((Float)value).floatValue());
        }
        if (value instanceof List) {
            return Values.value((List)value);
        }
        if (value instanceof Map) {
            return Values.value((Map)value);
        }
        if (value instanceof Iterable) {
            return Values.value((Iterable)value);
        }
        if (value instanceof Iterator) {
            return Values.value((Iterator)value);
        }
        if (value instanceof byte[]) {
            return Values.value((byte[])value);
        }
        if (value instanceof boolean[]) {
            return Values.value((boolean[])value);
        }
        if (value instanceof String[]) {
            return Values.value((String[])value);
        }
        if (value instanceof long[]) {
            return Values.value((long[])value);
        }
        if (value instanceof int[]) {
            return Values.value((int[])value);
        }
        if (value instanceof double[]) {
            return Values.value((double[])value);
        }
        if (value instanceof float[]) {
            return Values.value((float[])value);
        }
        if (value instanceof Value[]) {
            return Values.value((Value[])value);
        }
        if (value instanceof Object[]) {
            return Values.value(Arrays.asList((Object[])value));
        }
        throw new ClientException("Unable to convert " + value.getClass().getName() + " to Neo4j Value.");
    }

    public static Value[] values(Object ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return values;
    }

    public static Value value(Value ... input) {
        int size = input.length;
        Value[] values = new Value[size];
        System.arraycopy(input, 0, values, 0, size);
        return new ListValue(values);
    }

    public static BytesValue value(byte ... input) {
        return new BytesValue(input);
    }

    public static Value value(String ... input) {
        Value[] values = new StringValue[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = new StringValue(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(boolean ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(char ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(long ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(int ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(double ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value(input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(float ... input) {
        Value[] values = new Value[input.length];
        for (int i = 0; i < input.length; ++i) {
            values[i] = Values.value((double)input[i]);
        }
        return new ListValue(values);
    }

    public static Value value(List<Object> vals) {
        Value[] values = new Value[vals.size()];
        int i = 0;
        for (Object val : vals) {
            values[i++] = Values.value(val);
        }
        return new ListValue(values);
    }

    public static Value value(Iterable<Object> val) {
        return Values.value(val.iterator());
    }

    public static Value value(Iterator<Object> val) {
        ArrayList<Value> values = new ArrayList<Value>();
        while (val.hasNext()) {
            values.add(Values.value(val.next()));
        }
        return new ListValue(values.toArray(new Value[values.size()]));
    }

    public static Value value(char val) {
        return new StringValue(String.valueOf(val));
    }

    public static Value value(String val) {
        return new StringValue(val);
    }

    public static Value value(long val) {
        return new IntegerValue(val);
    }

    public static Value value(int val) {
        return new IntegerValue(val);
    }

    public static Value value(double val) {
        return new FloatValue(val);
    }

    public static Value value(boolean val) {
        return BooleanValue.fromBoolean(val);
    }

    public static Value value(Map<String, Object> val) {
        HashMap<String, Value> asValues = new HashMap<String, Value>(val.size());
        for (Map.Entry<String, Object> entry : val.entrySet()) {
            asValues.put(entry.getKey(), Values.value(entry.getValue()));
        }
        return new MapValue(asValues);
    }

    public static Value parameters(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new ClientException("Parameters function requires an even number of arguments, alternating key and value. Arguments were: " + Arrays.toString(keysAndValues) + ".");
        }
        HashMap<String, Value> map = new HashMap<String, Value>(keysAndValues.length / 2);
        for (int i = 0; i < keysAndValues.length; i += 2) {
            Object value = keysAndValues[i + 1];
            Values.assertParameter(value);
            map.put(keysAndValues[i].toString(), Values.value(value));
        }
        return Values.value(map);
    }

    public static Function<Value, Value> ofValue() {
        return VALUE;
    }

    public static Function<Value, Object> ofObject() {
        return OBJECT;
    }

    public static Function<Value, Number> ofNumber() {
        return NUMBER;
    }

    public static Function<Value, String> ofString() {
        return STRING;
    }

    public static Function<Value, String> ofToString() {
        return TO_STRING;
    }

    public static Function<Value, Integer> ofInteger() {
        return INTEGER;
    }

    public static Function<Value, Long> ofLong() {
        return LONG;
    }

    public static Function<Value, Float> ofFloat() {
        return FLOAT;
    }

    public static Function<Value, Double> ofDouble() {
        return DOUBLE;
    }

    public static Function<Value, Boolean> ofBoolean() {
        return BOOLEAN;
    }

    public static Function<Value, Map<String, Object>> ofMap() {
        return MAP;
    }

    public static <T> Function<Value, Map<String, T>> ofMap(final Function<Value, T> valueConverter) {
        return new Function<Value, Map<String, T>>(){

            @Override
            public Map<String, T> apply(Value val) {
                return val.asMap(valueConverter);
            }
        };
    }

    public static Function<Value, Entity> ofEntity() {
        return ENTITY;
    }

    public static Function<Value, Long> ofEntityId() {
        return ENTITY_ID;
    }

    public static Function<Value, Node> ofNode() {
        return NODE;
    }

    public static Function<Value, Relationship> ofRelationship() {
        return RELATIONSHIP;
    }

    public static Function<Value, Path> ofPath() {
        return PATH;
    }

    public static Function<Value, List<Object>> ofList() {
        return new Function<Value, List<Object>>(){

            @Override
            public List<Object> apply(Value value) {
                return value.asList();
            }
        };
    }

    public static <T> Function<Value, List<T>> ofList(final Function<Value, T> innerMap) {
        return new Function<Value, List<T>>(){

            @Override
            public List<T> apply(Value value) {
                return value.asList(innerMap);
            }
        };
    }

    private static void assertParameter(Object value) {
        if (value instanceof Node) {
            throw new ClientException("Nodes can't be used as parameters.");
        }
        if (value instanceof Relationship) {
            throw new ClientException("Relationships can't be used as parameters.");
        }
        if (value instanceof Path) {
            throw new ClientException("Paths can't be used as parameters.");
        }
    }
}

