/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.time.Clock;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.async.connection.AuthorizationStateListener;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.async.inbound.ConnectionReadTimeoutHandler;
import org.neo4j.driver.internal.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.async.pool.AuthContext;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.handlers.PingResponseHandler;
import org.neo4j.driver.internal.messaging.request.ResetMessage;
import org.neo4j.driver.internal.messaging.v51.BoltProtocolV51;

public class NettyChannelHealthChecker
implements ChannelHealthChecker,
AuthorizationStateListener {
    private final PoolSettings poolSettings;
    private final Clock clock;
    private final Logging logging;
    private final Logger log;
    private final AtomicLong minAuthTimestamp;

    public NettyChannelHealthChecker(PoolSettings poolSettings, Clock clock, Logging logging) {
        this.poolSettings = poolSettings;
        this.clock = clock;
        this.logging = logging;
        this.log = logging.getLog(this.getClass());
        this.minAuthTimestamp = new AtomicLong(-1L);
    }

    public Future<Boolean> isHealthy(Channel channel) {
        if (this.isTooOld(channel)) {
            return channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
        }
        Promise result = channel.eventLoop().newPromise();
        ACTIVE.isHealthy(channel).addListener(future -> {
            if (future.isCancelled()) {
                result.setSuccess((Object)Boolean.FALSE);
            } else if (!future.isSuccess()) {
                Throwable throwable2 = future.cause();
                if (throwable2 != null) {
                    result.setFailure(throwable2);
                } else {
                    result.setSuccess((Object)Boolean.FALSE);
                }
            } else if (!((Boolean)future.get()).booleanValue()) {
                result.setSuccess((Object)Boolean.FALSE);
            } else {
                ChannelAttributes.authContext(channel).getAuthTokenManager().getToken().whenCompleteAsync((authToken, throwable) -> {
                    if (throwable != null || authToken == null) {
                        result.setSuccess((Object)Boolean.FALSE);
                    } else {
                        AuthContext authContext = ChannelAttributes.authContext(channel);
                        if (authContext.getAuthTimestamp() != null) {
                            authContext.setValidToken((AuthToken)authToken);
                            boolean equal = authToken.equals(authContext.getAuthToken());
                            if (this.isAuthExpiredByFailure(channel) || !equal) {
                                if (BoltProtocolV51.VERSION.compareTo(ChannelAttributes.protocolVersion(channel)) > 0) {
                                    result.setSuccess((Object)Boolean.FALSE);
                                } else {
                                    authContext.markPendingLogoff();
                                    Future downstreamCheck = this.hasBeenIdleForTooLong(channel) ? this.ping(channel) : channel.eventLoop().newSucceededFuture((Object)Boolean.TRUE);
                                    downstreamCheck.addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{result}));
                                }
                            } else {
                                Future downstreamCheck = this.hasBeenIdleForTooLong(channel) ? this.ping(channel) : channel.eventLoop().newSucceededFuture((Object)Boolean.TRUE);
                                downstreamCheck.addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{result}));
                            }
                        } else {
                            result.setSuccess((Object)Boolean.FALSE);
                        }
                    }
                }, (Executor)channel.eventLoop());
            }
        });
        return result;
    }

    private boolean isAuthExpiredByFailure(Channel channel) {
        Long authTimestamp = ChannelAttributes.authContext(channel).getAuthTimestamp();
        return authTimestamp != null && authTimestamp <= this.minAuthTimestamp.get();
    }

    @Override
    public void onExpired() {
        long now = this.clock.millis();
        this.minAuthTimestamp.getAndUpdate(prev -> Math.max(prev, now));
    }

    private boolean isTooOld(Channel channel) {
        if (this.poolSettings.maxConnectionLifetimeEnabled()) {
            long maxAgeMillis;
            boolean tooOld;
            long creationTimestampMillis = ChannelAttributes.creationTimestamp(channel);
            long currentTimestampMillis = this.clock.millis();
            long ageMillis = currentTimestampMillis - creationTimestampMillis;
            boolean bl = tooOld = ageMillis > (maxAgeMillis = this.poolSettings.maxConnectionLifetime());
            if (tooOld) {
                this.log.trace("Failed acquire channel %s from the pool because it is too old: %s > %s", channel, ageMillis, maxAgeMillis);
            }
            return tooOld;
        }
        return false;
    }

    private boolean hasBeenIdleForTooLong(Channel channel) {
        Long lastUsedTimestamp;
        if (this.poolSettings.idleTimeBeforeConnectionTestEnabled() && (lastUsedTimestamp = ChannelAttributes.lastUsedTimestamp(channel)) != null) {
            boolean idleTooLong;
            long idleTime = this.clock.millis() - lastUsedTimestamp;
            boolean bl = idleTooLong = idleTime > this.poolSettings.idleTimeBeforeConnectionTest();
            if (idleTooLong) {
                this.log.trace("Channel %s has been idle for %s and needs a ping", channel, idleTime);
            }
            return idleTooLong;
        }
        return false;
    }

    private Future<Boolean> ping(Channel channel) {
        Promise result = channel.eventLoop().newPromise();
        InboundMessageDispatcher messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        messageDispatcher.enqueue(new PingResponseHandler((Promise<Boolean>)result, channel, this.logging));
        this.attachConnectionReadTimeoutHandler(channel, messageDispatcher);
        channel.writeAndFlush((Object)ResetMessage.RESET, channel.voidPromise());
        return result;
    }

    private void attachConnectionReadTimeoutHandler(Channel channel, InboundMessageDispatcher messageDispatcher) {
        ChannelAttributes.connectionReadTimeout(channel).ifPresent(connectionReadTimeout -> {
            ConnectionReadTimeoutHandler connectionReadTimeoutHandler = new ConnectionReadTimeoutHandler((long)connectionReadTimeout, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{connectionReadTimeoutHandler});
            this.log.debug("Added ConnectionReadTimeoutHandler", new Object[0]);
            messageDispatcher.setBeforeLastHandlerHook(messageType -> {
                channel.pipeline().remove((ChannelHandler)connectionReadTimeoutHandler);
                messageDispatcher.setBeforeLastHandlerHook(null);
                this.log.debug("Removed ConnectionReadTimeoutHandler", new Object[0]);
            });
        });
    }
}

