/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.List;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;

public class RoutingProcedureResponse {
    private final Query procedure;
    private final List<Record> records;
    private final Throwable error;

    public RoutingProcedureResponse(Query procedure, List<Record> records) {
        this(procedure, records, null);
    }

    public RoutingProcedureResponse(Query procedure, Throwable error) {
        this(procedure, null, error);
    }

    private RoutingProcedureResponse(Query procedure, List<Record> records, Throwable error) {
        this.procedure = procedure;
        this.records = records;
        this.error = error;
    }

    public boolean isSuccess() {
        return this.records != null;
    }

    public Query procedure() {
        return this.procedure;
    }

    public List<Record> records() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("Can't access records of a failed result", this.error);
        }
        return this.records;
    }

    public Throwable error() {
        if (this.isSuccess()) {
            throw new IllegalStateException("Can't access error of a succeeded result " + this.records);
        }
        return this.error;
    }
}

