/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.annotation.WebListener;
import org.omnifaces.cdi.eager.EagerBeansRepository;
import org.omnifaces.cdi.push.Socket;
import org.omnifaces.config.OmniFaces;
import org.omnifaces.eventlistener.DefaultServletContextListener;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.resourcehandler.GraphicResource;
import org.omnifaces.resourcehandler.ViewResourceHandler;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.cache.CacheInitializer;

@WebListener
public class ApplicationListener
extends DefaultServletContextListener {
    private static final Logger logger = Logger.getLogger(ApplicationListener.class.getName());
    private static final String ERROR_JSF_API_UNAVAILABLE = "JSF API is not available in this environment.";
    private static final String ERROR_JSF_API_INCOMPATIBLE = "JSF API of this environment is not JSF 2.3 compatible.";
    private static final String ERROR_CDI_API_UNAVAILABLE = "CDI API is not available in this environment.";
    private static final String ERROR_CDI_API_INCOMPATIBLE = "CDI API of this environment is not CDI 1.1 compatible.";
    private static final String ERROR_CDI_IMPL_UNAVAILABLE = "CDI BeanManager instance is not available in this environment.";

    @Override
    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        boolean skipDeploymentException = OmniFaces.skipDeploymentException(servletContext);
        if (!skipDeploymentException) {
            this.checkJSF23Available();
            this.checkCDI11Available();
        }
        try {
            CacheInitializer.loadProviderAndRegisterFilter(servletContext);
            FacesViews.addFacesServletMappings(servletContext);
            ViewResourceHandler.addFacesServletMappingsIfNecessary(servletContext);
            if (skipDeploymentException) {
                ApplicationListener.checkCDIImplAvailable();
            }
            EagerBeansRepository.instantiateApplicationScopedAndRegisterListenerIfNecessary(servletContext);
            GraphicResource.registerGraphicImageBeans();
            Socket.registerEndpointIfNecessary(servletContext);
        }
        catch (Exception | LinkageError e) {
            if (skipDeploymentException) {
                logger.log(Level.WARNING, String.format("OmniFaces failed to initialize! %s", e));
            }
            throw new IllegalStateException("OmniFaces failed to initialize! Report an issue to OmniFaces.", e);
        }
    }

    private void checkJSF23Available() {
        try {
            ApplicationListener.checkJSFAPIAvailable();
            ApplicationListener.checkJSF23Compatible();
        }
        catch (Exception | LinkageError e) {
            logger.severe("\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\u2588\u2591\u2580\u2591\u2591\u2591\u2591\u2580\u2588\u2580\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2588\u2580\u2591\u2591\u2591\u2591\u2591\u2580\u2588                                             \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2588 OmniFaces failed to initialize!             \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2588                                             \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2584\u2588\u2591\u2591\u2584\u2584\u2584\u2584\u2584\u2588 OmniFaces 3.x requires JSF 2.3,             \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2591\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2588 but none was found on this environment.     \u2590\n\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2584\u2591\u2591\u2591\u2591\u2591\u2591\u2584\u2588\u2591\u2591\u2591\u2591\u2588\u2588\u2588\u2588\u2584\u2591\u2591\u2591\u2591\u2591\u2584\u2588 Downgrade to OmniFaces 2.x or 1.1x.         \u2590\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
            throw e;
        }
    }

    private void checkCDI11Available() {
        try {
            ApplicationListener.checkCDIAPIAvailable();
            ApplicationListener.checkCDI11Compatible();
            ApplicationListener.checkCDIImplAvailable();
        }
        catch (Exception | LinkageError e) {
            logger.severe("\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\n\u258c                         \u2590\u2588     \u2590                                             \u2590\n\u258c    \u2584                  \u2584\u2588\u2593\u2588\u258c    \u2590 OmniFaces failed to initialize!             \u2590\n\u258c   \u2590\u2588\u2588\u2584               \u2584\u2593\u2591\u2591\u2593\u2593    \u2590                                             \u2590\n\u258c   \u2590\u2588\u2591\u2588\u2588\u2593            \u2593\u2593\u2591\u2591\u2591\u2593\u258c    \u2590 This OmniFaces version requires CDI,        \u2590\n\u258c   \u2590\u2588\u258c\u2591\u2593\u2588\u2588          \u2588\u2593\u2591\u2591\u2591\u2591\u2593     \u2590 but none was found on this environment.     \u2590\n\u258c    \u2593\u2588\u258c\u2591\u2591\u2593\u2588\u2584\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2584\u2588\u2588\u2588\u2593\u2591\u2593\u2588     \u2590                                             \u2590\n\u258c    \u2593\u2588\u2588\u258c\u2591\u2593\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2588\u2591\u2593\u258c     \u2590 OmniFaces 3.x requires a minimum of JSF 2.3.\u2590\n\u258c     \u2593\u2588\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2588\u2588      \u2590 Since this JSF version, the JSF managed bean\u2590\n\u258c     \u2593\u2588\u2588\u2593\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2588      \u2590 facility @ManagedBean is DEPRECATED in      \u2590\n\u258c     \u2590\u2588\u2593\u2591\u2591\u2591\u2591\u2591\u2591\u2588\u2593\u2591\u2591\u2593\u2588\u2591\u2591\u2591\u2591\u2593\u2588\u258c     \u2590 in favour of CDI and CDI has become a       \u2590\n\u258c     \u2593\u2588\u258c\u2591\u2593\u2588\u2593\u2593\u2588\u2588\u2593\u2591\u2588\u2593\u2593\u2593\u2593\u2593\u2591\u2593\u2588\u258c     \u2590 REQUIRED dependency for JSF 2.3.            \u2590\n\u258c     \u2593\u2593\u2591\u2593\u2588\u2588\u2588\u2588\u2588\u2588\u2593\u2591\u2593\u2588\u2588\u2588\u2593\u2593\u258c\u2591\u2588\u2593     \u2590                                             \u2590\n\u258c    \u2590\u2593\u2593\u2591\u2588\u2584\u2590\u2593\u258c\u2588\u2593\u2591\u2591\u2593\u2588\u2590\u2593\u258c\u2584\u2593\u2591\u2588\u2588     \u2590                                             \u2590\n\u258c    \u2593\u2588\u2593\u2591\u2593\u2588\u2584\u2584\u2584\u2588\u2593\u2591\u2591\u2593\u2588\u2584\u2584\u2584\u2588\u2593\u2591\u2588\u2588\u258c    \u2590                                             \u2590\n\u258c    \u2593\u2588\u258c\u2591\u2593\u2588\u2588\u2588\u2588\u2588\u2593\u2591\u2591\u2591\u2593\u2588\u2588\u2588\u2593\u2580\u2591\u2593\u2588\u2593    \u2590                                             \u2590\n\u258c   \u2590\u2593\u2588\u2591\u2591\u2591\u2580\u2593\u2588\u2588\u2580\u2591\u2591\u2591\u2591\u2591 \u2580\u2593\u2580\u2591\u2591\u2593\u2588\u2593    \u2590                                             \u2590\n\u258c   \u2593\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2584\u2584\u2584\u2584\u2580\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2593    \u2590                                             \u2590\n\u258c   \u2593\u2588\u258c\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2590\u258c\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2593\u258c   \u2590                                             \u2590\n\u258c   \u2593\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2584\u2580\u2580\u2580\u2580\u2584\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2588\u2593   \u2590                                             \u2590\n\u258c  \u2590\u2588\u258c\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2591\u2591\u2591\u2591\u2591\u2591\u2588\u2593\u258c  \u2590                                             \u2590\n\u258c  \u2593\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2588\u2588\u2593  \u2590                                             \u2590\n\u258c  \u2593\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2593\u2588\u2593  \u2590 You have 3 options:                         \u2590\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588 1. Downgrade to OmniFaces 1.x.              \u2590\n\u2588\u2591\u2580\u2591\u2591\u2591\u2591\u2580\u2588\u2580\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2580\u2588\u2580\u2591\u2591\u2591\u2591\u2591\u2580\u2588 2. Install CDI in this environment.         \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2588 3. Switch to a CDI capable environment.     \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2588                                             \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2584\u2588\u2591\u2591\u2584\u2584\u2584\u2584\u2584\u2588 For additional instructions, check          \u2590\n\u2588\u2591\u2591\u2590\u2588\u258c\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2591\u2588\u2588\u2588\u2588\u2591\u2591\u2591\u2591\u2591\u2591\u2591\u2588 https://omnifaces.org/cdi                   \u2590\n\u2588\u2591\u2591\u2591\u2588\u2591\u2591\u2591\u2588\u2584\u2591\u2591\u2591\u2591\u2591\u2591\u2584\u2588\u2591\u2591\u2591\u2591\u2588\u2588\u2588\u2588\u2584\u2591\u2591\u2591\u2591\u2591\u2584\u2588                                             \u2590\n\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588");
            throw e;
        }
    }

    private static void checkJSFAPIAvailable() {
        try {
            Reflection.toClass("javax.faces.webapp.FacesServlet");
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_JSF_API_UNAVAILABLE, e);
        }
    }

    private static void checkJSF23Compatible() {
        try {
            Reflection.toClass("javax.faces.annotation.FacesConfig");
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_JSF_API_INCOMPATIBLE, e);
        }
    }

    private static void checkCDIAPIAvailable() {
        try {
            Reflection.toClass("javax.enterprise.inject.spi.BeanManager");
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_CDI_API_UNAVAILABLE, e);
        }
    }

    private static void checkCDI11Compatible() {
        try {
            Reflection.toClass("javax.enterprise.inject.spi.CDI");
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_CDI_API_INCOMPATIBLE, e);
        }
    }

    private static void checkCDIImplAvailable() {
        try {
            Reflection.toClass("org.omnifaces.util.Beans").getMethod("getManager", new Class[0]).invoke(null, new Object[0]).toString();
        }
        catch (Exception | LinkageError e) {
            throw new IllegalStateException(ERROR_CDI_IMPL_UNAVAILABLE, e);
        }
    }
}

