/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.eager;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.omnifaces.cdi.eager.EagerBeansRepository;
import org.omnifaces.util.Servlets;

public class EagerBeansWebListener
implements HttpSessionListener,
ServletRequestListener {
    private static final Logger logger = Logger.getLogger(EagerBeansWebListener.class.getName());
    private static final String POSSIBLY_REQUEST_SCOPE_NOT_ACTIVE = "Could not instantiate eager request scoped beans for request %s. Possibly the CDI request scope is not active. If this is indeed the case, see JavaDoc on org.omnifaces.cdi.Eager on how to remedy this.";
    private static boolean sessionListenerDisabled;
    private static boolean requestListenerDisabled;

    static void disable() {
        sessionListenerDisabled = true;
        requestListenerDisabled = true;
    }

    public void sessionCreated(HttpSessionEvent event) {
        if (!sessionListenerDisabled && !EagerBeansRepository.getInstance().instantiateSessionScoped()) {
            sessionListenerDisabled = true;
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
        if (!requestListenerDisabled) {
            String uri = Servlets.getRequestRelativeURIWithoutPathParameters((HttpServletRequest)event.getServletRequest());
            try {
                if (!EagerBeansRepository.getInstance().instantiateByRequestURI(uri)) {
                    requestListenerDisabled = true;
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, String.format(POSSIBLY_REQUEST_SCOPE_NOT_ACTIVE, uri), e);
            }
        }
    }

    public void requestDestroyed(ServletRequestEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }
}

