/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.servlet.ServletContext;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.omnifaces.cdi.push.SocketChannelManager;
import org.omnifaces.cdi.push.SocketEndpoint;
import org.omnifaces.cdi.push.SocketFacesListener;
import org.omnifaces.component.script.ScriptFamily;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.cdi.push.Socket")
@ListenerFor(systemEventClass=PostAddToViewEvent.class)
@ResourceDependency(library="omnifaces", name="omnifaces.js", target="head")
public class Socket
extends ScriptFamily
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.omnifaces.cdi.push.Socket";
    public static final String PARAM_SOCKET_ENDPOINT_ENABLED = "org.omnifaces.SOCKET_ENDPOINT_ENABLED";
    private static final Pattern PATTERN_CHANNEL = Pattern.compile("[\\w.-]+");
    private static final String ERROR_EXPRESSION_DISALLOWED = "o:socket 'channel' and 'scope' attributes may not contain an EL expression.";
    private static final String ERROR_INVALID_USER = "o:socket 'user' attribute '%s' does not represent a valid user identifier. It must implement Serializable and preferably have low memory footprint. Suggestion: use #{request.remoteUser} or #{someLoggedInUser.id}.";
    private static final String ERROR_INVALID_CHANNEL = "o:socket 'channel' attribute '%s' does not represent a valid channel name. It is required and it may only contain alphanumeric characters, hyphens, underscores and periods.";
    private static final String ERROR_ENDPOINT_NOT_ENABLED = "o:socket endpoint is not enabled. You need to set web.xml context param 'org.omnifaces.SOCKET_ENDPOINT_ENABLED' with value 'true'.";
    private static final String SCRIPT_INIT = "OmniFaces.Util.addOnloadListener(function(){OmniFaces.Push.init('%s','%s',%s,%s,%s);});";
    private static final Collection<String> CONTAINS_EVERYTHING = Collections.unmodifiableList(new ArrayList<String>(){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean contains(Object object) {
            return true;
        }
    });
    private final State state = new State(this.getStateHelper());

    public void processEvent(ComponentSystemEvent event) {
        if (event instanceof PostAddToViewEvent) {
            SocketFacesListener.subscribeIfNecessary();
        }
    }

    public void setValueExpression(String name, ValueExpression binding) {
        Object user;
        if (PropertyKeys.channel.toString().equals(name) || PropertyKeys.scope.toString().equals(name)) {
            throw new IllegalArgumentException(ERROR_EXPRESSION_DISALLOWED);
        }
        if (PropertyKeys.user.toString().equals(name) && (user = binding.getValue(this.getFacesContext().getELContext())) != null && !(user instanceof Serializable)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_USER, user));
        }
        super.setValueExpression(name, binding);
    }

    public Collection<String> getEventNames() {
        return CONTAINS_EVERYTHING;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (!Boolean.TRUE.equals(FacesLocal.getApplicationAttribute(context, Socket.class.getName()))) {
            throw new IllegalStateException(ERROR_ENDPOINT_NOT_ENABLED);
        }
        if (SocketFacesListener.register(context, this)) {
            String channel = this.getChannel();
            if (channel == null || !PATTERN_CHANNEL.matcher(channel).matches()) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_CHANNEL, channel));
            }
            Integer port = this.getPort();
            String host = (port != null ? ":" + port : "") + FacesLocal.getRequestContextPath(context);
            String channelId = SocketChannelManager.getInstance().register(channel, this.getScope(), this.getUser());
            String functions = this.getOnopen() + "," + this.getOnmessage() + "," + this.getOnerror() + "," + this.getOnclose();
            String behaviors = this.getBehaviorScripts();
            boolean connected = this.isConnected();
            String script = String.format(SCRIPT_INIT, host, channelId, functions, behaviors, connected);
            context.getResponseWriter().write(script);
        }
    }

    private String getBehaviorScripts() {
        Map clientBehaviorsByEvent = this.getClientBehaviors();
        if (clientBehaviorsByEvent.isEmpty()) {
            return "{}";
        }
        String clientId = this.getClientId(this.getFacesContext());
        StringBuilder scripts = new StringBuilder("{");
        for (Map.Entry entry : clientBehaviorsByEvent.entrySet()) {
            String event = (String)entry.getKey();
            List clientBehaviors = (List)entry.getValue();
            scripts.append(scripts.length() > 1 ? "," : "").append(event).append(":[");
            for (int i = 0; i < clientBehaviors.size(); ++i) {
                scripts.append(i > 0 ? "," : "").append("function(event){");
                scripts.append(((ClientBehavior)clientBehaviors.get(i)).getScript(ClientBehaviorContext.createClientBehaviorContext((FacesContext)this.getFacesContext(), (UIComponent)this, (String)event, (String)clientId, null)));
                scripts.append("}");
            }
            scripts.append("]");
        }
        return scripts.append("}").toString();
    }

    public void decode(FacesContext context) {
        Map clientBehaviors = this.getClientBehaviors();
        if (clientBehaviors.isEmpty()) {
            return;
        }
        if (!this.getClientId(context).equals(FacesLocal.getRequestParameter(context, "javax.faces.source"))) {
            return;
        }
        List behaviors = (List)clientBehaviors.get(FacesLocal.getRequestParameter(context, "javax.faces.behavior.event"));
        if (behaviors == null) {
            return;
        }
        for (ClientBehavior behavior : behaviors) {
            behavior.decode(context, (UIComponent)this);
        }
    }

    public Integer getPort() {
        return (Integer)this.state.get((Serializable)((Object)PropertyKeys.port));
    }

    public void setPort(Integer port) {
        this.state.put((Serializable)((Object)PropertyKeys.port), port);
    }

    public String getChannel() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.channel));
    }

    public void setChannel(String channel) {
        this.state.put((Serializable)((Object)PropertyKeys.channel), channel);
    }

    public String getScope() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.scope));
    }

    public void setScope(String scope) {
        this.state.put((Serializable)((Object)PropertyKeys.scope), scope);
    }

    public Serializable getUser() {
        return (Serializable)this.state.get((Serializable)((Object)PropertyKeys.user));
    }

    public void setUser(Serializable user) {
        this.state.put((Serializable)((Object)PropertyKeys.user), user);
    }

    public String getOnopen() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.onopen));
    }

    public void setOnopen(String onopen) {
        this.state.put((Serializable)((Object)PropertyKeys.onopen), onopen);
    }

    public String getOnmessage() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.onmessage));
    }

    public void setOnmessage(String onmessage) {
        this.state.put((Serializable)((Object)PropertyKeys.onmessage), onmessage);
    }

    public String getOnerror() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.onerror));
    }

    public void setOnerror(String onerror) {
        this.state.put((Serializable)((Object)PropertyKeys.onerror), onerror);
    }

    public String getOnclose() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.onclose));
    }

    public void setOnclose(String onclose) {
        this.state.put((Serializable)((Object)PropertyKeys.onclose), onclose);
    }

    public boolean isConnected() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.connected), Boolean.TRUE);
    }

    public void setConnected(boolean connected) {
        this.state.put((Serializable)((Object)PropertyKeys.connected), connected);
    }

    public static void registerEndpointIfNecessary(ServletContext context) {
        if (Boolean.TRUE.equals(context.getAttribute(Socket.class.getName()))) {
            return;
        }
        if (!Boolean.parseBoolean(context.getInitParameter(PARAM_SOCKET_ENDPOINT_ENABLED))) {
            return;
        }
        try {
            ServerContainer container = (ServerContainer)context.getAttribute(ServerContainer.class.getName());
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(SocketEndpoint.class, (String)"/omnifaces.push/{channel}").build();
            container.addEndpoint(config);
            context.setAttribute(Socket.class.getName(), (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    private static enum PropertyKeys {
        port,
        channel,
        scope,
        user,
        onopen,
        onmessage,
        onerror,
        onclose,
        connected;

    }
}

