/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.omnifaces.cdi.push.SocketSessionManager;

public class SocketEndpoint
extends Endpoint {
    static final String PARAM_CHANNEL = "channel";
    public static final String URI_TEMPLATE = "/omnifaces.push/{channel}";
    private static final Logger logger = Logger.getLogger(SocketEndpoint.class.getName());
    private static final CloseReason REASON_UNKNOWN_CHANNEL = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "Unknown channel");
    private static final String ERROR_EXCEPTION = "SocketEndpoint: An exception occurred during processing web socket request.";

    public void onOpen(Session session, EndpointConfig config) {
        if (SocketSessionManager.getInstance().add(session)) {
            session.setMaxIdleTimeout(0L);
        } else {
            try {
                session.close(REASON_UNKNOWN_CHANNEL);
            }
            catch (IOException e) {
                this.onError(session, e);
            }
        }
    }

    public void onError(Session session, Throwable throwable) {
        if (session.isOpen()) {
            session.getUserProperties().put(Throwable.class.getName(), throwable);
        }
    }

    public void onClose(Session session, CloseReason reason) {
        SocketSessionManager.getInstance().remove(session, reason);
        Throwable throwable = (Throwable)session.getUserProperties().remove(Throwable.class.getName());
        if (throwable != null && reason.getCloseCode() != CloseReason.CloseCodes.GOING_AWAY) {
            logger.log(Level.SEVERE, ERROR_EXCEPTION, throwable);
        }
    }
}

