/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.Serializable;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;
import javax.websocket.CloseReason;

public final class SocketEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final Serializable user;
    private final Serializable previousUser;
    private final CloseReason.CloseCode code;

    SocketEvent(String channel, Serializable user, Serializable previousUser, CloseReason.CloseCode code) {
        this.channel = channel;
        this.user = user;
        this.previousUser = previousUser;
        this.code = code;
    }

    public String getChannel() {
        return this.channel;
    }

    public <S extends Serializable> S getUser() {
        return (S)this.user;
    }

    public <S extends Serializable> S getPreviousUser() {
        return (S)this.previousUser;
    }

    public CloseReason.CloseCode getCloseCode() {
        return this.code;
    }

    public int hashCode() {
        return super.hashCode() + Objects.hash(this.channel, this.user, this.code);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SocketEvent other = (SocketEvent)object;
        return Objects.equals(this.channel, other.channel) && Objects.equals(this.user, other.user) && Objects.equals(this.code, other.code);
    }

    public String toString() {
        return String.format("SocketEvent[channel=%s, user=%s, closeCode=%s]", this.channel, this.user, this.code);
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Closed {
        public static final AnnotationLiteral<Closed> LITERAL = new AnnotationLiteral<Closed>(){
            private static final long serialVersionUID = 1L;
        };
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Switched {
        public static final AnnotationLiteral<Switched> LITERAL = new AnnotationLiteral<Switched>(){
            private static final long serialVersionUID = 1L;
        };
    }

    @Qualifier
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Opened {
        public static final AnnotationLiteral<Opened> LITERAL = new AnnotationLiteral<Opened>(){
            private static final long serialVersionUID = 1L;
        };
    }
}

