/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.viewscope;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import org.omnifaces.cdi.BeanStorage;
import org.omnifaces.cdi.viewscope.ViewScopeStorage;
import org.omnifaces.util.Faces;
import org.omnifaces.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.omnifaces.util.concurrentlinkedhashmap.EvictionListener;

@SessionScoped
public class ViewScopeStorageInSession
implements ViewScopeStorage,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES = new String[]{"org.omnifaces.VIEW_SCOPE_MANAGER_MAX_ACTIVE_VIEW_SCOPES", "com.sun.faces.numberOfLogicalViews", "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION"};
    private static final String ERROR_MAX_ACTIVE_VIEW_SCOPES = "The '%s' init param must be a number. Encountered an invalid value of '%s'.";
    private static Integer maxActiveViewScopes;
    private ConcurrentMap<UUID, BeanStorage> activeViewScopes;

    @PostConstruct
    public void postConstructSession() {
        this.activeViewScopes = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(ViewScopeStorageInSession.getMaxActiveViewScopes()).listener(new BeanStorageEvictionListener()).build();
    }

    @Override
    public UUID getBeanStorageId() {
        UUID beanStorageId = (UUID)Faces.getViewAttribute(this.getClass().getName());
        return beanStorageId != null && this.activeViewScopes.containsKey(beanStorageId) ? beanStorageId : null;
    }

    @Override
    public BeanStorage getBeanStorage(UUID beanStorageId) {
        return (BeanStorage)this.activeViewScopes.get(beanStorageId);
    }

    @Override
    public void setBeanStorage(UUID beanStorageId, BeanStorage beanStorage) {
        this.activeViewScopes.put(beanStorageId, beanStorage);
        Faces.setViewAttribute(this.getClass().getName(), beanStorageId);
    }

    public void destroyBeans(UUID beanStorageId) {
        BeanStorage storage = (BeanStorage)this.activeViewScopes.remove(beanStorageId);
        if (storage != null) {
            storage.destroyBeans();
        }
    }

    @PreDestroy
    public void preDestroySession() {
        for (BeanStorage storage : this.activeViewScopes.values()) {
            storage.destroyBeans();
        }
    }

    private static int getMaxActiveViewScopes() {
        if (maxActiveViewScopes != null) {
            return maxActiveViewScopes;
        }
        for (String name : PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES) {
            String value = Faces.getInitParameter(name);
            if (value == null) continue;
            try {
                maxActiveViewScopes = Integer.valueOf(value);
                return maxActiveViewScopes;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format(ERROR_MAX_ACTIVE_VIEW_SCOPES, name, value), e);
            }
        }
        maxActiveViewScopes = 20;
        return maxActiveViewScopes;
    }

    private static final class BeanStorageEvictionListener
    implements EvictionListener<UUID, BeanStorage>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private BeanStorageEvictionListener() {
        }

        @Override
        public void onEviction(UUID id, BeanStorage storage) {
            storage.destroyBeans();
        }
    }
}

