/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.omnifaces.component.input.OnloadParam;
import org.omnifaces.event.HashChangeEvent;
import org.omnifaces.util.Beans;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Servlets;

@FacesComponent(value="org.omnifaces.component.input.HashParam")
public class HashParam
extends OnloadParam {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.HashParam";
    public static final String EVENT_VALUE = "setHashParamValues";
    private static final String SCRIPT_INIT = "OmniFaces.HashParam.init('%s')";
    private static final String SCRIPT_UPDATE = "OmniFaces.HashParam.update('%s', '%s')";

    @Override
    protected String getInitScript(FacesContext context) {
        return String.format(SCRIPT_INIT, this.getClientId(context));
    }

    @Override
    protected String getUpdateScript(FacesContext context) {
        return String.format(SCRIPT_UPDATE, this.getName(), this.getRenderedValue(context));
    }

    @Override
    protected String getEventValue(FacesContext context) {
        return EVENT_VALUE;
    }

    @Override
    protected void decodeAll(FacesContext context) {
        String oldHashQueryString = FacesLocal.getHashQueryString(context);
        Map<String, List<String>> hashParams = Servlets.toParameterMap(FacesLocal.getRequestParameter(context, "hash"));
        Iterator<HashParam> iterator = FacesLocal.getHashParameters(context).iterator();
        while (iterator.hasNext()) {
            HashParam hashParam;
            List<String> values = hashParams.get((hashParam = iterator.next()).getName());
            hashParam.decodeImmediately(context, values != null ? values.get(0) : "");
        }
        String newHashQueryString = FacesLocal.getHashQueryString(context);
        if (!Objects.equals(oldHashQueryString, newHashQueryString)) {
            Beans.fireEvent((Object)new HashChangeEvent(context, oldHashQueryString, newHashQueryString), new Annotation[0]);
        }
    }

    public String getRenderedValue(FacesContext context) {
        if (!this.isValid()) {
            return "";
        }
        Object value = this.getValue();
        Converter converter = this.getConverter();
        if (Objects.equals(value, this.getDefault())) {
            value = null;
        } else if (converter != null) {
            value = converter.getAsString(context, (UIComponent)this, value);
        }
        return value == null ? "" : value.toString();
    }

    public String getDefault() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.DEFAULT));
    }

    public void setDefault(String defaultValue) {
        this.state.put((Serializable)((Object)PropertyKeys.DEFAULT), defaultValue);
    }

    public static boolean isHashParamRequest(FacesContext context) {
        return HashParam.isOnloadParamRequest(context, EVENT_VALUE);
    }

    private static enum PropertyKeys {
        DEFAULT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

