/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.Serializable;
import javax.faces.component.UIViewParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Components;
import org.omnifaces.util.Events;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.State;

public abstract class OnloadParam
extends UIViewParameter {
    protected final State state = new State(this.getStateHelper());

    protected OnloadParam() {
        Events.subscribeToRequestBeforePhase(PhaseId.RENDER_RESPONSE, this::registerScriptsIfNecessary);
    }

    private void registerScriptsIfNecessary() {
        FacesContext context = this.getFacesContext();
        if (!this.isOnloadParamRequest(context)) {
            Components.addFormIfNecessary();
            Components.addScriptResource("javax.faces", "jsf.js");
            Components.addScriptResource("omnifaces", "omnifaces.js");
            if (!FacesLocal.isAjaxRequestWithPartialRendering(context)) {
                String initScript;
                if (FacesLocal.getRequestMap(context).put(((Object)((Object)this)).getClass().getName(), Boolean.TRUE) == null && (initScript = this.getInitScript(context)) != null) {
                    Components.addScript(initScript);
                }
            } else {
                String updateScript = this.getUpdateScript(context);
                if (updateScript != null) {
                    Components.addScript(updateScript);
                }
            }
        }
    }

    protected String getInitScript(FacesContext context) {
        return null;
    }

    protected String getUpdateScript(FacesContext context) {
        return null;
    }

    protected abstract String getEventValue(FacesContext var1);

    protected boolean isOnloadParamRequest(FacesContext context) {
        return OnloadParam.isOnloadParamRequest(context, this.getEventValue(context));
    }

    public void processDecodes(FacesContext context) {
        if (this.isOnloadParamRequest(context) && Ajax.isExecuted(this.getClientId(context))) {
            this.decodeAll(context);
            context.renderResponse();
        }
    }

    protected abstract void decodeAll(FacesContext var1);

    protected void decodeImmediately(FacesContext context, String submittedValue) {
        this.setSubmittedValue(submittedValue);
        this.validate(context);
        if (this.isValid()) {
            this.updateModel(context);
        } else {
            this.setValid(true);
        }
        String render = this.getRender();
        if (render != null) {
            Ajax.update(render.split("\\s+"));
        }
    }

    public void processValidators(FacesContext context) {
    }

    public void processUpdates(FacesContext context) {
    }

    public String getRender() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.RENDER), "@none");
    }

    public void setRender(String render) {
        this.state.put((Serializable)((Object)PropertyKeys.RENDER), render);
    }

    protected static boolean isOnloadParamRequest(FacesContext context, String onloadEvent) {
        return context.isPostback() && onloadEvent.equals(FacesLocal.getRequestParameter(context, "omnifaces.event"));
    }

    private static enum PropertyKeys {
        RENDER;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

