/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.Serializable;
import java.util.HashSet;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.context.FacesContext;
import org.omnifaces.cdi.PostScriptParam;
import org.omnifaces.component.input.OnloadParam;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Reflection;

@FacesComponent(value="org.omnifaces.component.input.ScriptParam")
public class ScriptParam
extends OnloadParam {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.ScriptParam";
    public static final String EVENT_VALUE = "setScriptParamValues";
    private static final String SCRIPT_INIT = "OmniFaces.ScriptParam.run('%s', %s)";

    @Override
    protected String getInitScript(FacesContext context) {
        StringBuilder scripts = new StringBuilder("{");
        for (ScriptParam scriptParam : FacesLocal.getScriptParameters(context)) {
            scripts.append("'").append(scriptParam.getClientId()).append("':").append(scriptParam.getScript()).append(',');
        }
        scripts.append("}");
        return String.format(SCRIPT_INIT, this.getClientId(), scripts);
    }

    @Override
    protected String getEventValue(FacesContext context) {
        return EVENT_VALUE;
    }

    @Override
    protected void decodeAll(FacesContext context) {
        HashSet<Object> beans = new HashSet<Object>();
        for (ScriptParam scriptParam : FacesLocal.getScriptParameters(context)) {
            String value = FacesLocal.getRequestParameter(context, scriptParam.getClientId());
            scriptParam.decodeImmediately(context, value);
            ValueExpression valueExpression = scriptParam.getValueExpression("value");
            if (valueExpression == null) continue;
            beans.add(ExpressionInspector.getValueReference(context.getELContext(), valueExpression).getBase());
        }
        for (ScriptParam scriptParam : beans) {
            Reflection.invokeMethods((Object)scriptParam, PostScriptParam.class);
        }
    }

    public String getScript() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.SCRIPT));
    }

    public void setScript(String script) {
        this.state.put((Serializable)((Object)PropertyKeys.SCRIPT), script);
    }

    public static boolean isScriptParamRequest(FacesContext context) {
        return ScriptParam.isOnloadParamRequest(context, EVENT_VALUE);
    }

    private static enum PropertyKeys {
        SCRIPT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

