/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.omnifaces.component.output.OutputFamily;
import org.omnifaces.component.output.Url;
import org.omnifaces.resourcehandler.ViewResourceHandler;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.output.SitemapUrl")
public class SitemapUrl
extends OutputFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.SitemapUrl";
    private static final String ERROR_INVALID_REQUEST = "o:sitemapUrl can only be used in a file registered in org.omnifaces.VIEW_RESOURCE_HANDLER_URIS context param.";
    private static final String ERROR_MISSING_VALUE_OR_VIEWID = "o:sitemapUrl 'value' or 'viewId' attribute must be set.";
    private static final String ERROR_INVALID_DOMAIN = "o:sitemapUrl 'domain' attribute '%s' does not represent a valid domain.";
    private static final String ERROR_INVALID_PRIORITY = "o:sitemapUrl 'priority' attribute '%s' must be between 0.0 and 1.0.";
    private final State state = new State(this.getStateHelper());

    public SitemapUrl() {
        if (Faces.isDevelopment() && !ViewResourceHandler.isViewResourceRequest(this.getFacesContext())) {
            throw new IllegalStateException(ERROR_INVALID_REQUEST);
        }
        this.setRendererType(null);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        context.getResponseWriter().startElement("url", (UIComponent)this);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        this.encodeLocation(context);
        this.encodeLastModified(context);
        this.encodeChangeFrequency(context);
        this.encodePriority(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        context.getResponseWriter().endElement("url");
    }

    protected void encodeLocation(FacesContext context) throws IOException {
        String loc;
        String value = this.getValue();
        List params = Components.getParams((UIComponent)this);
        if (value != null) {
            loc = context.getExternalContext().encodeResourceURL(Utils.formatURLWithQueryString(value, Servlets.toQueryString(params)));
        } else {
            String viewId = this.getViewId();
            if (viewId == null) {
                throw new IllegalArgumentException(ERROR_MISSING_VALUE_OR_VIEWID);
            }
            String uri = FacesLocal.getBookmarkableURL(context, viewId, params, false);
            loc = Url.getBookmarkableURLWithDomain(context, uri, this.getDomain(), ERROR_INVALID_DOMAIN);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("loc", (UIComponent)this);
        writer.writeText((Object)loc, value != null ? "value" : "viewId");
        writer.endElement("loc");
    }

    protected void encodeLastModified(FacesContext context) throws IOException {
        Temporal lastModified = this.getLastModified();
        if (lastModified != null) {
            if (lastModified instanceof LocalDateTime) {
                lastModified = ((LocalDateTime)lastModified).atZone(ZoneId.systemDefault());
            }
            if (lastModified instanceof ZonedDateTime) {
                lastModified = ((ZonedDateTime)lastModified).toOffsetDateTime();
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("lastmod", (UIComponent)this);
            writer.writeText((Object)lastModified.toString(), PropertyKeys.lastModified.name());
            writer.endElement("lastmod");
        }
    }

    protected void encodeChangeFrequency(FacesContext context) throws IOException {
        ChangeFrequency changeFrequency = this.getChangeFrequency();
        if (changeFrequency != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("changefreq", (UIComponent)this);
            writer.writeText((Object)changeFrequency, PropertyKeys.changeFrequency.name());
            writer.endElement("changefreq");
        }
    }

    protected void encodePriority(FacesContext context) throws IOException {
        BigDecimal priority = this.getPriority();
        if (priority != null) {
            if (priority.compareTo(BigDecimal.ZERO) < 0 || priority.compareTo(BigDecimal.ONE) > 0) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_PRIORITY, priority));
            }
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("priority", (UIComponent)this);
            writer.writeText((Object)priority, PropertyKeys.priority.name());
            writer.endElement("priority");
        }
    }

    public String getValue() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(String value) {
        this.state.put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getViewId() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.viewId));
    }

    public void setViewId(String viewId) {
        this.state.put((Serializable)((Object)PropertyKeys.viewId), viewId);
    }

    public String getDomain() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.domain), Faces.getRequestDomainURL());
    }

    public void setDomain(String domain) {
        this.state.put((Serializable)((Object)PropertyKeys.domain), domain);
    }

    public Temporal getLastModified() {
        return (Temporal)this.state.get((Serializable)((Object)PropertyKeys.lastModified));
    }

    public void setLastModified(Temporal lastModified) {
        this.state.put((Serializable)((Object)PropertyKeys.lastModified), lastModified);
    }

    public ChangeFrequency getChangeFrequency() {
        return (ChangeFrequency)((Object)this.state.get((Serializable)((Object)PropertyKeys.changeFrequency)));
    }

    public void setChangeFrequency(ChangeFrequency changeFrequency) {
        this.state.put((Serializable)((Object)PropertyKeys.changeFrequency), changeFrequency);
    }

    public BigDecimal getPriority() {
        return (BigDecimal)this.state.get((Serializable)((Object)PropertyKeys.priority));
    }

    public void setPriority(BigDecimal priority) {
        this.state.put((Serializable)((Object)PropertyKeys.priority), priority);
    }

    private static enum PropertyKeys {
        value,
        viewId,
        domain,
        lastModified,
        changeFrequency,
        priority;

    }

    public static enum ChangeFrequency {
        always,
        hourly,
        daily,
        weekly,
        monthly,
        yearly,
        never;

    }
}

