/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.output;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.omnifaces.component.output.OutputFamily;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.output.Url")
public class Url
extends OutputFamily {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.output.Url";
    private static final String ERROR_EXPRESSION_DISALLOWED = "A value expression is disallowed on 'var' attribute of Url.";
    private static final String ERROR_INVALID_DOMAIN = "o:url 'domain' attribute '%s' does not represent a valid domain.";
    private final State state = new State(this.getStateHelper());

    public void setValueExpression(String name, ValueExpression binding) {
        if (PropertyKeys.var.toString().equals(name)) {
            throw new IllegalArgumentException(ERROR_EXPRESSION_DISALLOWED);
        }
        super.setValueExpression(name, binding);
    }

    @Override
    public boolean getRendersChildren() {
        return false;
    }

    public void encodeEnd(FacesContext context) throws IOException {
        String url;
        String value = this.getValue();
        Map<String, List<String>> params = Components.getParams((UIComponent)this, this.isIncludeRequestParams(), this.isIncludeViewParams());
        String string = url = value != null ? context.getExternalContext().encodeResourceURL(Utils.formatURLWithQueryString(value, Servlets.toQueryString(params))) : this.getBookmarkableURLWithDomain(context, params);
        if (this.getVar() != null) {
            FacesLocal.setRequestAttribute(context, this.getVar(), url);
        } else {
            context.getResponseWriter().writeText((Object)url, null);
        }
    }

    private String getBookmarkableURLWithDomain(FacesContext context, Map<String, List<String>> params) {
        String uri = FacesLocal.getBookmarkableURL(context, this.getViewId(), params, false);
        String domain = this.getDomain();
        return Url.getBookmarkableURLWithDomain(context, uri, domain, ERROR_INVALID_DOMAIN);
    }

    static String getBookmarkableURLWithDomain(FacesContext context, String uri, String domain, String errorMessage) {
        if ("//".equals(domain)) {
            return FacesLocal.getRequestDomainURL(context).split(":", 2)[1] + uri;
        }
        if (!"/".equals(domain)) {
            String normalizedDomain = domain.contains("//") ? domain : "//" + domain;
            try {
                new URL(normalizedDomain.startsWith("//") ? "http:" + normalizedDomain : normalizedDomain);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format(errorMessage, domain), e);
            }
            return ResourcePaths.stripTrailingSlash(normalizedDomain) + uri;
        }
        return uri;
    }

    public String getVar() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.state.put((Serializable)((Object)PropertyKeys.var), var);
    }

    public String getValue() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(String value) {
        this.state.put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getViewId() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.viewId), this.getFacesContext().getViewRoot().getViewId());
    }

    public void setViewId(String viewId) {
        this.state.put((Serializable)((Object)PropertyKeys.viewId), viewId);
    }

    public String getDomain() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.domain), Faces.getRequestDomainURL());
    }

    public void setDomain(String domain) {
        this.state.put((Serializable)((Object)PropertyKeys.domain), domain);
    }

    public boolean isIncludeViewParams() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.includeViewParams), Boolean.FALSE);
    }

    public void setIncludeViewParams(boolean includeViewParams) {
        this.state.put((Serializable)((Object)PropertyKeys.includeViewParams), includeViewParams);
    }

    public boolean isIncludeRequestParams() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.includeRequestParams), Boolean.FALSE);
    }

    public void setIncludeRequestParams(boolean includeRequestParams) {
        this.state.put((Serializable)((Object)PropertyKeys.includeRequestParams), includeRequestParams);
    }

    private static enum PropertyKeys {
        var,
        value,
        viewId,
        domain,
        includeViewParams,
        includeRequestParams;

    }
}

