/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.tree;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.omnifaces.component.EditableValueHolderStateHelper;
import org.omnifaces.component.tree.TreeFamily;
import org.omnifaces.component.tree.TreeNode;
import org.omnifaces.event.FacesEventWrapper;
import org.omnifaces.model.tree.ListTreeModel;
import org.omnifaces.model.tree.TreeModel;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.component.tree.Tree")
public class Tree
extends TreeFamily
implements NamingContainer {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.tree.Tree";
    private static final String ERROR_EXPRESSION_DISALLOWED = "A value expression is disallowed on 'var' and 'varNode' attributes of Tree.";
    private static final String ERROR_INVALID_MODEL = "Tree accepts only model of type TreeModel. Encountered model of type '%s'.";
    private static final String ERROR_DUPLICATE_NODE = "TreeNode with level '%s' is already declared. Choose a different level or remove it.";
    private final State state = new State(this.getStateHelper());
    private TreeModel currentModel;
    private Map<Integer, TreeNode> nodes;
    private TreeModel currentModelNode;

    public String getContainerClientId(FacesContext context) {
        String currentModelNodeIndex;
        String containerClientId = super.getContainerClientId(context);
        String string = currentModelNodeIndex = this.currentModelNode != null ? this.currentModelNode.getIndex() : null;
        if (currentModelNodeIndex != null) {
            containerClientId = containerClientId + UINamingContainer.getSeparatorChar((FacesContext)context) + currentModelNodeIndex;
        }
        return containerClientId;
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (PropertyKeys.var.toString().equals(name) || PropertyKeys.varNode.toString().equals(name)) {
            throw new IllegalArgumentException(ERROR_EXPRESSION_DISALLOWED);
        }
        super.setValueExpression(name, binding);
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new TreeFacesEvent(event, this, this.getCurrentModelNode()));
    }

    @Override
    protected void validateHierarchy() {
        Components.validateHasNoParent((UIComponent)this, Tree.class);
        Components.validateHasChild((UIComponent)this, TreeNode.class);
        Components.validateHasOnlyChildren((UIComponent)this, TreeNode.class);
    }

    @Override
    protected void process(FacesContext context, PhaseId phaseId) {
        if (!this.isRendered()) {
            return;
        }
        boolean processValidations = phaseId == PhaseId.PROCESS_VALIDATIONS;
        this.process(context, this.getModel(phaseId), () -> {
            if (processValidations) {
                context.getApplication().publishEvent(context, PreValidateEvent.class, (Object)this);
            }
            this.processTreeNode(context, phaseId);
            if (processValidations) {
                context.getApplication().publishEvent(context, PostValidateEvent.class, (Object)this);
            }
            return null;
        });
    }

    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        TreeModel model = this.getModel(PhaseId.ANY_PHASE);
        if (model.isLeaf()) {
            return super.visitTree(context, callback);
        }
        return this.process(context.getFacesContext(), model, () -> {
            VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
            if (result == VisitResult.COMPLETE) {
                return true;
            }
            if (result == VisitResult.ACCEPT && !context.getSubtreeIdsToVisit((UIComponent)this).isEmpty()) {
                return this.visitTreeNode(context, callback);
            }
            return false;
        });
    }

    protected boolean isVisitable(VisitContext context) {
        return super.isVisitable(context) && !context.getHints().contains(VisitHint.SKIP_ITERATION);
    }

    public void broadcast(FacesEvent event) {
        if (event instanceof TreeFacesEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            TreeFacesEvent treeEvent = (TreeFacesEvent)event;
            FacesEvent wrapped = treeEvent.getWrapped();
            this.process(context, treeEvent.getNode(), () -> {
                UIComponent source = wrapped.getComponent();
                this.pushComponentToEL(context, Tree.getCompositeComponentParent((UIComponent)source));
                try {
                    source.broadcast(wrapped);
                }
                finally {
                    this.popComponentFromEL(context);
                }
                return null;
            });
        } else {
            super.broadcast(event);
        }
    }

    protected void processTreeNode(FacesContext context, PhaseId phaseId) {
        this.processTreeNode(phaseId, (TreeNode treeNode) -> {
            if (treeNode != null) {
                treeNode.process(context, phaseId);
            }
            return null;
        });
    }

    protected boolean visitTreeNode(VisitContext context, VisitCallback callback) {
        return this.processTreeNode(PhaseId.ANY_PHASE, (TreeNode treeNode) -> {
            if (treeNode != null) {
                return treeNode.visitTree(context, callback);
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R process(FacesContext context, TreeModel node, Callback.Returning<R> callback) {
        Object[] originalVars = this.captureOriginalVars(context);
        TreeModel originalModelNode = this.currentModelNode;
        this.pushComponentToEL(context, null);
        try {
            this.setCurrentModelNode(context, node);
            R r = callback.invoke();
            return r;
        }
        finally {
            this.popComponentFromEL(context);
            this.setCurrentModelNode(context, originalModelNode);
            this.setVars(context, originalVars);
        }
    }

    private <R> R processTreeNode(PhaseId phaseId, Callback.ReturningWithArgument<R, TreeNode> callback) {
        TreeNode treeNode = null;
        if (!this.currentModelNode.isLeaf() && (treeNode = this.getNodes(phaseId).get(this.currentModelNode.getLevel())) == null) {
            treeNode = this.getNodes(phaseId).get(null);
        }
        return callback.invoke(treeNode);
    }

    private Map<Integer, TreeNode> getNodes(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE || this.nodes == null) {
            this.nodes = new HashMap<Integer, TreeNode>(this.getChildCount());
            for (UIComponent child : this.getChildren()) {
                TreeNode node = (TreeNode)child;
                if (this.nodes.put(node.getLevel(), node) == null) continue;
                throw new IllegalStateException(String.format(ERROR_DUPLICATE_NODE, node.getLevel()));
            }
        }
        return this.nodes;
    }

    private TreeModel getModel(PhaseId phaseId) {
        if (phaseId == PhaseId.RENDER_RESPONSE || this.currentModel == null) {
            Object value = this.getValue();
            if (value == null) {
                this.currentModel = new ListTreeModel();
            } else if (value instanceof TreeModel) {
                this.currentModel = (TreeModel)value;
            } else {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_MODEL, value.getClass().getName()));
            }
        }
        return this.currentModel;
    }

    private Object[] captureOriginalVars(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String[] names = new String[]{this.getVar(), this.getVarNode()};
        Object[] vars = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            vars[i] = requestMap.get(names[i]);
        }
        return vars;
    }

    private void setVars(FacesContext context, Object ... vars) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String[] names = new String[]{this.getVar(), this.getVarNode()};
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            if (vars[i] != null) {
                requestMap.put(names[i], vars[i]);
                continue;
            }
            requestMap.remove(names[i]);
        }
    }

    protected void setCurrentModelNode(FacesContext context, TreeModel currentModelNode) {
        EditableValueHolderStateHelper.save(context, this.getStateHelper(), this.getFacetsAndChildren());
        this.currentModelNode = currentModelNode;
        this.setVars(context, currentModelNode != null ? currentModelNode.getData() : null, currentModelNode);
        EditableValueHolderStateHelper.restore(context, this.getStateHelper(), this.getFacetsAndChildren());
    }

    protected TreeModel getCurrentModelNode() {
        return this.currentModelNode;
    }

    public Object getValue() {
        return this.state.get((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.state.put((Serializable)((Object)PropertyKeys.value), value);
    }

    public String getVar() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.state.put((Serializable)((Object)PropertyKeys.var), var);
    }

    public String getVarNode() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.varNode));
    }

    public void setVarNode(String varNode) {
        this.state.put((Serializable)((Object)PropertyKeys.varNode), varNode);
    }

    private static class TreeFacesEvent
    extends FacesEventWrapper {
        private static final long serialVersionUID = 1L;
        private TreeModel node;

        public TreeFacesEvent(FacesEvent wrapped, Tree tree, TreeModel node) {
            super(wrapped, (UIComponent)tree);
            this.node = node;
        }

        public TreeModel getNode() {
            return this.node;
        }
    }

    private static enum PropertyKeys {
        value,
        var,
        varNode;

    }
}

