/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import org.omnifaces.component.validator.ValidatorFamily;
import org.omnifaces.config.OmniFaces;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;
import org.omnifaces.util.State;
import org.omnifaces.validator.MultiFieldValidator;

public abstract class ValidateMultipleFields
extends ValidatorFamily
implements MultiFieldValidator {
    private static final String DEFAULT_SHOWMESSAGEFOR = "@this";
    private static final Boolean DEFAULT_INVALIDATEALL = Boolean.TRUE;
    private static final Boolean DEFAULT_DISABLED = Boolean.FALSE;
    private static final String ERROR_MISSING_COMPONENTS = "%s attribute 'components' must be specified.";
    private static final String ERROR_UNKNOWN_COMPONENT = "%s attribute '%s' must refer existing client IDs. Client ID '%s' cannot be found.";
    private static final String ERROR_INVALID_COMPONENT = "%s attribute '%s' must refer UIInput client IDs. Client ID '%s' is of type '%s'.";
    private static final String ERROR_INVALID_COMPONENTS = "%s attribute '%s' must refer UIInput client IDs or any UIComponent which contains UIInput children. Client ID '%s' is of type '%s' and does not contain UIInput children.";
    private final State state = new State(this.getStateHelper());
    private String defaultMessage = OmniFaces.getMessage(this.getClass().getAnnotation(FacesComponent.class).value());
    private boolean validationFailed;

    protected ValidateMultipleFields() {
        this.setRendererType(null);
    }

    @Override
    protected void validateHierarchy() {
        Components.validateHasParent((UIComponent)this, UIForm.class);
        Components.validateHasNoChildren((UIComponent)this);
    }

    @Override
    protected void validateComponents(FacesContext context) {
        if (this.isDisabled()) {
            return;
        }
        List<UIInput> inputs = this.collectComponents();
        if (inputs.isEmpty()) {
            return;
        }
        List<Object> values = this.collectValues(inputs);
        if (!this.validateValues(context, inputs, values)) {
            int i = 0;
            for (UIInput input : inputs) {
                if (Components.isRendered((UIComponent)input)) {
                    input.setValid(!this.isInvalidateAll() && !this.shouldInvalidateInput(context, input, values.get(i)));
                    if (!input.isValid() && input.isLocalValueSet()) {
                        input.setSubmittedValue((Object)Faces.getRequestParameter(input.getClientId(context)));
                    }
                }
                ++i;
            }
            this.validationFailed = true;
            context.validationFailed();
            this.showMessage(context, inputs);
            context.renderResponse();
        }
    }

    protected List<UIInput> collectComponents() {
        String components = this.getComponents();
        if (components.isEmpty()) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_COMPONENTS, this.getClass().getSimpleName()));
        }
        UIComponent namingContainerParent = this.getNamingContainer();
        ArrayList<UIInput> inputs = new ArrayList<UIInput>();
        for (String clientId : components.split("\\s+")) {
            for (UIInput input : this.findInputComponents(namingContainerParent, clientId, PropertyKeys.components)) {
                if (!input.isValid()) {
                    return Collections.emptyList();
                }
                inputs.add(input);
            }
        }
        return Collections.unmodifiableList(inputs);
    }

    protected List<Object> collectValues(List<UIInput> inputs) {
        ArrayList values = new ArrayList(inputs.size());
        for (UIInput input : inputs) {
            Object value;
            Object object = value = Components.isEditable(input) ? Components.getValue((EditableValueHolder)input) : input.getValue();
            if (input instanceof UISelectBoolean && Boolean.FALSE.equals(value)) {
                value = null;
            }
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    protected boolean shouldInvalidateInput(FacesContext context, UIInput input, Object value) {
        return true;
    }

    protected void showMessage(FacesContext context, List<UIInput> inputs) {
        StringBuilder labels = new StringBuilder();
        Iterator<UIInput> iterator = inputs.iterator();
        while (iterator.hasNext()) {
            labels.append(Components.getLabel((UIComponent)iterator.next()));
            if (!iterator.hasNext()) continue;
            labels.append(", ");
        }
        this.addErrorMessage(context, inputs, labels, this.getMessage(), this.getShowMessageFor());
    }

    private UIInput findInputComponent(UIComponent parent, String clientId, PropertyKeys property) {
        UIComponent found = parent.findComponent(clientId);
        if (found == null) {
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_COMPONENT, new Object[]{this.getClass().getSimpleName(), property, clientId}));
        }
        if (!(found instanceof UIInput)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_COMPONENT, new Object[]{this.getClass().getSimpleName(), property, clientId, found.getClass().getName()}));
        }
        return (UIInput)found;
    }

    private List<UIInput> findInputComponents(UIComponent parent, String clientId, PropertyKeys property) {
        UIComponent found = parent.findComponent(clientId);
        if (found == null) {
            throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_COMPONENT, new Object[]{this.getClass().getSimpleName(), property, clientId}));
        }
        if (!(found instanceof UIInput)) {
            List<UIInput> inputs = Components.findComponentsInChildren(found, UIInput.class);
            if (inputs.isEmpty()) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_COMPONENTS, new Object[]{this.getClass().getSimpleName(), property, clientId, found.getClass().getName()}));
            }
            return inputs;
        }
        return Arrays.asList((UIInput)found);
    }

    private void addErrorMessage(FacesContext context, List<UIInput> inputs, StringBuilder labels, String message, String showMessageFor) {
        if (DEFAULT_SHOWMESSAGEFOR.equals(showMessageFor)) {
            Messages.addError(this.getClientId(context), message, labels);
        } else if ("@all".equals(showMessageFor)) {
            for (UIInput input : inputs) {
                Messages.addError(input.getClientId(context), message, labels);
            }
        } else if ("@invalid".equals(showMessageFor)) {
            for (UIInput input : inputs) {
                if (input.isValid()) continue;
                Messages.addError(input.getClientId(context), message, labels);
            }
        } else if ("@global".equals(showMessageFor)) {
            Messages.addGlobalError(message, labels);
        } else {
            UIComponent namingContainerParent = this.getNamingContainer();
            for (String clientId : showMessageFor.split("\\s+")) {
                UIInput input = this.findInputComponent(namingContainerParent, clientId, PropertyKeys.showMessageFor);
                Messages.addError(input.getClientId(context), message, labels);
            }
        }
    }

    public String getComponents() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.components), "");
    }

    public void setComponents(String components) {
        this.state.put((Serializable)((Object)PropertyKeys.components), components);
    }

    public boolean isInvalidateAll() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.invalidateAll), DEFAULT_INVALIDATEALL);
    }

    public void setInvalidateAll(boolean invalidateAll) {
        this.state.put((Serializable)((Object)PropertyKeys.invalidateAll), invalidateAll);
    }

    public String getMessage() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.message), this.defaultMessage);
    }

    public void setMessage(String message) {
        this.state.put((Serializable)((Object)PropertyKeys.message), message);
    }

    public String getShowMessageFor() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.showMessageFor), DEFAULT_SHOWMESSAGEFOR);
    }

    public void setShowMessageFor(String showMessageFor) {
        this.state.put((Serializable)((Object)PropertyKeys.showMessageFor), showMessageFor);
    }

    public boolean isDisabled() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.disabled), DEFAULT_DISABLED);
    }

    public void setDisabled(boolean disabled) {
        this.state.put((Serializable)((Object)PropertyKeys.disabled), disabled);
    }

    public boolean isValidationFailed() {
        return this.validationFailed;
    }

    private static enum PropertyKeys {
        components,
        invalidateAll,
        message,
        showMessageFor,
        disabled;

    }
}

