/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ResourceHandler;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omnifaces.config.FacesConfigXml;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

enum FacesConfigXmlSingleton implements FacesConfigXml
{
    INSTANCE;

    private static final String APP_FACES_CONFIG_XML = "/WEB-INF/faces-config.xml";
    private static final String LIB_FACES_CONFIG_XML = "META-INF/faces-config.xml";
    private static final String XPATH_RESOURCE_BUNDLE = "application/resource-bundle";
    private static final String XPATH_DEFAULT_LOCALE = "application/locale-config/default-locale";
    private static final String XPATH_SUPPORTED_LOCALE = "application/locale-config/supported-locale";
    private static final String XPATH_RESOURCE_HANDLER = "application/resource-handler";
    private static final String XPATH_VAR = "var";
    private static final String XPATH_BASE_NAME = "base-name";
    private static final String ERROR_INITIALIZATION_FAIL = "FacesConfigXml failed to initialize. Perhaps your faces-config.xml contains a typo?";
    private Map<String, String> resourceBundles;
    private List<Locale> supportedLocales;
    private List<Class<? extends ResourceHandler>> resourceHandlers;

    private FacesConfigXmlSingleton() {
        try {
            ServletContext servletContext = Servlets.getContext();
            Element facesConfigXml = FacesConfigXmlSingleton.loadFacesConfigXml(servletContext).getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.resourceBundles = FacesConfigXmlSingleton.parseResourceBundles(facesConfigXml, xpath);
            this.supportedLocales = FacesConfigXmlSingleton.parseSupportedLocales(facesConfigXml, xpath);
            this.resourceHandlers = FacesConfigXmlSingleton.parseResourceHandlers(facesConfigXml, xpath);
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_INITIALIZATION_FAIL, e);
        }
    }

    @Override
    public Map<String, String> getResourceBundles() {
        return this.resourceBundles;
    }

    @Override
    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public List<Class<? extends ResourceHandler>> getResourceHandlers() {
        return this.resourceHandlers;
    }

    private static Document loadFacesConfigXml(ServletContext context) throws IOException, SAXException {
        ArrayList<URL> facesConfigURLs = new ArrayList<URL>();
        facesConfigURLs.add(context.getResource(APP_FACES_CONFIG_XML));
        facesConfigURLs.addAll(Collections.list(Thread.currentThread().getContextClassLoader().getResources(LIB_FACES_CONFIG_XML)));
        return Xml.createDocument(facesConfigURLs);
    }

    private static Map<String, String> parseResourceBundles(Element facesConfigXml, XPath xpath) throws XPathExpressionException {
        LinkedHashMap<String, String> resourceBundles = new LinkedHashMap<String, String>();
        NodeList resourceBundleNodes = Xml.getNodeList(facesConfigXml, xpath, XPATH_RESOURCE_BUNDLE);
        for (int i = 0; i < resourceBundleNodes.getLength(); ++i) {
            Node node = resourceBundleNodes.item(i);
            String var = xpath.compile(XPATH_VAR).evaluate(node).trim();
            String baseName = xpath.compile(XPATH_BASE_NAME).evaluate(node).trim();
            resourceBundles.computeIfAbsent(var, k -> baseName);
        }
        return Collections.unmodifiableMap(resourceBundles);
    }

    private static List<Locale> parseSupportedLocales(Element facesConfigXml, XPath xpath) throws XPathExpressionException {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        String defaultLocale = xpath.compile(XPATH_DEFAULT_LOCALE).evaluate(facesConfigXml).trim();
        if (!Utils.isEmpty(defaultLocale)) {
            supportedLocales.add(Utils.parseLocale(defaultLocale));
        }
        NodeList supportedLocaleNodes = Xml.getNodeList(facesConfigXml, xpath, XPATH_SUPPORTED_LOCALE);
        for (int i = 0; i < supportedLocaleNodes.getLength(); ++i) {
            Locale supportedLocale = Utils.parseLocale(Xml.getTextContent(supportedLocaleNodes.item(i)));
            if (supportedLocales.contains(supportedLocale)) continue;
            supportedLocales.add(supportedLocale);
        }
        return Collections.unmodifiableList(supportedLocales);
    }

    private static List<Class<? extends ResourceHandler>> parseResourceHandlers(Element facesConfigXml, XPath xpath) throws XPathExpressionException {
        ArrayList resourceHandlers = new ArrayList();
        NodeList resourceHandlerNodes = Xml.getNodeList(facesConfigXml, xpath, XPATH_RESOURCE_HANDLER);
        for (int i = 0; i < resourceHandlerNodes.getLength(); ++i) {
            Class resourceHandler = Reflection.toClass(Xml.getTextContent(resourceHandlerNodes.item(i)));
            resourceHandlers.add(resourceHandler);
        }
        return Collections.unmodifiableList(resourceHandlers);
    }
}

