/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class OmniFaces {
    public static final String OMNIFACES_LIBRARY_NAME = "omnifaces";
    public static final String OMNIFACES_SCRIPT_NAME = "omnifaces.js";
    public static final String OMNIFACES_EVENT_PARAM_NAME = "omnifaces.event";
    public static final String OMNIFACES_DYNAMIC_FORM_ID = "omnifaces_form";
    public static final String PARAM_NAME_SKIP_DEPLOYMENT_EXCEPTION = "org.omnifaces.SKIP_DEPLOYMENT_EXCEPTION";
    private static final String VERSION = Utils.coalesce(OmniFaces.class.getPackage().getImplementationVersion(), "DEV-SNAPSHOT");
    private static final boolean SNAPSHOT = VERSION.contains("-");
    private static final Long STARTUP_TIME = System.currentTimeMillis();
    private static final String DEFAULT_MESSAGE_BUNDLE = "org.omnifaces.messages";

    private OmniFaces() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static boolean isSnapshot() {
        return SNAPSHOT;
    }

    public static long getStartupTime() {
        return STARTUP_TIME;
    }

    public static String getMessage(String key) {
        ResourceBundle messageBundle = Faces.getMessageBundle();
        if (messageBundle == null || !messageBundle.containsKey(key)) {
            messageBundle = ResourceBundle.getBundle(DEFAULT_MESSAGE_BUNDLE, Faces.getLocale());
        }
        return messageBundle.getString(key);
    }

    public static boolean skipDeploymentException(ServletContext servletContext) {
        return Boolean.parseBoolean(servletContext.getInitParameter(PARAM_NAME_SKIP_DEPLOYMENT_EXCEPTION));
    }
}

