/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.config;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omnifaces.config.WebXml;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

enum WebXmlSingleton implements WebXml
{
    INSTANCE;

    private static final String WEB_FRAGMENT_XML = "META-INF/web-fragment.xml";
    private static final String XPATH_WELCOME_FILE = "welcome-file-list/welcome-file";
    private static final String XPATH_EXCEPTION_TYPE = "error-page/exception-type";
    private static final String XPATH_LOCATION = "location";
    private static final String XPATH_ERROR_PAGE_500_LOCATION = "error-page[error-code=500]/location";
    private static final String XPATH_ERROR_PAGE_DEFAULT_LOCATION = "error-page[not(error-code) and not(exception-type)]/location";
    private static final String XPATH_FORM_LOGIN_PAGE = "login-config[auth-method='FORM']/form-login-config/form-login-page";
    private static final String XPATH_FORM_ERROR_PAGE = "login-config[auth-method='FORM']/form-login-config/form-error-page";
    private static final String XPATH_DEFAULT_FORM_LOGIN_PAGE = "login-config/form-login-config/form-login-page";
    private static final String XPATH_DEFAULT_FORM_ERROR_PAGE = "login-config/form-login-config/form-error-page";
    private static final String XPATH_SECURITY_CONSTRAINT = "security-constraint";
    private static final String XPATH_WEB_RESOURCE_URL_PATTERN = "web-resource-collection/url-pattern";
    private static final String XPATH_AUTH_CONSTRAINT = "auth-constraint";
    private static final String XPATH_AUTH_CONSTRAINT_ROLE_NAME = "auth-constraint/role-name";
    private static final String XPATH_SESSION_TIMEOUT = "session-config/session-timeout";
    private static final String XPATH_DISTRIBUTABLE = "boolean(distributable)";
    private static final String ERROR_URL_MUST_START_WITH_SLASH = "URL must start with '/': '%s'";
    private static final String ERROR_INITIALIZATION_FAIL = "WebXml failed to initialize. Perhaps your web.xml contains a typo?";
    private List<String> welcomeFiles;
    private Map<Class<Throwable>, String> errorPageLocations;
    private String formLoginPage;
    private String formErrorPage;
    private Map<String, Set<String>> securityConstraints;
    private int sessionTimeout;
    private boolean distributable;

    private WebXmlSingleton() {
        try {
            ServletContext servletContext = Servlets.getContext();
            Element allWebXmls = WebXmlSingleton.loadAllWebXmls(servletContext).getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            this.welcomeFiles = WebXmlSingleton.parseWelcomeFiles(allWebXmls, xpath);
            this.errorPageLocations = WebXmlSingleton.parseErrorPageLocations(allWebXmls, xpath);
            this.formLoginPage = WebXmlSingleton.parseFormLoginPage(allWebXmls, xpath);
            this.formErrorPage = WebXmlSingleton.parseFormErrorPage(allWebXmls, xpath);
            this.securityConstraints = WebXmlSingleton.parseSecurityConstraints(allWebXmls, xpath);
            this.sessionTimeout = WebXmlSingleton.parseSessionTimeout(allWebXmls, xpath);
            Element rootWebXml = WebXmlSingleton.loadRootWebXml(servletContext).getDocumentElement();
            this.distributable = WebXmlSingleton.parseDistributable(rootWebXml, xpath);
        }
        catch (Exception e) {
            throw new IllegalStateException(ERROR_INITIALIZATION_FAIL, e);
        }
    }

    @Override
    public String findErrorPageLocation(Throwable exception) {
        String location = null;
        for (Class<?> cls = exception.getClass(); cls != null && location == null; cls = cls.getSuperclass()) {
            location = this.errorPageLocations.get(cls);
        }
        return location == null ? this.errorPageLocations.get(null) : location;
    }

    @Override
    public boolean isAccessAllowed(String url, String role) {
        Set<String> roles;
        if (url.charAt(0) != '/') {
            throw new IllegalArgumentException(String.format(ERROR_URL_MUST_START_WITH_SLASH, url));
        }
        String uri = url;
        if (url.length() > 1 && url.charAt(url.length() - 1) == '/') {
            uri = url.substring(0, url.length() - 1);
        }
        if ((roles = this.findExactMatchRoles(uri)).isEmpty()) {
            roles = this.findPrefixMatchRoles(uri);
        }
        if (roles.isEmpty()) {
            roles = this.findSuffixMatchRoles(uri);
        }
        return WebXmlSingleton.isRoleMatch(roles, role);
    }

    private Set<String> findExactMatchRoles(String url) {
        for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
            if (!WebXmlSingleton.isExactMatch(entry.getKey(), url)) continue;
            return entry.getValue();
        }
        return Collections.emptySet();
    }

    private Set<String> findPrefixMatchRoles(String url) {
        String urlMatch = "";
        String path = url;
        while (!path.isEmpty()) {
            Set<String> roles = null;
            for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
                if (urlMatch.length() >= entry.getKey().length() || !WebXmlSingleton.isPrefixMatch(entry.getKey(), path)) continue;
                urlMatch = entry.getKey();
                roles = entry.getValue();
            }
            if (roles != null) {
                return roles;
            }
            path = path.substring(0, path.lastIndexOf(47));
        }
        return Collections.emptySet();
    }

    private Set<String> findSuffixMatchRoles(String url) {
        if (url.contains(".")) {
            for (Map.Entry<String, Set<String>> entry : this.securityConstraints.entrySet()) {
                if (!WebXmlSingleton.isSuffixMatch(url, entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return Collections.emptySet();
    }

    private static boolean isExactMatch(String urlPattern, String url) {
        return url.equals(urlPattern.endsWith("/*") ? urlPattern.substring(0, urlPattern.length() - 2) : urlPattern);
    }

    private static boolean isPrefixMatch(String urlPattern, String url) {
        return urlPattern.endsWith("/*") && (url + "/").startsWith(urlPattern.substring(0, urlPattern.length() - 1));
    }

    private static boolean isSuffixMatch(String urlPattern, String url) {
        return urlPattern.startsWith("*.") && url.endsWith(urlPattern.substring(1));
    }

    private static boolean isRoleMatch(Set<String> roles, String role) {
        return roles.isEmpty() || roles.contains(role) || role != null && roles.contains("*");
    }

    @Override
    public List<String> getWelcomeFiles() {
        return this.welcomeFiles;
    }

    @Override
    public Map<Class<Throwable>, String> getErrorPageLocations() {
        return this.errorPageLocations;
    }

    @Override
    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    @Override
    public String getFormErrorPage() {
        return this.formErrorPage;
    }

    @Override
    public Map<String, Set<String>> getSecurityConstraints() {
        return this.securityConstraints;
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public boolean isDistributable() {
        return this.distributable;
    }

    private static Document loadAllWebXmls(ServletContext context) throws IOException, SAXException {
        ArrayList<URL> webXmlURLs = new ArrayList<URL>();
        webXmlURLs.add(Servlets.getWebXmlURL(context));
        webXmlURLs.addAll(Collections.list(Thread.currentThread().getContextClassLoader().getResources(WEB_FRAGMENT_XML)));
        return Xml.createDocument(webXmlURLs);
    }

    private static Document loadRootWebXml(ServletContext context) throws IOException, SAXException {
        return Xml.createDocument(Arrays.asList(Servlets.getWebXmlURL(context)));
    }

    private static List<String> parseWelcomeFiles(Element webXml, XPath xpath) throws XPathExpressionException {
        NodeList welcomeFileList = Xml.getNodeList(webXml, xpath, XPATH_WELCOME_FILE);
        ArrayList<String> welcomeFiles = new ArrayList<String>(welcomeFileList.getLength());
        for (int i = 0; i < welcomeFileList.getLength(); ++i) {
            welcomeFiles.add(Xml.getTextContent(welcomeFileList.item(i)));
        }
        return Collections.unmodifiableList(welcomeFiles);
    }

    private static Map<Class<Throwable>, String> parseErrorPageLocations(Element webXml, XPath xpath) throws XPathExpressionException, ClassNotFoundException {
        HashMap<Class, String> errorPageLocations = new HashMap<Class, String>();
        NodeList exceptionTypes = Xml.getNodeList(webXml, xpath, XPATH_EXCEPTION_TYPE);
        for (int i = 0; i < exceptionTypes.getLength(); ++i) {
            Node node = exceptionTypes.item(i);
            Class<?> exceptionClass = Class.forName(Xml.getTextContent(node));
            String exceptionLocation = xpath.compile(XPATH_LOCATION).evaluate(node.getParentNode()).trim();
            Class<?> key = exceptionClass == Throwable.class ? null : exceptionClass;
            errorPageLocations.computeIfAbsent(key, k -> exceptionLocation);
        }
        if (!errorPageLocations.containsKey(null)) {
            String defaultLocation = xpath.compile(XPATH_ERROR_PAGE_500_LOCATION).evaluate(webXml).trim();
            if (Utils.isEmpty(defaultLocation)) {
                defaultLocation = xpath.compile(XPATH_ERROR_PAGE_DEFAULT_LOCATION).evaluate(webXml).trim();
            }
            if (!Utils.isEmpty(defaultLocation)) {
                errorPageLocations.put(null, defaultLocation);
            }
        }
        return Collections.unmodifiableMap(errorPageLocations);
    }

    private static String parseFormLoginPage(Element webXml, XPath xpath) throws XPathExpressionException {
        String formLoginPage = xpath.compile(XPATH_FORM_LOGIN_PAGE).evaluate(webXml).trim();
        if (Utils.isEmpty(formLoginPage)) {
            formLoginPage = xpath.compile(XPATH_DEFAULT_FORM_LOGIN_PAGE).evaluate(webXml).trim();
        }
        return Utils.isEmpty(formLoginPage) ? null : formLoginPage;
    }

    private static String parseFormErrorPage(Element webXml, XPath xpath) throws XPathExpressionException {
        String formErrorPage = xpath.compile(XPATH_FORM_ERROR_PAGE).evaluate(webXml).trim();
        if (Utils.isEmpty(formErrorPage)) {
            formErrorPage = xpath.compile(XPATH_DEFAULT_FORM_ERROR_PAGE).evaluate(webXml).trim();
        }
        return Utils.isEmpty(formErrorPage) ? null : formErrorPage;
    }

    private static Map<String, Set<String>> parseSecurityConstraints(Element webXml, XPath xpath) throws XPathExpressionException {
        LinkedHashMap securityConstraints = new LinkedHashMap();
        NodeList constraints = Xml.getNodeList(webXml, xpath, XPATH_SECURITY_CONSTRAINT);
        for (int i = 0; i < constraints.getLength(); ++i) {
            int j;
            Node constraint = constraints.item(i);
            Set roles = Collections.emptySet();
            NodeList auth = Xml.getNodeList(constraint, xpath, XPATH_AUTH_CONSTRAINT);
            if (auth.getLength() > 0) {
                NodeList authRoles = Xml.getNodeList(constraint, xpath, XPATH_AUTH_CONSTRAINT_ROLE_NAME);
                roles = new HashSet(authRoles.getLength());
                for (j = 0; j < authRoles.getLength(); ++j) {
                    roles.add(Xml.getTextContent(authRoles.item(j)));
                }
            }
            NodeList urlPatterns = Xml.getNodeList(constraint, xpath, XPATH_WEB_RESOURCE_URL_PATTERN);
            for (j = 0; j < urlPatterns.getLength(); ++j) {
                String urlPattern = Xml.getTextContent(urlPatterns.item(j));
                Set allRoles = (Set)securityConstraints.get(urlPattern);
                if (allRoles != null) {
                    allRoles = new HashSet(allRoles);
                    allRoles.addAll(roles);
                } else {
                    allRoles = roles;
                }
                securityConstraints.put(urlPattern, Collections.unmodifiableSet(allRoles));
            }
        }
        return Collections.unmodifiableMap(securityConstraints);
    }

    private static int parseSessionTimeout(Element webXml, XPath xpath) throws XPathExpressionException {
        String sessionTimeout = xpath.compile(XPATH_SESSION_TIMEOUT).evaluate(webXml).trim();
        return Utils.isNumber(sessionTimeout) ? Integer.parseInt(sessionTimeout) : -1;
    }

    private static boolean parseDistributable(Element webXml, XPath xpath) throws XPathExpressionException {
        String distributable = xpath.compile(XPATH_DISTRIBUTABLE).evaluate(webXml).trim();
        return Boolean.parseBoolean(distributable);
    }
}

