/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Utils;

@FacesConverter(value="omnifaces.GenericEnumConverter")
public class GenericEnumConverter
implements Converter<Enum> {
    private static final String ATTRIBUTE_ENUM_TYPE = "GenericEnumConverter.%s";
    private static final String ERROR_NO_ENUM_VALUE = "Given value ''{0}'' is not an enum of type ''{1}''.";

    public String getAsString(FacesContext context, UIComponent component, Enum modelValue) {
        if (modelValue == null) {
            return "-";
        }
        Class enumType = modelValue.getDeclaringClass();
        Faces.setViewAttribute(String.format(ATTRIBUTE_ENUM_TYPE, component.getClientId(context)), enumType);
        return modelValue.name();
    }

    public Enum getAsObject(FacesContext context, UIComponent component, String submittedValue) {
        if (Utils.isOneOf(submittedValue, null, "", "-")) {
            return null;
        }
        Class enumType = (Class)Faces.getViewAttribute(String.format(ATTRIBUTE_ENUM_TYPE, component.getClientId(context)));
        try {
            return Enum.valueOf(enumType, submittedValue);
        }
        catch (IllegalArgumentException e) {
            throw new ConverterException(Messages.createError(ERROR_NO_ENUM_VALUE, submittedValue, enumType), (Throwable)e);
        }
    }
}

