/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.omnifaces.util.Callback;

public class ReadOnlyValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private Callback.SerializableReturning<Object> callback;
    private Class<?> expectedType;

    public ReadOnlyValueExpression(Class<?> expectedType, Callback.SerializableReturning<Object> callback) {
        this(expectedType);
        this.callback = callback;
    }

    public ReadOnlyValueExpression(Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    public ReadOnlyValueExpression() {
    }

    public Object getValue(ELContext context) {
        if (this.callback != null) {
            return this.callback.invoke();
        }
        return null;
    }

    public void setValue(ELContext context, Object value) {
        throw new PropertyNotWritableException();
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public Class<?> getType(ELContext context) {
        Object value = this.getValue(context);
        return value == null ? null : value.getClass();
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        ReadOnlyValueExpression other = (ReadOnlyValueExpression)((Object)object);
        Object value = this.getValue(null);
        Object otherValue = other.getValue(null);
        return !(value == null ? otherValue != null : !value.equals(otherValue));
    }

    public int hashCode() {
        Object value = this.getValue(null);
        return value == null ? 0 : value.hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    public Callback.SerializableReturning<Object> getCallbackReturning() {
        return this.callback;
    }

    public void setCallbackReturning(Callback.SerializableReturning<Object> callbackReturning) {
        this.callback = callbackReturning;
    }
}

