/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el.functions;

import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class Dates {
    private static final Map<Locale, Map<String, Integer>> MONTHS_CACHE = new ConcurrentHashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> SHORT_MONTHS_CACHE = new ConcurrentHashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> DAYS_OF_WEEK_CACHE = new ConcurrentHashMap<Locale, Map<String, Integer>>(3);
    private static final Map<Locale, Map<String, Integer>> SHORT_DAYS_OF_WEEK_CACHE = new ConcurrentHashMap<Locale, Map<String, Integer>>(3);

    private Dates() {
    }

    public static <D> String formatDate(D date, String pattern) {
        return Dates.formatDateWithTimezone(date, pattern, Utils.getZoneId(date));
    }

    public static <D, Z> String formatDateWithTimezone(D date, String pattern, Z timezone) {
        if (date == null) {
            return null;
        }
        return DateTimeFormatter.ofPattern(pattern, Faces.getLocale()).withZone(Utils.toZoneId(timezone)).format(Utils.toZonedDateTime(date));
    }

    public static <D> D addYears(D date, int years) {
        return Dates.add(date, years, ChronoUnit.YEARS);
    }

    public static <D> D addMonths(D date, int months) {
        return Dates.add(date, months, ChronoUnit.MONTHS);
    }

    public static <D> D addWeeks(D date, int weeks) {
        return Dates.add(date, weeks, ChronoUnit.WEEKS);
    }

    public static <D> D addDays(D date, int days) {
        return Dates.add(date, days, ChronoUnit.DAYS);
    }

    public static <D> D addHours(D date, int hours) {
        return Dates.add(date, hours, ChronoUnit.HOURS);
    }

    public static <D> D addMinutes(D date, int minutes) {
        return Dates.add(date, minutes, ChronoUnit.MINUTES);
    }

    public static <D> D addSeconds(D date, int seconds) {
        return Dates.add(date, seconds, ChronoUnit.SECONDS);
    }

    private static <D> D add(D date, int amount, ChronoUnit unit) {
        return Utils.fromZonedDateTime(Utils.toZonedDateTime(date).plus(amount, unit), date.getClass());
    }

    public static <D> int yearsBetween(D start, D end) {
        return Dates.dateDiff(start, end, ChronoUnit.YEARS);
    }

    public static <D> int monthsBetween(D start, D end) {
        return Dates.dateDiff(start, end, ChronoUnit.MONTHS);
    }

    public static <D> int weeksBetween(D start, D end) {
        return Dates.dateDiff(start, end, ChronoUnit.WEEKS);
    }

    public static <D> int daysBetween(D start, D end) {
        return Dates.dateDiff(start, end, ChronoUnit.DAYS);
    }

    private static <D> int dateDiff(D start, D end, ChronoUnit unit) {
        return (int)unit.between(Utils.toZonedDateTime(start).truncatedTo(ChronoUnit.DAYS), Utils.toZonedDateTime(end).truncatedTo(ChronoUnit.DAYS));
    }

    public static <D> long hoursBetween(D start, D end) {
        return Dates.timeDiff(start, end, ChronoUnit.HOURS);
    }

    public static <D> long minutesBetween(D start, D end) {
        return Dates.timeDiff(start, end, ChronoUnit.MINUTES);
    }

    public static <D> long secondsBetween(D start, D end) {
        return Dates.timeDiff(start, end, ChronoUnit.SECONDS);
    }

    private static <D> long timeDiff(D start, D end, ChronoUnit unit) {
        return unit.between(Utils.toZonedDateTime(start), Utils.toZonedDateTime(end));
    }

    public static Map<String, Integer> getMonths() {
        Locale locale = Faces.getLocale();
        return MONTHS_CACHE.computeIfAbsent(locale, k -> Dates.mapMonths(TextStyle.FULL, locale));
    }

    public static Map<String, Integer> getShortMonths() {
        Locale locale = Faces.getLocale();
        return SHORT_MONTHS_CACHE.computeIfAbsent(locale, k -> Dates.mapMonths(TextStyle.SHORT, locale));
    }

    private static Map<String, Integer> mapMonths(TextStyle style, Locale locale) {
        return Arrays.stream(Month.values()).collect(Collectors.collectingAndThen(Collectors.toMap(month -> month.getDisplayName(style, locale), Month::getValue, (l, r) -> l, LinkedHashMap::new), Collections::unmodifiableMap));
    }

    public static Map<String, Integer> getDaysOfWeek() {
        Locale locale = Faces.getLocale();
        return DAYS_OF_WEEK_CACHE.computeIfAbsent(locale, k -> Dates.mapDaysOfWeek(TextStyle.FULL, locale));
    }

    public static Map<String, Integer> getShortDaysOfWeek() {
        Locale locale = Faces.getLocale();
        return SHORT_DAYS_OF_WEEK_CACHE.computeIfAbsent(locale, k -> Dates.mapDaysOfWeek(TextStyle.SHORT, locale));
    }

    private static Map<String, Integer> mapDaysOfWeek(TextStyle style, Locale locale) {
        return Arrays.stream(DayOfWeek.values()).collect(Collectors.collectingAndThen(Collectors.toMap(dayOfWeek -> dayOfWeek.getDisplayName(style, locale), DayOfWeek::getValue, (l, r) -> l, LinkedHashMap::new), Collections::unmodifiableMap));
    }

    public static String getMonth(Integer monthNumber) {
        return Dates.getKey(Dates.getMonths(), monthNumber);
    }

    public static String getShortMonth(Integer monthNumber) {
        return Dates.getKey(Dates.getShortMonths(), monthNumber);
    }

    public static String getDayOfWeek(Integer dayOfWeekNumber) {
        return Dates.getKey(Dates.getDaysOfWeek(), dayOfWeekNumber);
    }

    public static String getShortDayOfWeek(Integer dayOfWeekNumber) {
        return Dates.getKey(Dates.getShortDaysOfWeek(), dayOfWeekNumber);
    }

    private static <K, V> K getKey(Map<K, V> map, V value) {
        if (value == null) {
            return null;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }
}

