/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.eventlistener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import org.omnifaces.eventlistener.DefaultPhaseListener;
import org.omnifaces.util.Components;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Utils;

public class FacesRequestLogger
extends DefaultPhaseListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(FacesRequestLogger.class.getName());
    private static final Pattern PASSWORD_REQUEST_PARAMETER_PATTERN = Pattern.compile(".*(password|token)$", 2);

    public FacesRequestLogger() {
        super(PhaseId.ANY_PHASE);
    }

    @Override
    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        FacesRequestLogger.getPhaseTimer(context).start(event.getPhaseId());
    }

    @Override
    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        FacesRequestLogger.getPhaseTimer(context).stop(event.getPhaseId());
        if (event.getPhaseId() != PhaseId.RENDER_RESPONSE && !context.getResponseComplete() || !logger.isLoggable(Level.INFO)) {
            return;
        }
        try {
            logger.log(Level.INFO, () -> FacesLocal.getRequest(context).getMethod() + "=" + this.getLogDetails(context));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Logging failed", e);
        }
    }

    protected Map<String, Object> getLogDetails(FacesContext context) {
        LinkedHashMap<String, Object> logDetails = new LinkedHashMap<String, Object>();
        logDetails.put("url", FacesLocal.getRequestURIWithQueryString(context));
        logDetails.put("user", this.getUserDetails(context));
        logDetails.put("action", this.getActionDetails(context));
        logDetails.put("params", this.getRequestParameters(context));
        logDetails.put("messages", this.getFacesMessages(context));
        logDetails.put("timer", FacesRequestLogger.getPhaseTimer(context));
        return logDetails;
    }

    protected Map<String, Object> getUserDetails(FacesContext context) {
        LinkedHashMap<String, Object> userDetails = new LinkedHashMap<String, Object>();
        userDetails.put("ip", FacesLocal.getRemoteAddr(context));
        userDetails.put("login", FacesLocal.getRemoteUser(context));
        userDetails.put("session", FacesLocal.getSessionId(context));
        if (!context.getApplication().getStateManager().isSavingStateInClient(context)) {
            userDetails.put("viewState", FacesLocal.getRequestParameter(context, "javax.faces.ViewState"));
        }
        return userDetails;
    }

    protected Map<String, Object> getActionDetails(FacesContext context) {
        Object actionSource = Components.getCurrentActionSource();
        LinkedHashMap<String, Object> actionDetails = new LinkedHashMap<String, Object>();
        actionDetails.put("source", actionSource != null ? actionSource.getClientId(context) : null);
        actionDetails.put("event", Utils.coalesce(FacesLocal.getRequestParameter(context, "javax.faces.behavior.event"), FacesLocal.getRequestParameter(context, "omnifaces.event")));
        actionDetails.put("methods", Components.getActionExpressionsAndListeners(actionSource));
        actionDetails.put("validationFailed", context.isValidationFailed());
        return actionDetails;
    }

    protected Map<String, String> getRequestParameters(FacesContext context) {
        Set<Map.Entry<String, String[]>> params = FacesLocal.getRequestParameterValuesMap(context).entrySet();
        TreeMap<String, String> filteredParams = new TreeMap<String, String>();
        for (Map.Entry<String, String[]> entry : params) {
            String value;
            String name = entry.getKey();
            if (name.startsWith("javax.faces.")) continue;
            Object[] values = entry.getValue();
            String string = value = values != null && values.length == 1 ? values[0] : Arrays.toString(values);
            if (value != null && this.getPasswordRequestParameterPattern(context).matcher(name).matches()) {
                value = "********";
            }
            filteredParams.put(name, value);
        }
        return filteredParams;
    }

    protected Pattern getPasswordRequestParameterPattern(FacesContext context) {
        return PASSWORD_REQUEST_PARAMETER_PATTERN;
    }

    protected Map<String, List<String>> getFacesMessages(FacesContext context) {
        TreeMap<String, List<String>> facesMessages = new TreeMap<String, List<String>>();
        context.getMessages(null).forEachRemaining(FacesRequestLogger.collectGlobalMessageSummaries(facesMessages));
        context.getClientIdsWithMessages().forEachRemaining(FacesRequestLogger.collectMessageSummariesByClientId(context, facesMessages));
        return facesMessages;
    }

    private static Consumer<? super FacesMessage> collectGlobalMessageSummaries(Map<String, List<String>> facesMessages) {
        return message -> facesMessages.computeIfAbsent("", v -> new ArrayList()).add(message.getSummary());
    }

    private static Consumer<? super String> collectMessageSummariesByClientId(FacesContext context, Map<String, List<String>> facesMessages) {
        return clientId -> facesMessages.put(Utils.coalesce(clientId, ""), context.getMessageList(clientId).stream().map(FacesMessage::getSummary).collect(Collectors.toList()));
    }

    private static PhaseTimer getPhaseTimer(FacesContext context) {
        return FacesLocal.getRequestAttribute(context, PhaseTimer.class.getName(), () -> new PhaseTimer());
    }

    private static class PhaseTimer {
        private Map<Integer, Long> startTimes = new HashMap<Integer, Long>();
        private Map<Integer, Long> endTimes = new HashMap<Integer, Long>();

        private PhaseTimer() {
        }

        public void start(PhaseId phaseId) {
            this.startTimes.putIfAbsent(phaseId.getOrdinal(), System.nanoTime());
        }

        public void stop(PhaseId phaseId) {
            this.endTimes.put(phaseId.getOrdinal(), System.nanoTime());
        }

        public String getDuration(PhaseId phase) {
            Long startTime = this.startTimes.get(phase == PhaseId.ANY_PHASE ? PhaseId.RESTORE_VIEW.getOrdinal() : phase.getOrdinal());
            Long endTime = this.endTimes.get(phase == PhaseId.ANY_PHASE ? Collections.max(this.endTimes.keySet()) : Integer.valueOf(phase.getOrdinal()));
            return (startTime != null && endTime != null ? (endTime - startTime) / 1000000L : -1L) + "ms";
        }

        public String toString() {
            TreeMap<Integer, String> duration = new TreeMap<Integer, String>();
            for (PhaseId phase : PhaseId.VALUES) {
                duration.put(phase.getOrdinal(), this.getDuration(phase));
            }
            return ((Object)duration).toString();
        }
    }
}

