/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.exceptionhandler;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.view.ViewDeclarationLanguage;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.omnifaces.config.WebXml;
import org.omnifaces.context.OmniPartialViewContext;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.Utils;

public class FullAjaxExceptionHandler
extends ExceptionHandlerWrapper {
    public static final String PARAM_NAME_EXCEPTION_TYPES_TO_UNWRAP = "org.omnifaces.EXCEPTION_TYPES_TO_UNWRAP";
    public static final String PARAM_NAME_EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING = "org.omnifaces.EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING";
    public static final String EXCEPTION_UUID = "org.omnifaces.exception_uuid";
    private static final Logger logger = Logger.getLogger(FullAjaxExceptionHandler.class.getName());
    private static final Set<Class<? extends Throwable>> STANDARD_TYPES_TO_UNWRAP = Utils.unmodifiableSet(FacesException.class, ELException.class);
    private static final String ERROR_INVALID_EXCEPTION_TYPES_PARAM_CLASS = "Context parameter '%s' references a class which cannot be found in runtime classpath: '%s'";
    private static final String ERROR_DEFAULT_LOCATION_MISSING = "Either HTTP 500 or java.lang.Throwable error page is required in web.xml or web-fragment.xml. Neither was found.";
    private static final String LOG_EXCEPTION_HANDLED = "FullAjaxExceptionHandler: An exception occurred during processing JSF ajax request. Error page '%s' will be shown.";
    private static final String LOG_RENDER_EXCEPTION_HANDLED = "FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' will be shown.";
    private static final String LOG_RENDER_EXCEPTION_UNHANDLED = "FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' CANNOT be shown as response is already committed. Consider increasing 'javax.faces.FACELETS_BUFFER_SIZE' if it really needs to be handled.";
    private static final String LOG_ERROR_PAGE_ERROR = "FullAjaxExceptionHandler: Well, another exception occurred during rendering error page '%s'. Trying to render a hardcoded error page now.";
    private static final String ERROR_PAGE_ERROR = "<?xml version='1.0' encoding='UTF-8'?><partial-response id='error'><changes><update id='javax.faces.ViewRoot'><![CDATA[<html lang='en'><head><title>Error in error</title></head><body><section><h2>Oops!</h2><p>A problem occurred during processing the ajax request. Subsequently, another problem occurred during processing the error page which should inform you about that problem.</p><p>If you are the responsible web developer, it's time to read the server logs about the bug in the error page itself.</p></section></body></html>]]></update></changes></partial-response>";
    private Class<? extends Throwable>[] exceptionTypesToUnwrap = FullAjaxExceptionHandler.getExceptionTypesToUnwrap(Faces.getServletContext());
    private Class<? extends Throwable>[] exceptionTypesToIgnoreInLogging = FullAjaxExceptionHandler.getExceptionTypesToIgnoreInLogging(Faces.getServletContext());

    public FullAjaxExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    public static Class<? extends Throwable>[] getExceptionTypesToUnwrap(ServletContext context) {
        return FullAjaxExceptionHandler.parseExceptionTypesParam(context, PARAM_NAME_EXCEPTION_TYPES_TO_UNWRAP, STANDARD_TYPES_TO_UNWRAP);
    }

    public static Class<? extends Throwable>[] getExceptionTypesToIgnoreInLogging(ServletContext context) {
        return FullAjaxExceptionHandler.parseExceptionTypesParam(context, PARAM_NAME_EXCEPTION_TYPES_TO_IGNORE_IN_LOGGING, null);
    }

    static Class<? extends Throwable>[] parseExceptionTypesParam(ServletContext context, String paramName, Set<Class<? extends Throwable>> defaults) {
        String typesParam;
        HashSet types = new HashSet();
        if (defaults != null) {
            types.addAll(defaults);
        }
        if (!Utils.isEmpty(typesParam = context.getInitParameter(paramName))) {
            for (String typeParam : typesParam.split("\\s*,\\s*")) {
                try {
                    types.add(Class.forName(typeParam));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(String.format(ERROR_INVALID_EXCEPTION_TYPES_PARAM_CLASS, paramName, typeParam), e);
                }
            }
        }
        return types.toArray(new Class[types.size()]);
    }

    public void handle() {
        this.handleAjaxException(Faces.getContext());
        this.getWrapped().handle();
    }

    private void handleAjaxException(FacesContext context) {
        if (context == null) {
            return;
        }
        Iterator unhandledExceptionQueuedEvents = this.getUnhandledExceptionQueuedEvents().iterator();
        if (!unhandledExceptionQueuedEvents.hasNext()) {
            return;
        }
        Throwable exception = ((ExceptionQueuedEvent)unhandledExceptionQueuedEvents.next()).getContext().getException();
        if (exception instanceof AbortProcessingException) {
            return;
        }
        exception = this.findExceptionRootCause(context, exception);
        unhandledExceptionQueuedEvents.remove();
        if (!this.shouldHandleExceptionRootCause(context, exception)) {
            return;
        }
        String errorPageLocation = this.findErrorPageLocation(context, exception);
        if (errorPageLocation == null) {
            throw new IllegalArgumentException(ERROR_DEFAULT_LOCATION_MISSING);
        }
        if (!context.getPartialViewContext().isAjaxRequest()) {
            throw new FacesException(exception);
        }
        if (!this.canRenderErrorPageView(context, exception, errorPageLocation)) {
            return;
        }
        HttpServletRequest request = FacesLocal.getRequest(context);
        request.setAttribute("javax.servlet.error.exception", (Object)exception);
        request.setAttribute("javax.servlet.error.exception_type", exception.getClass());
        request.setAttribute("javax.servlet.error.message", (Object)exception.getMessage());
        request.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
        request.setAttribute("javax.servlet.error.status_code", (Object)500);
        try {
            this.renderErrorPageView(context, request, errorPageLocation);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        while (unhandledExceptionQueuedEvents.hasNext()) {
            unhandledExceptionQueuedEvents.next();
            unhandledExceptionQueuedEvents.remove();
        }
    }

    protected Throwable findExceptionRootCause(FacesContext context, Throwable exception) {
        return Exceptions.unwrap(exception, this.exceptionTypesToUnwrap);
    }

    protected boolean shouldHandleExceptionRootCause(FacesContext context, Throwable exception) {
        return true;
    }

    protected String findErrorPageLocation(FacesContext context, Throwable exception) {
        return WebXml.instance().findErrorPageLocation(exception);
    }

    protected void logException(FacesContext context, Throwable exception, String location, LogReason reason) {
        this.logException(context, exception, location, reason.getMessage(), location);
    }

    protected void logException(FacesContext context, Throwable exception, String location, String message, Object ... parameters) {
        if (!Utils.isOneInstanceOf(exception.getClass(), this.exceptionTypesToIgnoreInLogging)) {
            logger.log(Level.SEVERE, String.format("[%s][%s] %s", FacesLocal.getRequestAttribute(context, EXCEPTION_UUID), FacesLocal.getRemoteAddr(context), String.format(message, parameters)), exception);
        }
    }

    private boolean canRenderErrorPageView(FacesContext context, Throwable exception, String errorPageLocation) {
        FacesLocal.setRequestAttribute(context, EXCEPTION_UUID, UUID.randomUUID().toString());
        if (context.getCurrentPhaseId() != PhaseId.RENDER_RESPONSE) {
            this.logException(context, exception, errorPageLocation, LogReason.EXCEPTION_HANDLED);
            return true;
        }
        if (!context.getExternalContext().isResponseCommitted()) {
            this.logException(context, exception, errorPageLocation, LogReason.RENDER_EXCEPTION_HANDLED);
            this.resetResponse(context);
            return true;
        }
        this.logException(context, exception, errorPageLocation, LogReason.RENDER_EXCEPTION_UNHANDLED);
        OmniPartialViewContext.getCurrentInstance(context).closePartialResponse();
        return false;
    }

    private void resetResponse(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        String contentType = externalContext.getResponseContentType();
        String characterEncoding = externalContext.getResponseCharacterEncoding();
        externalContext.responseReset();
        OmniPartialViewContext.getCurrentInstance(context).resetPartialResponse();
        externalContext.setResponseContentType(contentType);
        externalContext.setResponseCharacterEncoding(characterEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderErrorPageView(FacesContext context, HttpServletRequest request, String errorPageLocation) throws IOException {
        block6: {
            String viewId = this.getViewIdAndPrepareParamsIfNecessary(context, errorPageLocation);
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            UIViewRoot viewRoot = viewHandler.createView(context, viewId);
            Hacks.removeResourceDependencyState(context);
            context.setViewRoot(viewRoot);
            context.getPartialViewContext().setRenderAll(true);
            try {
                ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
                vdl.buildView(context, viewRoot);
                context.getApplication().publishEvent(context, PreRenderViewEvent.class, (Object)viewRoot);
                vdl.renderView(context, viewRoot);
                context.responseComplete();
            }
            catch (Exception e) {
                this.logException(context, e, errorPageLocation, LogReason.ERROR_PAGE_ERROR);
                ExternalContext externalContext = context.getExternalContext();
                if (!externalContext.isResponseCommitted()) {
                    this.resetResponse(context);
                    externalContext.setResponseContentType("text/xml");
                    externalContext.getResponseOutputWriter().write(ERROR_PAGE_ERROR);
                    context.responseComplete();
                    break block6;
                }
                throw new FacesException((Throwable)e);
            }
            finally {
                request.removeAttribute("javax.servlet.error.exception");
            }
        }
    }

    private String getViewIdAndPrepareParamsIfNecessary(FacesContext context, String errorPageLocation) {
        String[] parts = errorPageLocation.split("\\?", 2);
        return FacesLocal.normalizeViewId(context, parts[0]);
    }

    protected static enum LogReason {
        EXCEPTION_HANDLED("FullAjaxExceptionHandler: An exception occurred during processing JSF ajax request. Error page '%s' will be shown."),
        RENDER_EXCEPTION_HANDLED("FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' will be shown."),
        RENDER_EXCEPTION_UNHANDLED("FullAjaxExceptionHandler: An exception occurred during rendering JSF ajax response. Error page '%s' CANNOT be shown as response is already committed. Consider increasing 'javax.faces.FACELETS_BUFFER_SIZE' if it really needs to be handled."),
        ERROR_PAGE_ERROR("FullAjaxExceptionHandler: Well, another exception occurred during rendering error page '%s'. Trying to render a hardcoded error page now.");

        private final String message;

        private LogReason(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

