/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.filter.HttpFilter;

public class CharacterEncodingFilter
extends HttpFilter {
    private static final String INIT_PARAM_ENCODING = "encoding";
    private static final Charset DEFAULT_ENCODING = StandardCharsets.UTF_8;
    private static final String ERROR_ENCODING = "The 'encoding' init param must represent a valid charset. Encountered an invalid charset of '%s'.";
    private Charset encoding = DEFAULT_ENCODING;

    @Override
    public void init() throws ServletException {
        String encodingParam = this.getInitParameter(INIT_PARAM_ENCODING);
        if (encodingParam != null) {
            try {
                this.encoding = Charset.forName(encodingParam);
            }
            catch (Exception e) {
                throw new ServletException(String.format(ERROR_ENCODING, encodingParam), (Throwable)e);
            }
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.encoding.name());
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

