/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Utils;

public class MutableRequestFilter
extends HttpFilter {
    public static final String MUTABLE_REQUEST = "org.omnifaces.mutable_request";
    private static final String ERROR_NOT_INSTALLED = "The MutableRequestFilter is not installed. Refer to its javadoc how to install it.";
    private static final String ERROR_NOT_AVAILABLE = "The MutableRequest is not available yet. This method should only be invoked *after* the MutableRequestFilter is invoked. If you are actually trying to invoke it from another filter, then try reordering the filters.";
    private static boolean installed;

    @Override
    public void init() throws ServletException {
        installed = true;
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        MutableRequest mutableRequest = new MutableRequest(request);
        request.setAttribute(MUTABLE_REQUEST, (Object)mutableRequest);
        chain.doFilter((ServletRequest)mutableRequest, (ServletResponse)response);
    }

    public static MutableRequest getMutableRequest(HttpServletRequest request) {
        MutableRequest mutableRequest = (MutableRequest)((Object)request.getAttribute(MUTABLE_REQUEST));
        if (mutableRequest == null) {
            throw new IllegalStateException(installed ? ERROR_NOT_AVAILABLE : ERROR_NOT_INSTALLED);
        }
        return mutableRequest;
    }

    public static class MutableRequest
    extends HttpServletRequestWrapper {
        private Map<String, List<String>> mutableHeaderMap;
        private Map<String, List<String>> mutableParameterMap;

        public MutableRequest(HttpServletRequest wrapped) {
            super(wrapped);
        }

        public Map<String, List<String>> getMutableHeaderMap() {
            if (this.mutableHeaderMap == null) {
                this.mutableHeaderMap = new HashMap<String, List<String>>();
                for (String name : Collections.list(super.getHeaderNames())) {
                    this.mutableHeaderMap.put(name, new ArrayList(Collections.list(super.getHeaders(name))));
                }
            }
            return this.mutableHeaderMap;
        }

        public String getHeader(String name) {
            List<String> values = this.getMutableHeaderMap().get(name);
            return Utils.isEmpty(values) ? null : values.get(0);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(this.getMutableHeaderMap().keySet());
        }

        public Enumeration<String> getHeaders(String name) {
            List<String> values = this.getMutableHeaderMap().get(name);
            return Collections.enumeration(values == null ? Collections.emptyList() : values);
        }

        public long getDateHeader(String name) {
            String value = this.getHeader(name);
            if (value == null) {
                return -1L;
            }
            try {
                return Utils.parseRFC1123(value).getTime();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        public int getIntHeader(String name) {
            String value = this.getHeader(name);
            return value == null ? -1 : Integer.parseInt(value);
        }

        public Map<String, List<String>> getMutableParameterMap() {
            if (this.mutableParameterMap == null) {
                this.mutableParameterMap = new HashMap<String, List<String>>();
                for (String name : Collections.list(super.getParameterNames())) {
                    this.mutableParameterMap.put(name, new ArrayList<String>(Arrays.asList(super.getParameterValues(name))));
                }
            }
            return this.mutableParameterMap;
        }

        public String getParameter(String name) {
            List<String> values = this.getMutableParameterMap().get(name);
            return Utils.isEmpty(values) ? null : values.get(0);
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.getMutableParameterMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> MutableRequest.toArray((List)entry.getValue()))));
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getMutableParameterMap().keySet());
        }

        public String[] getParameterValues(String name) {
            List<String> values = this.getMutableParameterMap().get(name);
            return Utils.isEmpty(values) ? null : MutableRequest.toArray(values);
        }

        private static String[] toArray(List<String> values) {
            return values.toArray(new String[values.size()]);
        }
    }
}

